#!/bin/bash
# ****************************************************
# Invoke FileMangler Application
# ****************************************************

# A) Create and export environment variables for 
#    communication with the target application.
IFS=$'\n'                                          # Internal Field Separator
export FMG_HOME=~/Apps/FileMangler                 # installation directory
export FMG_WD_FILE="$(mktemp --tmpdir FMG.XXX)"    # unique temporary file

# B) Establish the set of recognized exit codes:
FMG_ORIG_WD=0                       # exit to original (invocation) directory
FMG_CURR_WD=2                       # exit to directory specified in temp file

# C) Invoke the application:
#    a) installed binary executable, OR
#    b) binary executable in build directory (for application development)
$FMG_HOME/FileMangler $1 $2 $3 $4 $5 $6 $7 $8 $9 

# D) Check the application's exit code for exit to alternate directory.
FMG_EXIT="$?"                                # get exit code
if [ -f $FMG_WD_FILE ] ; then                # test existence of temp file
   if [ $FMG_EXIT -eq $FMG_CURR_WD ] ; then  # test return value
      cd "$(cat $FMG_WD_FILE)"               # change directory
   fi
   rm $FMG_WD_FILE                           # delete the temp file
fi
