//******************************************************************************
//* File       : gs_test.cpp                                                   *
//*                                                                            *
//* This is a simple test file to verify that the gString module has compiled  *
//* properly. It is not part of the gString source nor of the optional gString *
//* library. It is solely for testing the build.                               *
//*                                                                            *
//* Build using:  G++ / Gcc 13.2 (or higher) for Linux                         *
//*                                                                            *
//* Run using  : ./gs_test                                                     *
//******************************************************************************

#include <iostream>        //* Standard I/O definitions
#include "gString.hpp"     //* gString class definition

using namespace std ;                  //* Scope quailfier

//*************************
//*         main          *
//*************************
int main ( int argc, char* argv[], char* argenv[] )
{
   cout << "\ngs_test: version:1.1\n"
           "-------------------------------------------------------------------------" << endl ;

   //* Test instantiation, assignment and narrow/wide content *
   gString gsOut( "Both the gs_test app and the gString source should have "
                  "compiled without\nerror AND without warnings. "
                  "If not, please update to GCC 13.2 or higher.\n" ) ;
   wcout << gsOut.gstr() << endl ;
   wcout << L"gString-class version: " << gsOut.Get_gString_Version() << endl ;
   gsOut = "This is UTF-8 source data, output as UTF-8 bytes." ;
   cout << gsOut.ustr() << endl ;
   gsOut = L"This is 'wchar_t' source data, output as wide text." ;
   wcout << gsOut.gstr() << endl ;

   wcout << "\nbye-bye!\n" << endl ;

   return (0) ;

}  //* End main() *
