#!/usr/bin/perl
use strict ;
use warnings ;
use Term::ANSIColor ;

# ***********************************************#
# Report Conditional Compile Directives.         #
# Invoked from the Makefile: gmake buildlib      #
# or may be invoked directly: ./report.pl        #
# ********************************************** #
# Updated: 30-Jul-2025
# Author : Mahlon R. Smith
#          Copyright (c) 2022-2025 Mahlon R. Smith, The Software Samurai
#              GNU GPL copyright notice located in gString.cpp
# Developed under: Perl 5.36.1 (x86_64)

   # Source file containing the directives.
   my $SourceFile = "gString.hpp" ;

   # List of directives to scan.
   # Note that 'BACKWARD_COMPATIBILITY' declaration has been removed from 
   # the source code, and should not be reported.
   my @DirectiveList = 
      (
       "#define BACKWARD_COMPATIBILITY",
       "#define DEBUG_GSTRING",
      ) ;

   my $NoBump = "nobump" ; # suppress newline when called from within Makefile
   my $SearchString ;      # string to search for
   my $DebugString ;       # results of search
   my $strLength ;         # length of captured string

   print colored ( "Conditional Compilation Directives:", 'blue reverse' ) ;
   print "  " ;
   foreach my $i ( 0 .. $#DirectiveList )
   {
      $SearchString = $DirectiveList[$i] ;
      $DebugString = qx ( grep -hm 1 '$SearchString' '$SourceFile' 2>&1 ) ;
      chomp $DebugString ;
      $strLength = length($DebugString) ;
      if ( $strLength > 0 )
      { print colored ( "'$DebugString'  ", 'blue' ) ; }
   }
   print "\n" ;

   # If invoked from the command line, append a blank line.
   if ( (not defined $ARGV[0]) || ($ARGV[0] ne $NoBump) )
   { print "\n" ; }
