//******************************************************************************
//* File       : idpp_file.hpp                                                 *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2014-2020 Mahlon R. Smith, The Software Samurai *
//*                 GNU GPL copyright notice below                             *
//* Date       : 05-Dec-2019                                                   *
//* Version    : (see AppVersion string)                                       *
//*                                                                            *
//* Description: This module contains methods for accessing files to be        *
//* processed, extracting information about each item and creating the         *
//* modified output.                                                           *
//*                                                                            *
//* These methods are adapted from a small subset of the FMgr class written    *
//* for the FileMangler file-management project by the same author.            *
//******************************************************************************

//****************
//* Header Files *
//****************
#include <fstream>         // for file i/o
#include <sys/stat.h>      // for 'stat' info on target files
#include <dirent.h>        // for reading contents of 'directory type' files

//***************
//* Definitions *
//***************

#define ZERO         (0)
#define NULLCHAR     ('\0')

const short MAX_PATH  = PATH_MAX ;     //* Size of buffer to hold path/filename
const short MAX_FNAME = 256 ;          //* Size of buffer to hold a filename

//* Define the C structures as something C++ *
typedef struct dirent64 deStats ;
typedef struct stat64 FileStats ;
typedef struct tm Tm ;

//* File type encoded in the "st_mode" element of the stat{} structure *
enum fmFType : short 
{ fmDIR_TYPE,   fmREG_TYPE,  fmLINK_TYPE, fmCHDEV_TYPE, 
  fmBKDEV_TYPE, fmFIFO_TYPE, fmSOCK_TYPE, fmUNKNOWN_TYPE, fmTYPES } ;

//* Class for reporting the system local date/time *
class localTime
{
   public:
   localTime ( void )
   {
      day = date = month = year = hours = minutes = seconds = ZERO ;
      epoch = ZERO ;
   }
   uint16_t    day ;          //* Day of the week (1 == Sun, ..., 7 == Sat)
   uint16_t    date ;         //* Day of the month (1-[28|29|30|31])
   uint16_t    month ;        //* Month of the year (1 == Jan, ... 12 == Dec)
   uint16_t    year ;         //* Year (four digit year)
   uint16_t    hours ;        //* Time of day, hour (0-23)
   uint16_t    minutes ;      //* Time of day, minutes (0-59)
   uint16_t    seconds ;      //* Time of day, seconds (0-59)
   time_t      epoch ;        //* Seconds since the epoch (01-Jan-1970)
} ;

//* Class definition describing a file. *
class tnFName
{
   public:
   tnFName ( void )           //* Constructor
   {
      this->ReInit () ;       // initialize data members
   }
   void ReInit(void)
   {
      fName[0] = NULLCHAR ;
      fType    = fmTYPES ;
      fBytes   = ZERO ;
      modTime.day = modTime.date = modTime.month = modTime.year 
                  = modTime.hours = modTime.minutes = modTime.seconds = ZERO ;
      readAcc  = false ;
      writeAcc = false ;
      // NOTE: data member, rawStats is left unitialized
   }
   char        fName[MAX_FNAME] ; //* Filename string
   fmFType     fType ;     //* File type (enum fmFType)
   uint64_t    fBytes ;    //* File size (in bytes)
   localTime   modTime ;   //* Date/Time file last modified (human readable)
   FileStats   rawStats ;  //* Copy of system's "stat" structure (all file info)
   bool        readAcc ;   //* 'true' if user has read access to file
   bool        writeAcc ;  //* 'true' if user has write access to file 
                              // writeAcc is initially set as false when record
                              // is read. Must explicitly be calculated if needed.
} ;


