//********************************************************************************
//* File       : NcDialog.cpp                                                    *
//* Author     : Mahlon R. Smith                                                 *
//*              Copyright (c) 2006-2025 Mahlon R. Smith, The Software Samurai   *
//*                  GNU GPL copyright notice located in NcDialog.hpp            *
//* Date       : 13-Jul-2025                                                     *
//* Version    : (see NcDialogVersion string, below)                             *
//*                                                                              *
//* Description: NcDialog is derived from the NcWindow class and implements      *
//* a more specialized window, the dialog window.                                *
//*                                                                              *
//*                                                                              *
//* Developed Using:                                                             *
//*   Fedora Linux 41, GNOME terminal 3.54.0 (GNOME 47)                          *
//*   Wintel (Lenovo) hardware.                                                  *
//*   GNU G++ (Gcc v:14.2.1)                                                     *
//*   ncurses v:6.5.20240629                                                     *
//* Tested Using:                                                                *
//*   Fedora Linux and Ubuntu Linux                                              *
//*   GNOME terminal, KDE Konsole and Xterm                                      *
//*                                                                              *
//*  Previous Development Tools:                                                 *
//*    G++ / Gcc 13.2.1 for Linux (Fedora 39), and GNOME terminal 3.50.1         *
//*    G++ / Gcc 10.3.1 for Linux (Fedora 33), and GNOME terminal 3.38.5         *
//*    G++ / Gcc 10.1.1 for Linux (Fedora 32), and GNOME terminal 3.36.1.1       *
//*    G++ / Gcc  9.2.1 for Linux (Fedora 30), and GNOME terminal 3.32.1         *
//*    G++ / Gcc  4.8.3 for Linux (Fedora 20), and GNOME terminal 3.10.2         *
//*    G++ / Gcc  4.8.0 for Linux (Fedora 16), and GNOME terminal 3.2.1          *
//*    G++ / Gcc  4.6.1 for Linux (Fedora 15), and GNOME terminal 3.0.1          *
//*    G++ / Gcc  4.4.2 for Linux (Fedora 12), and GNOME terminal 2.28.2         *
//*    G++ / Gcc  3.2.2 for Linux (RedHat 9 )                                    *
//********************************************************************************
//* Version History (most recent first):                                         *
//*                                                                              *
//* v: 0.0.38 22-Feb-2025                                                        *
//* -- Update all references to gString-class buffer size.                       *
//*    The gString class now has variable, auto-sizing storage buffers. For this *
//*    reason, the limitations of the older gString with static buffer size      *
//*    need to be re-imagined.                                                   *
//*    -- Initially, only the size designator definitions have been updated.     *
//*       The idea behind this incremental change is that this should cause      *
//*       minimal headaches and no actual change in functionality.               *
//*       When this has been verified as stable, it may be possible to expand    *
//*       some NcDialog functionality to take advantage of the larger gString    *
//*       storage space.                                                         *
//*    -- The WaylandCB clipboard interface is an exception. While the NcDialog  *
//*       API controls are currently limited to buffers <= gsALLOCDFLT, the      *
//*       clipboard interface can handle up to MAX_CB_UTF32 characters which is  *
//*       currently defined as gsALLOCMED characters. The clipboard UTF-8 (byte) *
//*       interface can handle up to MAX_CB_UTF8 bytes (gsDFLTBYTES).            *
//*       These limits will be revisited for the next release.                   *
//* -- For some unknown reason, certain Unicode characters have been redefined   *
//*    from single-column to 2-column characters. Formerly, this affected only   *
//*    the HTML documentation; however, the monospace fonts used by the console  *
//*    have now also been infected with this stupidity. This is annoying because *
//*    the API counts columns for proper alignment within windows and dialogs.   *
//*    The most obvious of these characters is the "diamond" character used      *
//*    as the default selectors within Radiobutton controls:                     *
//*     wcsDIAMOND : 0x0025C6   diamond (black ◆(2-column))                     *
//*    Replace with single-column char in RB_Strings[] array in NcdControlRB.cpp.*
//*     wcsSDIAMOND : 0x002666  diamond (black ♦ (1-column))                     *
//*    The DisplayRadiobuttonTypes() debugging method displays the results of    *
//*    of this update. See Dialog1, Test05 for example output.                   *
//* -- Add an overload to wcbVersion method which reports both the WaylandCB     *
//*    class version and the wl-clipboard utilities version.                     *
//* -- Bug Fix: When the default (no parameters) NcDialog destructor is invoked, *
//*    it tests for the presence of the static, shared WaylandCB object, and if  *
//*    present, deletes it. This terminates the application connection to the    *
//*    system clipboard. While this is the correct action when closing the main  *
//*    application dialog, any secondary dialog closed with the default          *
//*    destructor will also delete the WaylandCB object when closing, which means*
//*    that the application would need to reinitialize the clipboard interface   *
//*    after closing ANY sub-dialog. This is very inconvenient.                  *
//*    Unfortunately, destructors may not include parameters, and therefore      *
//*    cannot handle special cases, so a design decision must be made:           *
//*     a) The NcDialog destructor will release the resources associated with    *
//*        the system clipboard when each dialog closes.                         *
//*     b) The NcDialog destructor will not release the clipboard resources,     *
//*        so those resource must be released seperately.                        *
//*    The straightforward answer to this dilemma is that the NcDialog destructor*
//*    does not handle release of the clipboard connection. Thus, the clipboard  *
//*    connection must be terminated explicitly via wcbDisable(), OR resources   *
//*    (usually) will be automatically returned to the system when the           *
//*    application exits to the command line.                                    *
//*    -- Existing applications should be updated to explicity release clipboard *
//*       resources just before closing the application's main dialog.           *
//*                                                                              *
//* -- Documentation update.                                                     *
//* -- Posted to website ??-???-2025.                                            *
//*                                                                              *
//* v: 0.0.37 17-Mar-2024                                                        *
//* -- Add include file: 'cstdint' to GlobalDef.hpp and to gString.hpp.          *
//*    This file was formerly included by 'csdtlib' but as of c++13 is no        *
//*    longer automatically included. This change caused the definition group:   *
//*    int8_t ... int64_t and uint8_t ... uint64_t to be undefined.              *
//*    This in turn caused compilation of the gString code to fail.              *
//* -- Generated new keymap for NCursesKeyDef.hpp and new TransTable2 for        *
//*    NcKey.hpp using Keymap v:0.0.06.                                          *
//*    The keycodes associated with the keyboard-generated escape sequences      *
//*    change regularly according to the Linux distro flavour, Wayland version,  *
//*    'terminfo' database, terminal emulator used, ncurses verion, keyboard     *
//*    type, and probably global weather patterns as well. See the 'Keymap'      *
//*    utility for details on this recurring (and annoying) phenomenon -- and    *
//*    how to overcome it.                                                       *
//* -- Rewrite the dialog-capture methods to HTML format. Formerly the text and  *
//*    attribute values would sometimes get out-of-synch if mixed single-column  *
//*    and multi-column data were overlayed.                                     *
//*    -- Also, the default monospace font(s) used by web browsers (especially   *
//*    Firefox) now define certain characters which were formerly single-column  *
//*    characters as two-column characters. They must have had their reasons,    *
//*    but it caused some screen grabs in the documentation to become misaligned.*
//*    Our solution is to automagically replace the '◆' character (U+25C6) with  *
//*    the single-column '♦' (U+2666) character. This is the only standard       *
//*    NcDialog character we have found (so far) that exhibits this problem.     *
//*    If others are identified, they will be addressed in the next release.     *
//*    Again, this is for HTML screen grabs only. Info-format documents still    *
//*    use standard monospace fonts.                                             *
//* -- Documentation update.                                                     *
//*                                                                              *
//* v: 0.0.36 22-Oct-2021                                                        *
//* -- Generated new keymap for NCursesKeyDef.hpp and new TransTable2 for        *
//*    NcKey.hpp using Keymap v:0.0.04.                                          *
//* -- Update copyright notices to reflect the new year.                         *
//* -- Documentation update.                                                     *
//* -- Posted to website 10-Jul-2023.                                            *
//*                                                                              *
//* v: 0.0.35 12-Aug-2021                                                        *
//* -- Implement the dctSLIDER user interface control. The Slider control        *
//*    allows the user to select a value by adjusting the height of the slider   *
//*    bar. Both vertical and horizontal sliders are supported.                  *
//*    Examples of Slider control may be found in Dialog1 Test #8,               *
//*    Dialog2 Test #7 and Dialog4Test #10: "Slider Controls".                   *
//* -- Documentation update.                                                     *
//* -- Posted to website 01-Sep-2021                                             *
//*                                                                              *
//* v: 0.0.34 29-May-2021                                                        *
//* -- Remove obsolete code which was controlled by various conditional-         *
//*    compilation constructs. These were related to bug fixes and enhancements  *
//*    which have been verified as functional, so the obsolete code is no        *
//*    longer needed.                                                            *
//* -- Increase the maximum number of NcDialog control objects from 24 to 36.    *
//*    Several ambitious designers have found the 24-control-object limit to be  *
//*    unnecessarily restrictive. No current functionality is affected by this   *
//*    change. See the constant value, MAX_DIALOG_CONTROLS in NcDialog.hpp.      *
//* -- Implement the Chart class. The Chart class supports creation of various   *
//*    types of bar charts (or a Cartesian coordinate grid) which may be         *
//*    customized to present an array of data values in several different ways.  *
//*    The Chart class consists of two source modules: Chart.hpp and Chart.cpp.  *
//*    These modules may be found in the Dialog4 test application along with     *
//*    an extensive test suite, ChartTest.cpp.                                   *
//* -- Documentation update.                                                     *
//* -- Posted to website 03-Aug-2021                                             *
//*                                                                              *
//* v: 0.0.33 30-Jan-2021                                                        *
//* -- Bug Fix: If the integrated Wayland clipboard interface was active         *
//*    during the deletion of the NcDialog object, the Wayland temporary files   *
//*    were not being deleted from the temp directory. This bug did not          *
//*    affect API functionality, but the abandoned temp files would accumulate   *
//*    until the system was rebooted. (naughty programmer!)                      *
//* -- Implement micro-space column alignment for CJK characters in the          *
//*    CaptureDialog() method group (HTML output).(see ccapMicrospace() method.  *
//*    -- Update copyright message in CaptureDialog() HTML output.               *
//* -- Implement SetMenuwinBorderAttr() method. This method can be used to       *
//*    apply custom color attributes to the (expanded-state) border of           *
//*    Menuwin controls. This was requested by the user community. (谢谢楚瑶)   *    
//* -- Removed the experimental code used as a work-around for the loss of       *
//*    the escape key. The ESC key is still not available, but the work-around   *
//*    was a poor solution.                                                      *
//* -- In Hotkey2Index() method, add support for selecting a menu item by        *
//*    number (0-9 only). This is useful for applications which cannot           *
//*    conveniently support user-defined hotkeys: multi-language user            *
//*    interfaces and interface languages which are not written using the        *
//*    Latin alphabet (ASCII 'a'-'z' 'A'-'Z').                                   *
//* -- Bug Fix: For RTL text data within a collapsed dctDropdown control         *
//*    object, the RedrawControl() method was setting the initial cursor         *
//*    position incorrectly. This bug was evident only when explicitly setting   *
//*    a new highlighted item for the control (SetDropdownSelect method) after   *
//*    returning from the control's edit routine.                                *
//* -- Bug Fix: When editing a dctSPINNER control, pressing the SPACE key now    *
//*    terminates the edit (same as ENTER key and TAB key).                      *
//* -- Implement the Pinwheel Widget. This is eye candy for the user when the    *
//*    application is busy doing something else. The Pinwheel class is defined   *
//*    and implemented in Pinwheel.hpp, located in the Dialog4 test-application  *
//*    directory. The test code is implemented in Dialog4, Test #10.             *
//* -- Documentation update.                                                     *
//* -- Posted to website 28-May-2021                                             *
//*                                                                              *
//* v: 0.0.32 30-Apr-2020                                                        *
//* -- The transition from Fedora30 to Fedora32 has broken a large number of     *
//*    keycodes in the range of 0x0102 - 0x0246. The broken key combinations     *
//*    generate the same escape sequences as previously; however, the            *
//*    keycodes assigned to them have been arbitrarily changed.                  *
//*    The dynamic table in NCursesKeyDef.hpp and the TransTable2 lookup         *
//*    table have been updated to reflect the new keycode assignments.           *
//* -- Add the wcbUserAlert() method which may be used to report the current     *
//*    status of the system clipboard interface.                                 *
//* -- Update the default keycode map to address the changes introduced in       *
//*    Fedora32. See Keymap test application for details.                        *
//* -- In the gString class, implement the 'gscanf' method as an internal        *
//*    implementation of the C-language 'swscanf' function.                      *
//* -- Bug Fix: In the gString class: Count of formatting specifications was     *
//*    not ignoring a literal '%' character as it should.                        *
//* -- Add ClearTerminalWindow() method to the NcDialog Class. May be called     *
//*    when an external process may have compromised the display data.           *
//* -- Bug Fix: Recent enhancements (2019 and 2020) to Gnometerm and Konsole     *
//*    interfere with our algorithm for display of RTL (Right-To-Left) text.     *
//*    To compensate, we explicitly disable BiDi (bidirectional text) support    *
//*    during the NCurses Engine start-up sequence, and then re-enable BiDi      *
//*    during the shut-down sequence.                                            *
//*    -- BiDi support is also re-enabled by a call to Hibernate() in            *
//*       anticipation of temporarily returning to the shell program. BiDi       *
//*       support is then disabled again by a call to Wake().                    *
//*    -- Note that some terminal emulation software will not respond to         *
//*       direct programatic enabling/disabling of BiDi support. Please see      *
//*       the NCurses-class BiDiEnable() method for more information.            *
//* -- In mid-2019, the replacement of the X mouse driver with the Wayland       *
//*    mouse driver had caused the system to stop reporting the Shift key in     *
//*    conjunction with mouse events. While the Shift key is still not           *
//*    reported in conjunction with mouse clicks, Shift+Scrollwheel events are   *
//*    now being reported correctly (Wayland version 1.18). This means that      *
//*    text selection in Textbox controls and stepped increment/decrement of     *
//*    values in Spinner controls are once again fully functional.               *
//*    (However: keep an eye on this.)                                           *
//* -- In the NcWindow class, add overload methods to the 'WriteParagraph'       *
//*    method. These are inherited by the NcDialog class.                        *
//* -- Bug Fix: A call to 'SetDropdownSelect' was not forcing a redraw of the    *
//*    control, so when control was subsequently expanded, the highlight was     *
//*    sometimes on the incorrect item.                                          *
//* -- Update copyright messages to reflect the new year.                        *
//* -- Minor updates to all Makefiles.                                           *
//* -- Documentation update.                                                     *
//* -- Posted to website 25-Jan-2021                                             *
//*                                                                              *
//* v: 0.0.31 21-Apr-2020                                                        *
//* -- Integrate the Wayland clipboard interface for textbox copy/cut/paste.     *
//*    -- Create NcDialog stubs for all WaylandCB public methods.                *
//*    -- Add static non-member pointer 'wcbClip' to access WaylandCB object.    *
//*       Located at the top of NcdControlTB.cpp.                                *
//*    -- Enable Textbox default keys for copy/cut/paste/select as part of       *
//*       NcDialog instantiation.                                                *
//*    -- Add exercise of Wayland clipboard in Dialog1 (Test #1) and             *
//*       Dialogw (Test #10).                                                    *
//* -- Bug Fix: For Textbox controls configured for RTL text, the                *
//*    cut-selection-to-clipboard operation was indexed incorrectly under some   *
//*    conditions, causing an endless loop.                                      *
//* -- Expand definition of Delete key within a Textbox control to delete        *
//*    'selected' text.                                                          *
//* -- Documentation update.                                                     *
//* -- Posted to website 28-Apr-2020                                             *
//*                                                                              *
//* v: 0.0.30 13-Sep-2019                                                        *
//*    -- Update from gcc 4.8.3  to  gcc 9.0.1.                                  *
//*       New warning: -Wmisleading-indentation                                  *
//*       This is a bogus warning because C/C++ are free-form languages.         *
//*       The compiler's complaint is that under some circumstances, there are   *
//*       no braces after a conditional statement to enclose ("guard") a         *
//*       single instruction to be executed. In any case, all has been           *
//*       beautified to silence the compiler warning.                            *
//*    -- Design a new test application, 'Keymap' which performs key-map         *
//*       testing on three keycode groups: Navigation keys, Function Keys and    *
//*       Numeric Keypad keys, along with a few special keys such as Insert,     *
//*       Delete and Shift+Tab. From the test results, this utility generates    *
//*       a C++ header file which may be "include'd" into NCursesKeyDef.hpp.     *
//*       It can also generate a copy of the NCurses-class translation table,    *
//*       TransTable2. See the documentation for the Keymap utility for more     *
//*       information.                                                           *
//*    -- Mouse scroll-wheel event definitions have changed, either in the       *
//*       ncurses code, OR in the Wayland mouse driver interface to ncurses.     *
//*       Either way, access to our Shift+Scroll shortcut for selecting text     *
//*       in a Textbox is no longer directly available. The work-around would    *
//*       be to _assume_ that mouse scrol events in a Texbox control are an      *
//*       attempt to select data; however, we resist making that assumption,     *
//*       so text selection via mouse is not implemented at this time.           *
//*    -- Enhance operation of the DialogBillboard class. The 'sclAttr' member   *
//*       was formerly ignored, but it now indicates whether the color           *
//*       attributes will be scrolled when the text data are scrolled. By        *
//*       default color attributes are associated with the display line; but     *
//*       when this flag is SET, color attributes are associated with the        *
//*       display text rather than with the line number.                         *
//*       See the "ScrollBillboardColors(bool) method for details.               *
//*    -- Full rewrite of Dialogx application to access the  Wayland clipboard   *
//*       rather than the X clipboard. This functionality is external to the     *
//*       NcDialogAPI itself and is a fully-independent implementation.          *
//*       See WaylandCB.hpp and WaylandCB.cpp.                                   *
//*    -- Due to a bug in the ncurses 'keypad', the Escape character is no       *
//*       longer passed through. The loss of access to the Escape key is a       *
//*       serious problem for NcDialog functionality. The edit methods are       *
//*       designed to interpret the Escape key as a command to discard current   *
//*       edits, restore the previous state of the control and move focus away   *
//*       from that control.                                                     *
//*       As a temporary patch, when the ALT+X character is received by any of   *
//*       the edit-control methods, we substitute the Escape key (nckESC).       *
//*       We hope that Mr. Dickey will issue a patch for this issue soon.        *
//*    -- Recent changes in the way text is rendered in browsers has affected    *
//*       the way dialog screenshots are displayed. Specifically, the            *
//*       horizontal dimension of the background ("max-width") calculation.      *
//*       We have experimentally determined the multiplication constant          *
//*       needed for this calculation. See notes in ccapFile() method.           *
//*    -- Documentation update                                                   *
//*    -- Posted 17-Jan 2020                                                     *
//*                                                                              *
//* v: 0.0.29 19-Jan-2016                                                        *
//*    -- Bug fix in NcDialog constructor, defend against unitialized InitCtrl   *
//*       object or invalid control type being passed by application. Now the    *
//*       dialog will stay open to visually demonstrate the error. Previously,   *
//*       the dialog opened and closed faster than the eye could see.            *
//*    -- Bug fix in 'ShellOut' method:                                          *
//*       -- the 'soX' option was being overridden by the default option.        *
//*       -- the 'soP' option was incorrectly displaying an initial message in   *
//*          addition to the specified post-operation message.                   *
//*    -- 'ShellOut' method now returns the exit code from the child process.    *
//*       Caller must determine the value and reliability of this code and       *
//*       how to interpret it.                                                   *
//*    -- Bug Fix in 'ClearWin' method: If window is too small to have a border  *
//*       (rows==1 || cols==1), start and end position for clear were being set  *
//*       incorrectly.                                                           *
//*    -- Finish implementation of support for fixed-width Textbox controls.     *
//*       Previously editing of a fixed-width field was not fully supported.     *
//*       -- Rename the 'ExtendedTextboxData' method as 'FixedWidthTextbox'.     *
//*          This is an obtrusive change: existing code must be updated to use   *
//*          the new method name.                                                *
//*       -- When horizontal shift was disabled, existing text data was not      *
//*          being properly truncated to width of field.                         *
//*       -- When scrolling, do not allow cursor movement to cause a data        *
//*          shift.                                                              *
//*       -- When inserting or replacing text, prevent overflow of the field.    *
//*       -- Update documentation to explicity state that only single-line       *
//*          Textbox controls may be set as fixed-width controls.                *
//*    -- Add an undocumented option to emwEditSingle() to allow screenshot      *
//*       capture of a Menuwin object under edit (invoke with ESC key).          *
//*    -- The 'EditScrollext' method now sets the returned 'dataMod' flag if     *
//*       user input is nckENTER, nckpENTER or nckSPACE, _or_ if the position    *
//*       of the highlight has changed. Formerly, nckSPACE did not cause the     *
//*       'dataMod' flag to be set.                                              *
//*    -- Create a callback method for the 'GenericDialog' method specifically   *
//*       for capturing screenshots of 'DecisionDialog' and 'InfoDialog'         *
//*       windows. Activation key == nckAINSERT (ALT+INSERT).                    *
//*       Conditionally compiled under both 'ENABLE_DEVELOPMENT_METHODS'         *
//*       and 'GD_CAPTURE'. This makes creating documentation for                *
//*       NcDialog-based applications much easier.                               *
//*    -- Expand the definition of the tbFileName and tbPathName Textbox         *
//*       filters to include all printing characters except a few 'special'      *
//*       characters. While technically, all characters except '/' and '\0'      *
//*       are valid filename characters under Linux, many of the specified       *
//*       special characters are not portable, or are othewise foolish           *
//*       filename choices.                                                      *
//*    -- Update interval timing for the 'UserAlert' method and make user        *
//*       mid-sequence termination more robust.                                  *
//*    -- Bug Fix: In MoveScrollextHighlight(), calling this method always made  *
//*       the highlight visible, even if it should have remained invisible.      *
//*    -- Bug Fix: In SetPushbuttonText(), default hotkey was being lost,        *
//*       causing the control to stop responding to mouse input.                 *
//*    -- Overload the SetActiveMenuItems() method to allow replacement of the   *
//*       menu-item text strings.                                                *
//*    -- Repair documentation error in header of dtbmData constructor,          *
//*       'center' parameter. Documentation change only--no change in            *
//*       functionality.                                                         *
//*    -- Increase maximum control label size from 128 to 256 wide characters.   *
//*    -- Finish implementation of remaining genDialog-class members (yesTxt     *
//*       and noTxt) which implement the optional, alternate Pushbutton text     *
//*       in DecisionDialog() and InfoDialog(). This includes support for RTL    *
//*       Pushbutton label text.                                                 *
//*    -- Modify the conditions for DrawContentsAsRTL() method to allow          *
//*       toggling the RTL flag for Textbox controls. This allow setting RTL     *
//*       format even if the Textbox has focus _IF_ the containing window has    *
//*       not yet been opened.                                                   *
//*    -- Bug fix in low-level WriteHotString() method related to cursor         *
//*       positioning for multi-column RTL output. See note in NcWindow.cpp.     *
//*    -- Add full initialization constructor to the reservedKeys class. We      *
//*       should have done this from the beginning.(see example in Dialogx.cpp)  *
//*    -- Implement enhancements and additional features for the gString class.  *
//*       See gString.cpp module header for details.                             *
//*    -- Add two additional options to spinner controls to allow the value to   *
//*       be displayed in hexadecimal format. See enum dspinFormat.              *
//*    -- Update for g++ v:5.4.0 AND ncurses library v:6.0.yyyymmdd:             *
//*       -- Note that GNOME-term "ambiguous-width" characters must be rendered  *
//*          as "narrow." This is an option in the gnome-terminal settings.      *
//*          Formerly, this always defaulted to "narrow" without an              *
//*          easily-accessible setting to modify it. The characters in question  *
//*          are the line-drawing characters which are a major element in        *
//*          drawing dialog windows in gnome-terminal. Konsole may have a        *
//*          similar issue, but this has not yet been verified.                  *
//*       -- NCurses;;GetKeyInput() method workaround for libncurses bug.        *
//*       -- Due to some subtle change in which the compiler puts string         *
//*          pointers on the stack the NCurses VerifyLocale() method had         *
//*          stopped working. Now fully functional.                              *
//*       -- Update certain NCurses-class keycode definitions to correspond      *
//*          with the ncursesw v:6.0.20160213. See NcKey.cpp for details.        *
//*    -- Add new method: GetBillboardIndex( short cIndex, short& lIndex );      *
//*       For Billboard controls, returns index of the next free display line.   *
//*    -- Define additional const character codes: wcsWCIRCLE, wcsBCIRCLE,       *
//*       wcsFISHEYE, wcsBULLSEYE, wcsWDIAMOND, wcsDIAMONDS. (see NCurses.hpp)   *
//*       -- This was done primarily to implement a special case of the          *
//*          single-character radiobutton type, rbtC1. See RedrawControl()       *
//*          method of the DialogRadiobutton class.                              *
//*    -- Add an undocumented debugging feature for screen capture of Dropdown   *
//*       controls. See EditDropdown().                                          *
//*    -- Allow Linux "special" characters to optionally be recognized as        *
//*       valid filename characters. See tbIsFileName().                         *
//*       -- Add method to escape the Linux special characters so they will      *
//*          be seen as ordinary filename characters when passed to console      *
//*          shell program. See EscapeLinuxSpecialChars().                       *
//*    -- Documentation update.                                                  *
//*    -- Posted to website 10-Sep-2019                                          *
//*                                                                              *
//* v: 0.0.28 19-Nov-2015                                                        *
//*   - Completed significant updates to the gString class and the gString       *
//*     documentation. See gString.cpp for details.                              *
//*   - Bug fix in IsHotkey(): if test value is a NULL character, then do not    *
//*     scan the hotkey list. We had assumed that the keyboard would never       *
//*     return a NULLCHAR as a valid keycode; however CTRL+2 actually does so.   *
//*     Note that this is actually an ncurses bug because it is responsible      *
//*     for returning only valid keycodes, but we squash it here.                *
//*   - Bug fix in ConnectControl2Border(): return value was not being updated   *
//*     on success.                                                              *
//*   - Bug fix in DialogScrollbox() constructor: protect ourselves from a       *
//*     NULL pointer in InitCtrl::scrColor member by setting a default color.    *
//*   - Bug fix in IsHotkey(): Converted mouse event was not being recognized    *
//*     as a potential hotkey.                                                   *
//*   - Bug fix in NcWindow.hpp: Was wrong default 'dclick' value for call to    *
//*     EnableStableMouse().                                                     *
//*   - Bug fix in meIsObscured(): Testing whether the target of a mouse click   *
//*     is obscured by an open menu. Test formerly did not distinguish between   *
//*     regular menus and context menus which caused an occasional false         *
//*     positive.                                                                *
//*   - Refine the algorithm for converting mouse input to keycodes.             *
//*     Affects only scrolling controls dctSCROLLBOX, dctSCROLLEXT,              *
//*     dctDROPDOWN, dctMENUWIN. Both single- and double-click now move the      *
//*     highlight to the item under the mouse pointer _and_ 'selects' that       *
//*     item. See meTransformEvent() method for details.                         *
//*   - Make the main keyboard Enter key (nckENTER) and the keypad Enter key     *
//*     (nckpENTER) equivalent in all user-interface code (EditXXX methods).     *
//*   - In NcDialog constructor, if the NCurses Engine shows that the mouse      *
//*     interface is enabled, then inherit the parent dialog's mouse settings.   *
//*     This allows sub-dialogs access to the mouse without having to            *
//*     explicitly enable the mouse after instanting them.                       *
//*   - Update definition of the dspinData class for formatting Spinner data.    *
//*     This was done primarily to support implementation of date/time Spinners  *
//*     which have been requested by the community.                              *
//*     - Added an initialization constructor and two optional new fields.       *
//*       IMPORTANT NOTE: CHANGES TO EXISTING APPLICATION CODE ARE REQUIRED.     *
//*     - Existing code which uses structure-style initialization for this       *
//*       class, must be checked for correct order of arguments.                 *
//*       (This is an obtrusive change.)                                         *
//*                                                                              *
//* v: 0.0.27 25-Apr-2015                                                        *
//*   - Completed work on the CaptureDialog() group of methods.                  *
//*     - Bug fix: Color attribute indices were off in capture of scrolling      *
//*       controls.                                                              *
//*     - Consolidate capture of single-state controls to ccapSimple().          *
//*       Consolidate capture of scrolling controls to ccapMulti().              *
//*       Delete the old ccapPBut() and ccapSBox() methods.                      *
//*     - Fully implement capture of text/color data to both plain-text and      *
//*       HTML files. Previously, only plain-text output worked properly.        *
//*     - HTML output requires the CSS definition file: 'screenshot-styles.css'  *
//*       which fully defines classes for up to 16 RGB registers and the         *
//*       associated Bold, Underline, Reverse color-attribute bits.              *
//*       Color support for the remainder of our 64 locally-defined color pairs  *
//*       (08h through 3Fh) is included, although the attribute bits for these   *
//*       pairs are ignored. See the release notes for the NCurses-class for     *
//*       details on 16-color support for terminals.                             *
//*     - A special, 8-color HTML capture has also been implemented. This        *
//*       allows for a greatly-compressed capture for use with Texinfo           *
//*       documents.                                                             *
//*     - Note: HTML capture of display data for multi-column (Chinese)          *
//*             characters is not well supported at this time.                   *
//*   - Update ClearLine() method to match update in NcWindow class.             *
//*   - Implement the ClearArea() method to complement ClearLine().              *
//*   - Implement the ShellOut() method which performs the command sequence      *
//*     necessary for the application to temporarily go to the command prompt.   *
//*   - Insert a stub for the PseudoShell() method. Not yet implemented.         *
//*   - Add members 'metSW_D' and 'metSW_U' to enum meTypes to support           *
//*     ScrollWheel events.                                                      *
//*   - Add LTR/RTL support for the genDialog class which enables the            *
//*     InfoDialog() and DecisionDialog() methods to draw the data as either     *
//*     LTR or RTL text. Note that the Pushbutton text is always drawn as LTR.   *
//*     - 'yes_text' and 'no_text' parameters were also added to allow caller    *
//*        to specify the text of the Pushbuttons, but these are not             *
//*        implemented at this time.                                             *
//*   - Split GetSbSelect() and SetSbSelect():                                   *
//*     GetScrollboxSelect(), GetScrollextSelect(), GetDropdownSelect()          *
//*     SetScrollboxSelect(), SetScrollextSelect(), SetDropdownSelect()          *
//*   - Standardize naming convention for DialogScrollext and DialogMenuwin      *
//*     classes and support methods. (This is an obtrusive change.)              *
//*   - Modify NcDialog constructor to allow text and color data for             *
//*     dctSCROLLEXT controls to be set within the control-instantiation loop.   *
//*     This requires 'dispText', 'scrColor', 'scrItems' and 'scrSel' to be      *
//*     properly initialized.                                                    *
//*   - Standardize keycode assignments for expanding controls (Dropdown and     *
//*     Menuwin).                                                                *
//*   - Better bullet-proofing for text parsing in Scrollbox, Dropdown and       *
//*     Menuwin constructors (no performance penalty if data properly            *
//*     formatted).                                                              *
//*   - Enforce horizontal and vertical positioning of controls to be inside     *
//*     the parent dialog and optionally within the dialog border.               *
//*     See the 'AUTOPOS' conditional compilation flag and the methods           *
//*     AutoPositionX() and AutoPositionY().                                     *
//*   - Add new Radiobutton subtype rbtC6 for 3, 2-column characters.            *
//*     Update the DisplayRadiobuttonTypes() method.                             *
//*   - Add convenience method: ccapDocs() to capture a dialog in both text      *
//*     and HTML for use in Texinfo documentation.                               *
//*   - Add a simplified version of the UserAlert() method for lazy programmers  *
//*     who just want to make some noise during debugging, (i.e. me...).         *
//*   - Re-organize mouse-event conversion for clarity and robustness.           *
//*     See meTransformEvent().                                                  *
//*   - Add optional mouse-data dump to Dump_uiInfo().                           *
//*   - Add a second Mouse-enable method, meEnableStableMouse(). This method     *
//*     restricts both the range of mouse events reported AND the timing for     *
//*     those events. When fully implemented, this method will override and      *
//*     interpret the raw mouse events from the ncurses(w) library to reduce     *
//*     the effect of timing artifacts.                                          *
//*   - Move all mouse configuration to the NcWindow class to achieve            *
//*     thread safety. Because most of the mouse interface is now in the         *
//*     NcWindow class, we have renamed NcdMouse.cpp as NcdKey.cpp.              *
//*   - Redesign Textbox text-selection, copy, cut and paste operations.         *
//*     - Copy to and from the Local Clipboard simplified and made more robust.  *
//*     - Text selection within a Textbox redesigned and simplified.             *
//*                                                                              *
//* v: 0.0.26 13-Aug-2014                                                        *
//*   - Move primary development platform from 32-bit to 64-bit system.          *
//*     - This uncovered a masked bug in the constructors for DialogScrollbox,   *
//*       DialogMenuwin and DialogDropdown. Calculation for calloc() had         *
//*       assumed that attr_t == int, when actually attr_t == long int.          *
//*       This may not be the only instance of assuming that int == long int,    *
//*       so be aware.                                                           *
//*   - Explicity set the control's background color in the SetScrollextText()   *
//*     method in case the provided data do not fill the control window.         *
//*   - Update alt-charset definitions and display to reflect changes in         *
//*     system character map.                                                    *
//*   - Add private data member 'disableIns' to enable/disable user access to    *
//*     the 'Insert' key.                                                        *
//*   - Add CheckTermSize() method to refresh the dialog if terminal window      *
//*     is resized. This method is called from each dialog-control edit method.  *
//*   - Bug fix: typos in DisplayLineDrawingSet().                               *
//*   - Bug fix: For EditScrollext(), return dataMod == true if item index       *
//*     has changed. This needs further testing to see if it breaks any          *
//*     existing code.                                                           *
//*                                                                              *
//* v: 0.0.25 22-Jun-2014                                                        *
//*   - Continue enhancement and testing of multi-line textbox controls.         *
//*     - Correct errors in mlDeleteChar() cursor positioning.                   *
//*   - Create DrawLabelsAsRTL() method to allow control labels and dialog       *
//*     title to be drawn as either LTR or RTL.                                  *
//*   - Make individual control objects aware of the 'rtlContent' member of      *
//*     the DialogControl (abstract) class. This allows control's contents to    *
//*     be drawn as either LTR data (default) or RTL data.                       *
//*     - Create DrawContentsAsRTL() method to toggle the                        *
//*       DialogControl::rtlContent flag. This flag was formerly ignored by      *
//*       all controls except dctTEXTBOX controls.                               *
//*     - Remove the temporary members of enum tbCurPos: tbcpRTL and             *
//*       tbcpLEFTJUST used by SetTextboxCursor(). These were for initial RTL    *
//*       implementation for dctTEXTBOX controls but have been superceeded by    *
//*       the more generalized DrawContentsAsRTL().                              *
//*   - Bug-fix in emwSubmenuCount(), loop termination during recursive call.    *
//*                                                                              *
//* v: 0.0.24 07-Apr-2014                                                        *
//*   - Implement multi-line dctPUSHBUTTON control option.                       *
//*     - Changes to DialogPushbutton constructor, RedrawWin().                  *
//*     - Add EnablePushbuttonBorder() method.                                   *
//*   - Implement multi-line dctTEXTBOX control option.                          *
//*     NOTE: This is a major update, and bugs will likely surface over time,    *
//      especially in calculating line breaks and cursor position during edit.   *
//*     - Add tbGetText() method (called by NcDialog-class GetTextboxText()).    *
//*     - Add EditMlText() method for user edit of multi-line textboxes.         *
//*       - Add several DialogTextbox support methods to implement multi-line    *
//*         editing.                                                             *
//*     - Modified tbSetText(), tbSetCursor(), RefreshControl() and other        *
//*       support methods.                                                       *
//*     - Modified debugging methods for EditXxText() method group.              *
//*   - Add to enum tbChars: 'tbPrintUpper' and 'tbPrintLower'.                  *
//*   - Removed hooks for right-justified textboxes which allowed edited text    *
//*     to grow beyond the width of the control. This was never fully            *
//*     implemented, and was a poor idea anyway. Width of text in right-         *
//*     justified textbox controls is limited to the width of the control.       *
//*   - Redefine prototype for SetTextboxCursor() method. Removed the            *
//*     'yoffset' parameter which was nearly useless in any case.                *
//*      NOTE: This is an obtrusive change, requiring an update to               *
//*            all existing calls to SetTextboxCursor().                         *
//*   - For dtbmData class:                                                      *
//*     - Redefine parameter 4 ('center') of constructor as a short int rather   *
//*       than bool. This is to correct a problem which occurs when a            *
//*       color-data array is passed AND message centering is specified.         *
//*       When this happens, we need to know how wide the target field is.       *
//*       Affects DisplayTextboxMessage() and DisplayMessage().                  *
//*        NOTE: This is an obtrusive change, requiring an update to             *
//*              all dtbmData objects that specify message centering.            *
//*              Objects that do not specify centering will not be               *
//*              affected by this change.                                        *
//*     - Add data member 'rtlText' to dtbmData class (and to initialization     *
//*       constructors) to support display of RTL (right-to-left) text.          *
//*   - Add support for RTL (right-to-left) text editing in dctTEXTBOX           *
//*     controls for languages such as Arabic, Hebrew, Yiddish and others.       *
//*     - A new flag 'rtlContent' in the DialogControl class controls whether    *
//*       data are RTL or LTR. (This flag will later be expanded to specify      *
//*       content formatting for other controls.                                 *
//*     - New (temporary) members of enum tbCurPos: tbcpRTL and tbcpLEFTJUST     *
//*       for calls to SetTextboxCursor() toggle between RTL and LTR.            *
//*   - Simplified EditXxText() method group for efficiency and robustness.      *
//*     - Rename EditLjText() as EditSlText() to reflect that both LTR and RTL   *
//*       text editing is now supported.                                         *
//*     - Consolidate cursor calculations in new tbSynchCursor() method.         *
//*                                                                              *
//* v: 0.0.23 28-Nov-2013                                                        *
//*   - Update user-input loop for each control type to check for toggle of      *
//*     (textbox) Insert/Overstrike mode _before_ calling user's                 *
//*     ExternalControlUpdate() method. State of Ins/Ovr flag is then current.   *
//*   - Update definition of dtbmData class to accept both UTF-8 and wchar_t     *
//*     parameters.                                                              *
//*   - Implement DisplayTextboxTail() method to optionally display tail of      *
//*     textbox data.                                                            *
//*   - Implement optional audible alert when an invalid character is received   *
//*     in the EditTextbox() method. See TextboxAlert().                         *
//*   - Convert screen-capture methods to use NcWindow-class CaptureWindow().    *
//*     This reduces the use of ncurses primitives in the NcDialog class.        *
//*     - Add CaptureDialog(const char* fPath, bool fhtml=false)                 *
//*       (public method for capture of dialog display data to a file)           *
//*       (plain text output works, but HTML output has problems.    )           *
//*     - Add CaptureDialog(SaveWin& sw, const char* fPath=NULL,                 *
//*                         bool fhtml=false)         (private method)           *
//*     - Obsolete debug method, DumpCDDD_Nodes() deleted.                       *
//*                                                                              *
//* v: 0.0.22 06-Jun-2013                                                        *
//*   - Preserve label offsets specified in the InitCtrl class during            *
//*     instantiation. Formerly, we converted the label position                 *
//*     (labY/labX members) from control-relative to window-relative, but in     *
//*     that case, static arrays in the application needed to be reinitialized   *
//*     for each instantiation.                                                  *
//*   - Begin design of multi-line dctTEXTBOX controls.                          *
//*     See 'FormatText' method for additional details.                          *
//*   - Using the basic functionality of a multi-line dctTEXTBOX control,        *
//*     created the new dctBILLBOARD control type. Please see Dialog4, Test05    *
//*     for examples of using this control.                                      *
//*   - Fixed bug in Menuwin, when sub-menu is opened, the parent's highlight    *
//*     is no longer visible (avoids confustion about which control is active).  *
//*   - Begin higher-level support for mouse events. Not yet sure how            *
//*     practical or useful this will be.                                        *
//*   - Move some methods to different source modules for a more logical         *
//*     functional grouping. No change in functionality.                         *
//*   - Rename certain methods for a more consistent naming pattern. All test    *
//*     applications updated to handle this change.                              *
//*   - Rename NcDialogPassthru.cpp as NcdMouse.cpp and moved all                *
//*     pass-through method stubs to the parent NcWindow class in preparation    *
//*     for thread-safety update.                                                *
//*   - Redefine CUPTR (macro for callback-function prototype) to include        *
//*     user's key input. Perhaps of little use to callback methods, but         *
//*     offers greater flexibility.                                              *
//*   - Rename all source modules                                                *
//*      of the form NcDialogControlsXX.cpp                                      *
//*              to  NcdControlXX.cpp  (just got tired of typing the names :-)   *
//*   - Update the dcHotkey class to use a wchar_t member for the keycode AND    *
//*     to accomodate mouse-specific hotkey support. Update IsHotkey() method    *
//*     to recognize 'default hotkeys'.                                          *
//*   - Fix hotkey bug in emwEditCollapsed and EditDrowdown which was not        *
//*     expanding the control on receipt of hotkey.                              *
//*                                                                              *
//*   - The ncurses C-language library may not be not thread safe.               *
//*     For this reason, we have begun design of thread safety for keyboard      *
//*     input screen output within the NcDialog class.                           *
//*     - There is only one non-trivial key-input routine, and it is located     *
//*       in NcKey.cpp. In addition, key input blocks anyway, so there is no     *
//*       performance issue related to thread safety for key input.              *
//*     - There are a number of routes to screen output, however, and it may     *
//*       take significant effort to isolate and test them.                      *
//*                                                                              *
//* v: 0.0.21 04-Jan-2013                                                        *
//*   - Enhance the dtbmData class and the DisplayTextboxMessage() method to     *
//*     allow for optionally, automagically centering the message in the target  *
//*     dctTEXTBOX control AND filling the entire width of the control.          *
//*   - Fix bug in ClearWin() method.                                            *
//*   - Fix centering bug in GenericDialog() method.                             *
//*   - Add ClearLine() method as pass-through to method of same name in         *
//*     NcWindow class.                                                          *
//*   - Add definition 'attrDFLT' to replace the constant (-1) used to           *
//*     initialize color attributes.                                             *
//*   - Clean up some documentation.                                             *
//*   - Implement UserAlert() method for audible alerts.                         *
//*   - Fix bug in SetDialogTitle() method: was ignoring border-line-style.      *
//*   - Update Text Box data-filtering methods.                                  *
//*   - Add stubs for new methods: Encode_URI() and Decode_URI().                *
//*   - Add support for multi-line control labels for controls where label is    *
//*     never embedded within the control: dctRADIOBUTTON, dctTEXTBOX,           *
//*     dctSPINNER and dctDROPDOWN. For controls which MAY embed the label into  *
//*     the border, we allow multi-line labels only if the label is positioned   *
//*     outside the border: dctSCROLLBOX, dctSCROLLEXT. The labels of            *
//*     dctMENUWIN controls are always embedded in the control. and              *
//*     dctPUSHBUTTON controls do not have labels.                               *
//*                                                                              *
//* v: 0.0.20 01-Aug-2012                                                        *
//*   - Replace the clunky attachment of the dspinData class to                  *
//*     InitCtrl::scrColor. Added a data member to the InitCtrl class:           *
//*     'spinData'. Update all instances of the InitCtrl class to reflect this   *
//*     change.                                                                  *
//*   - Change default for this->overStrike to false. Over time we have          *
//*     realized that 'Insert Mode' is needed more often.                        *
//*                                                                              *
//* v: 0.0.19 03-Feb-2012                                                        *
//*   - Add functionality to dctMENUWIN class for disabling or enabling          *
//*     individual items in the menu and/or changing the color attribute of      *
//*     individual items.See SetActiveMenuItems().                               *
//*   - Convert all color attributes from 'int' to 'attr_t'. Should have done    *
//*     this from the beginning, but type aliases can be a major pain.           *
//*   - Add method DisplayWideCharacterSet() which displays the wchar_t          *
//*     equivalents of the Alternate Character Set (ACS). See the wcsXXXX        *
//*     group of constants in NCurses.hpp.                                       *
//*   - Replace all functionality that internally used the ACS (Alternate        *
//*     Character Set). This includes a complete redefinition of the             *
//*     dctRADIOBUTTON sub-types, (enum RBType), and the                         *
//*     DisplayRadiobuttonTypes() method. Also the control connections to        *
//*     dialog window borders for Scrollbox and Scrollext controls, Spinner      *
//*     indicator character, Dropdownn indicator character.                      *
//*   - Enhance the InitNcDialog class to include a 'borderStyle' data member.   *
//*                                                                              *
//* v: 0.0.18 17-Sep-2011                                                        *
//*   - Update of control classes for UTF-8 is complete.                         *
//*     (Bugs, of course, may surface...)                                        *
//*   - Implement SetRbGroupSelection() which sets the 'selected' member of a    *
//*     Radio Button group.                                                      *
//*   - Change name of link library from NCurses.a to NcDialog.a. This was       *
//*     done for two reasons. First, an NCurses Widgets library already exists;  *
//*     and second, the functionality of the NcDialog class has, over time,      *
//*     overshadowed the NCurses and NcWindow classes.                           *
//*   - Add source module NcDialogPassthru.cpp. This module holds pass-through   *
//*     stubs for calling NCurses methods via an NcDialog pointer. This reduces  *
//*     the need for direct calls to NCurses-class methods and makes for a       *
//*     cleaner interface.                                                       *
//*                                                                              *
//* v: 0.0.17 08-Aug-2011                                                        *
//*   - Enhance definition of InitNcDialog class to include all parameters       *
//*     necessary for instantiation of an NcDialog object. Modify NcDialog       *
//*     constructor to accomodate the new InitNcDialog class definition.         *
//*   - Continue conversion to ncursesw library to support UTF-8 encoding.       *
//*   - Moved functionality of SetTextboxText() to the DialogTextbox class and   *
//*     added overloaded methods for either UTF-8 or wchar_t or gString          *
//*     parameters.                                                              *
//*   - Begin removal of all ASCII-oriented C/C++ library calls.                 *
//*   - Add overloads for SetDialogTitle() method; now supports UTF-8,           *
//*     wchar_t or gString parameter.                                            *
//*   - Redesign auxilliary hotkey functionality for Menuwin controls: add       *
//*     data members grpVisible and grpHotkey, eliminate data member auxHotkey.  *
//*                                                                              *
//* v: 0.0.16 06-Feb-2011                                                        *
//*   - Begin conversion to ncursesw library to support UTF-8 encoding of        *
//*     filenames, etc.This includes integration of the gString class into the   *
//*     NcDialog class functionality.                                            *
//*   - Renamed all .h files as .hpp                                             *
//*   - Redefine the 'label' member of the InitCtrl structure from char          *
//*     label[] to const char* label. This did not affect the constructors for   *
//*     the various control classes, but made it easier on the application       *
//*     programmer.                                                              *
//*   - Convert InitCtrl and InitNcDialog structure definitions to class         *
//*     definitions to increase C++ coolness (no actual change in                *
//*     functionality).                                                          *
//*   - Convert the logically-defective private method,                          *
//*     GroupHotkey2ControlHotkey() to a functional GroupHotkey2ControlIndex().  *
//*   - Enhance GetSbSelect() and SetSbSelect() to handle both dctSCROLLBOX      *
//*     and dctSCROLLEXT controls as well as dctDROPDOWN controls. Note that     *
//*     SetSbSelect() is valid for dctDROPDOWN controls ONLY when the control    *
//*     is in the 'collapsed' state.                                             *
//*   - Enhance dtbmData class to support UTF-8 data. This is part of the        *
//*     UTF-8-awareness update for the dctTEXTBOX control functionality.         *
//*   - Implement ExtendedTextboxData() method and added the hzShift data        *
//*     member to DialogTextbox class. This supports edit of text data that is   *
//*     longer than the control's display width.                                 *
//*                                                                              *
//* v: 0.0.15 20-Jan-2011                                                        *
//*   - Add a new dialog control type: dctSPINNER.                               *
//*     This control type counts through a specified range of values. It         *
//*     occupies a single display line, and has variable width. Similar to a     *
//*     one-line scroll box, but has no display-data array or color array.       *
//*   - Removed some 'old' code that was disabled via conditional compile when   *
//*     replacement code was developed.                                          *
//*                                                                              *
//* v: 0.0.14 05-Sep-2010                                                        *
//*   - Modify algorithm in EditMenuwin() method to create a smoother flow of    *
//*     control among the members of a menu-win group.                           *
//*   - Move NcDialog version History from NcDialog.hpp to NcDialog.cpp.         *
//*                                                                              *
//* v: 0.0.13 07-Feb-2010                                                        *
//*   - Change development platform and compiler version.                        *
//*     Fedora 12 and GNU G++ (Gcc v: 4.4.2)                                     *
//*     This neccessitated several syntax changes in class and method            *
//*     definitions to accomodate changes in the C++ definition and the GCC      *
//*     compiler's warning and error messages.                                   *
//*   - Broke the extremely large NcDialogControls.cpp source file into pieces,  *
//*     one source file for each control defined.                                *
//*   - Bug fixes and updates in SetTextboxCursor().                             *
//*   - Removed obsolete method: ShiftTabCheck().                                *
//*   - Note that the "alternate font" definition changed between Red Hat 9.0    *
//*     and Fedora 12. This broke any routine that had relied on the alt         *
//*     character set, specifically, the A1, A3, and A5 radio button             *
//*     definitions. This is probably related to the so-called System V          *
//*     extension characters to alt font. Note that curses.h defines codes for   *
//*     accessing the line drawing characters of the alternate font.             *
//*   - Add new functionality: GetCurrControl(), HideWin(), ShowWin() (private)  *
//*     MoveWin(), CaptureDialogDisplayData() (private), SetDialogObscured(),    *
//*     RedrawWindow() (private). Updated ClearWin() and RefreshWin() to         *
//*     support the new functionality.                                           *
//*   - Made DebugMsg() public, but with a warning.                              *
//*   - Major rewrite of control-editing routines:                               *
//*      EditPushbutton(), EditTextbox(), EditRadiobutton(), EditScrollbox(),    *
//*      EditLjText() (private), EditRjText() (private),                         *
//*      EditSingleRadio() (private), EditGroupRadio() (private).                *
//*   - Add a new dialog control type: dctDROPDOWN. This is a standard           *
//*     drop-down control which is 'collapsed' (small) when not in use, and is   *
//*     'expanded' for user selection.                                           *
//*   - Add a new dialog control type: dctMENUWIN. This is menu window which     *
//*     is 'collapsed' (small) (or optionally invisible) when not in use, and    *
//*     is 'expanded' for user selection. Menu-win controls may be logically     *
//*     grouped to form a menu bar.                                              *
//*   - Obsolete methods:                                                        *
//*      CruiseControls(short&), EditText(short&), EditRadio(short&,short&),     *
//*      ScrollSB(short&,short&), EditLjText(DialogTextbox*)                     *
//*      EditRjText(DialogTextbox*), EditSingleRadio(short&,short&),             *
//*      EditGroupRadio(short&,short&), ScrollSB()                               *
//*   - Add method, Dump_uiInfo() to display data returned from the              *
//*     control-editing routines.                                                *
//*   - Updated DisplayRadiobuttonTypes() to open its own dialog window within   *
//*     the caller's dialog.                                                     *
//*   - Add new control type, dctSCROLLEXT, which differs from the dctSCROLLBOX  *
//*     in that the display string array and color attribute array remain        *
//*     external to the NcDialog class memory allocation, that is they remain    *
//*     in application space, so application can dynamically update the data     *
//*     as needed.                                                               *
//*   - Add method to display the Alternate Character Set, appropriately named   *
//*     DisplayAltCharacterSet().                                                *
//*   - Add method to visually connect the border of a control with the dialog   *
//*     border, ConnectControl2Border().                                         *
//*                                                                              *
//* v: 0.0.12 11-May-2007 Add hotkey support to DialogScrollbox and              *
//*                       DialogTextbox controls.                                *
//*                       Redefine DialogScrollbox::ScrollSB() interface         *
//* v: 0.0.11 12-Apr-2007 Implement support for 'exclusive-OR' radio button      *
//*                       group.                                                 *
//* v: 0.0.10 07-Apr-2007 Add method to return class version number              *
//* v: 0.0.09 29-Mar-2007 Implemented hot keys for Radio Button controls.        *
//*                       Modify macro for callback function to accept an        *
//*                       optional second parameter set to 'true' on first       *
//*                       call for any needed initializations.                   *
//* v: 0.0.08 18-Mar-2007 On opening dialog, set interior color for underlying   *
//*                       NcWindow object.                                       *
//* v: 0.0.07 10-Mar-2007 Add hotkeys to pushbutton controls                     *
//* v: 0.0.06 05-Jan-2007 Enhance cursor manipulation in dctTEXTBOX              *
//* v: 0.0.05 30-Dec-2006 Add radio-button type rbtA1 (single character)         *
//*                       and rbtC1 (single character).                          *
//* v: 0.0.04 16-Oct-2006 Add dctSCROLLBOX control                               *
//* v: 0.0.03 17-Jun-2006 Redesign of window sub-objects                         *
//* v: 0.0.02 17-Feb-2006 Overload NcWindow::ClearWin() to provide color clear   *
//* v: 0.0.01 14-Jan-2006 Original release, inherited from NcWindow class.       *
//********************************************************************************
//* Programmer's Notes:                                                          *
//*                                                                              *
//*                                                                              *
//********************************************************************************
//*  To Do List:                                                                 *
//* -- The ncurses "keypad()" functionality now captures the escape key.         *
//*    Formerly, there was a short delay after pressing the escape key           *
//*    while it was determined whether an escape sequence would follow,          *
//*    after which the escape key would be allowed through.                      *
//*    The documentation still describes this as the way things are done;        *
//*    however, we have in fact lost the use of the escape key.                  *
//*    Unfortunately, it's worse than that because the escape is still in        *
//*    in the buffer, so the following key will likely be misinterpreted.        *
//*    The problem may actually be in the Wayland-to-ncurses interface rather    *
//*    than in ncurses itself. This needs to be investigated.                    *
//*    -- Context menu and sub-menus should close on ESC key.                    *
//*    -- Textboxes and Radiobutton groups should revert to a previous           *
//*       state.                                                                 *
//*    -- Scrolling controls should return highlight to initial position.        *
//*    -- Check the escape delay.                                                *
//*    -- Additional Note: If there are multiple sequential Escape keys          *
//*       generated via the key-repeat, or eleven(11)individual keypresses,      *
//*       then the one at the top of the queue may get through, but the          *
//*       remaining Escape keycodes are still trapped in the pipe. A solution    *
//*       for this needs to be found. As a partial solution, when an Escape      *
//*       key (not part of an escape sequence), the key-input FIFO should be     *
//*       flushed.                                                               *
//*                                                                              *
//* -- Re-define the 'dispText' and 'dispColor' members of the ssetData class    *
//*    from const to make it easier to adjust the contents of the display        *
//*    data of ControlScrollext class objects.                                   *
//*    Should have no effect on functionality within the API library.            *
//*                                                                              *
//* -- Test RTL Textbox functionality.                                           *
//*    -- Cursor movement                                                        *
//*    -- When getting a copy of Textbox text, be sure to return RTL text        *
//*       rightmost character first.                                             *
//*    -- Update documentation.                                                  *
//*                                                                              *
//*                                                                              *
//* -- Cursor control in RTL Textboxes is not stable or intuitive.               *
//*    The Gnome terminal (and probably other terminal programs) now tries       *
//*    to be "helpful" by swapping keycodes and otherwise fooling around         *
//*    with the cursor position when scrolling through RTL text data.            *
//*    See discussion of BiDi text support and the BiDiEnable() method.          *
//*    -- This does not happen with fake data, but happens with Arabic and       *
//*       Yiddish.                                                               *
//*    'End' seems to work, arrows go the wrong way, wrapping occurs at the      *
//*    ends. In short, something in the terminal or in ncurses is dicking with   *
//*    the data, trying to "interpret" it as an RTL language.                    *
//*     Note that ending punctuation is automagically (and inappropriately)      *
//*     moved to the opposite end of the text, BUT does not automagically        *
//*     reverse the entire text string.                                          *
//*     Try disabling special-case cursor-key interpretation.                    *
//*     -- Keys affected: nckLEFT, nckRIGHT, nckHOME, nckEND                     *
//*     -- This kind of helpfulness directly interferes with our cursor          *
//*        positioning. For this reason, we must negate the "helpfulness"        *
//*        with a conditional compilation flag.                                  *
//*     -- Note that if a Yiddish sentence is pasted into the terminal at the    *
//*        command line, similar shenanigans happen with the cursor.             *
//*                                                                              *
//*                                                                              *
//* -- Because Wayland no longer reports the Shift key in conjunction with       *
//*    mouse scroll-wheel events, consider substituting the Ctrl key when        *
//*    selecting text with the mouse inside a textbox control.                   *
//*    See note in docs: "Specifying Keycodes For Clipboard Access".             *
//*    -- See also docs on spinner controls which formerly                       *
//*       incremented/decremented by 10 when the scroll wheel was combined       *
//*       with the Shift key.                                                    *
//*                                                                              *
//*                                                                              *
//* -- Overload the EstablishCallback() method to implement a member method      *
//*    as the callback target. Note that a "static" member method may be         *
//*    specified as a callback method, but it needs to be give EXPLICIT access   *
//*    to "this->" because static methods are not associated with any            *
//*    particular instance. See the LibreOffice doc: "Callback Methods.odt"      *
//*                                                                              *
//* -- Allow selection of a Radiobutton via hotkey to toggle its state, rather   *
//*    than simpy SET the state. This will affect only independent               *
//*    Radiobuttons, NOT members of an XOR button group.                         *
//*                                                                              *
//* --                                                                           *
//*                                                                              *
//*                                                                              *
//*                                                                              *
//* --                                                                           *
//*                                                                              *
//*                                                                              *
//* --                                                                           *
//*                                                                              *
//*                                                                              *
//*                                                                              *
//*                                                                              *
//*                                                                              *
//*                                                                              *
//********************************************************************************

//*****************
//* Include Files *
//*****************

#include "GlobalDef.hpp"               //* General definitions

#ifndef NCURSES_INCLUDED
#include "NCurses.hpp"
#endif

#ifndef NCDIALOG_INCLUDED
#include "NcDialog.hpp"
#endif

//*********************
//* Local Definitions *
//*********************

#if ENABLE_DEVELOPMENT_METHODS != 0
#include <fstream>                     //* for 'CaptureDialog' method only

//* Capture screenshots of GenericDialog() method for documentation.*
#define GD_CAPTURE (1)
#if GD_CAPTURE != 0
static short gd_callback ( const short currIndex, const wkeyCode wkey, bool firstTime ) ;
static NcDialog* gdDialogPtr = NULL ;
static attr_t gdDialogColor ;
#endif   // GD_CAPTURE

#define DEBUG_CAPTURE (0)
#if DEBUG_CAPTURE != 0
ofstream ofsdc ;
static const char* const dclog = "./dc.log" ;
static const wchar_t* ctrlName[] = 
{ L"PB", L"TB", L"BB", L"RB", L"SB", 
  L"DD", L"MW", L"SE", L"SP", L"SL" } ;
gString gsdbg ;
#endif   // DEBUG_CAPTURE

//* Non-member methods for this module *
static short ccapXOffset ( gString& src, short colOff ) ;
static void ccapShift ( wchar_t* txtsrc, attr_t* atrsrc, 
                        short shiftBase, short shiftCnt ) ;
#endif   // ENABLE_DEVELOPMENT_METHODS

//* Conditional compilation for automatic positioning of control objects which *
//* are defined on, or outside the borders of the parent dialog.               *
//* Only Scrollbox, Scrollext and Menuwin controls are DESIGNED to extend into *
//* the border area, and only Menuwin controls may extend beyond the boundary  *
//* of the parent dialog. By default, other controls MAY BE positioned in the  *
//* border area, but this is discouraged for aesthetic reasons.                *
//* '(2)' enables moving controls to a position INSIDE the dialog borders..    *
//* '(1)' (default) enables moving controls to a position ON dialog borders.   *
//* '(0)' disables all automatic repositioning.                                *
#define AUTOPOS (1)

//*********************
//* Local Data        *
//*********************

//* NcDialog class version AND NcDialog API version number.                    *
//* -------------------------------------------------------                    *
//* Note on version numbering: The version number is in three parts:           *
//* major release, minor release, build number. Releases to beta testers have  *
//* a lower-case alpha character appended. Example: "0.0.24a"                  *
//* Unlike some rapidly-advancing OS release versioning that we could mention, *
//* we are not eager to advance the major/minor versions. We believe that      *
//* software should be updated incrementally, so in general, a simple numeric  *
//* progression of build number up to 99 should happen before the minor version*
//* is incremented, and it's unlikely that the major version will EVER change. *
//* The exception would be if an update to the underlying 'ncursesw' library   *
//* introduced incompatible functionality, in which case, we would increment   *
//* the major version number and reset the minor and build. Example: "1.0.00"  *
static const char* const NcDialogVersion = "0.0.38" ;



//*************************
//*      ~NcDialog        *
//*************************
//********************************************************************************
//* Destructor for an NcDialog object.                                           *
//* Release all resources held by the dialog window and its associated control   *
//* objects. Erase dialog from the display.                                      *
//*                                                                              *
//* Important Note: If connection to the system clipboard has been established,  *
//*                 via wcbEnable(), then application should call wcbDisable()   *
//*                 before closing the final NcDialog object.                    *
//*                 Please see documentation for details.                        *
//*                                                                              *
//* Input  : none                                                                *
//*                                                                              *
//* Returns: nothing                                                             *
//********************************************************************************
//* Window*   dWin ; //* Pointer to underlying NcWindow object                   *
//*   delete dWin ;  //* this doesn't work because dWin cannot be initialized    *
//* Programmer's Note: We cannot call the NcWindow destructor directly           *
//* (delete dWin) because we do not have a handle for the object. For this       *
//* reason, we duplicate the activity of the destructor, even though this        *
//* seems to violate the spirit of inheritance.                                  *
//* This may be a basic misunderstanding about the function of destructors       *
//* for an inherited class. It is possible that the parent class destructor      *
//* is called implicitly, but it's not certain.                                  *
//********************************************************************************

NcDialog::~NcDialog ( void )
{
   //* Release resources for control objects *
   for ( short i = ZERO ; i < MAX_DIALOG_CONTROLS && dCtrl[i] != NULL ; i++ )
   {
      if ( dCtrl[i]->type == dctPUSHBUTTON )
      {
         delete (DialogPushbutton*)(dCtrl[i]) ;
      }
      else if ( dCtrl[i]->type == dctTEXTBOX )
      {
         delete (DialogTextbox*)(dCtrl[i]) ;
      }
      else if ( dCtrl[i]->type == dctBILLBOARD )
      {
         delete (DialogBillboard*)(dCtrl[i]) ;
      }
      else if ( dCtrl[i]->type == dctRADIOBUTTON )
      {
         delete (DialogRadiobutton*)(dCtrl[i]) ;
      }
      else if ( dCtrl[i]->type == dctSCROLLBOX )
      {
         delete (DialogScrollbox*)(dCtrl[i]) ;
      }
      else if ( dCtrl[i]->type == dctDROPDOWN )
      {
         delete (DialogDropdown*)(dCtrl[i]) ;
      }
      else if ( dCtrl[i]->type == dctMENUWIN )
      {
         delete (DialogMenuwin*)(dCtrl[i]) ;
      }
      else if ( dCtrl[i]->type == dctSCROLLEXT )
      {
         delete (DialogScrollext*)(dCtrl[i]) ;
      }
      else if ( dCtrl[i]->type == dctSPINNER )
      {
         delete (DialogSpinner*)(dCtrl[i]) ;
      }
      else if ( dCtrl[i]->type == dctSLIDER )
      {
         delete (DialogSlider*)(dCtrl[i]) ;
      }
   }

   //* If display data for the dialog have been captured, release it *
   if ( this->dswData != NULL )
   {
      //* Grab the tail of linked list, then          *
      //* release all display data memory allocations *
      dSaveWin *dsPtr = this->dswData,
               *delPtr ;
      while ( dsPtr->nextNode != NULL )
         dsPtr = dsPtr->nextNode ;
      while ( dsPtr != NULL )
      {
         delPtr = dsPtr ;                 // indicate node to be deleted
         if ( dsPtr->prevNode != NULL )
            (*dsPtr->prevNode).nextNode = NULL ;
         dsPtr = dsPtr->prevNode ;        // point to parent node
         delete delPtr ;                  // delete the node
         if ( delPtr == this->dswData )   // if last node
            this->dswData = NULL ;        // indicates no more saved data
      }
   }

   #if 0    // Release of WaylandCB object is disabled
   //* If Wayland clipboard is active, shut it down and release resources *
   this->wcbDisable () ;
   #endif   // Release of WaylandCB object is disabled

   // ANY ADDITIONAL DESTRUCTION WOULD OCCUR HERE!!

   //* Close the underlying window *
   NcWindow::EraseData () ;      // if there is scrolling data, reset tracking
   NcWindow::CloseWin () ;       // release the underlying ncurses window

}  //* End ~NcDialog() *

//*************************
//*       NcDialog        *
//*************************
//********************************************************************************
//* Constructor for an NcDialog object.                                          *
//*                                                                              *
//*                                                                              *
//* Input  : dDef: a fully initialized InitNcDialog class object (by reference)  *
//*                See definition of InitNcDialog class.                         *
//*                                                                              *
//* Returns: constructors implicitly return a pointer to the object              *
//********************************************************************************
//* Programmer's Note: We make an effort in instantiating the dialog window      *
//* and its controls, to maintain the integrity of the caller's                  *
//* initialization data contained in the linked list of control object           *
//* definitions (init.ctrlPtr). This is important because the application        *
//* programmer will be referring back to that data while processing requests     *
//* from the user.                                                               *
//* We give the caller considerable latitude in making mistakes in the size      *
//* and positioning of controls and their labels on the grounds that a messy     *
//* visual will be punishment enough.                                            *
//* Exception: The first control object in the list must be set as 'active',     *
//*            so this is enforced.                                              *
//* Exception: Radio-button controls have only one display line, so this is      *
//*            enforced.                                                         *
//* Exception: Spinner controls have only one display line, so this is           *
//*            enforced.                                                         *
//* Exception: Controls (except Menuwin) should live entirely within the parent  *
//*            dialog, and are automatically repositioned if necessary.          *
//*            This is under the conditional compile flag, 'AUTOPOS' at the      *
//*            top of this module.                                               *
//********************************************************************************

NcDialog::NcDialog ( InitNcDialog& dDef )

   //* Instantiate the underlying window *
   : NcWindow::NcWindow ( dDef.dLines, dDef.dColumns, dDef.dYoffset, dDef.dXoffset )
{
   this->dLines = dDef.dLines ;   // basic dialog parameters
   this->dCols  = dDef.dColumns ; // note: we don't actually limit width to MAX_DIALOG_WIDTH
   this->dulY   = dDef.dYoffset ;
   this->dulX   = dDef.dXoffset ;
   this->bStyle = dDef.borderStyle ;
   this->bColor = dDef.borderColor ;
   this->iColor = dDef.interiorColor ;
   this->overStrike = false ;    // open dialog with text input in 'insert' mode
   this->disableIns = false ;    // open dialog with 'Insert' key enabled
   this->cgGroupCode = 'A' ;     // first available code letter for control grouping
   *this->dTitle = NULLCHAR ;    // initially, no title data (but see below)
   this->ExternalControlUpdate = NULL ; // initially, no callback method established
   this->winObscured = false ;   // initially, dialog is entirely visible
   this->rtlLabels = false ;     // initially, labels and title interpreted as LTR
   this->dswData = NULL ;        // initially, no display data saved

   //* Set the Textbox-to-clipboard reserved keycodes to *
   //* default values. Note: This enables copy/cut/paste *
   //* operations for all dctTEXTBOX controls.           *
   this->SetTextboxReservedKeys () ;

   //* Set interior color in underlying window *
   NcWindow::SetInteriorColor ( this->iColor ) ;

   //* Save dialog title (if any), written to display when dialog opens. *
   //* String is truncated if necessary to fit into target buffer AND    *
   //* to fit within the display space available.                        *
   if ( dDef.dTitle != NULL )
   {
      gString dialogTitle( dDef.dTitle ) ;
      dialogTitle.copy( this->dTitle, MAX_LABEL_CHARS, (this->dCols - 4) ) ;
   }

   //* Initialize control-object-pointer array (assume no control objects) *
   for ( short i = ZERO ; i < MAX_DIALOG_CONTROLS ; i++ )
      this->dCtrl[i] = NULL ;
   this->currCtrl = -1 ;                  // no object has focus
   this->lastCtrl = -1 ;                  // there is no last control yet

   //* Instantiate the initial control objects, if any. *
   if ( dDef.ctrlPtr != NULL )
   {
      //* Programmer's Note: The use of dialog controls works only if 
      //* at least one control is 'active' i.e. may be selected for input. 
      //* For this reason, we force the first control in the list to be 
      //* 'active' which keeps the NextControl() and PrevControl() methods 
      //* from getting stuck in an endless loop. Since the application code 
      //* will most likely want the first control to have initial focus 
      //* anyway, there's no problem.
      InitCtrl* p = dDef.ctrlPtr ;        // first item in list
      p->active = true ;                  // force to active
      //* Walk through the linked list of control-initialization objects *
      for ( short ci = ZERO ; ci < MAX_DIALOG_CONTROLS && p != NULL ; ci++ )
      {
         //* Save window-relative (offset) control and label positions *
         short saveCntrlULY = p->ulY,
               saveCntrlULX = p->ulX,
               saveLabelULY = p->labY,
               saveLabelULX = p->labX ;
         p->ulY += this->dulY ; // convert control's position to window relative
         p->ulX += this->dulX ;

         //* Instantiate and initialize the control structure *
         switch ( p->type )
         {
            case dctPUSHBUTTON:
               // Programmer's Note: We do a bit of defensive programming here.
               // An unitialized InitCtrl object will have a type of dctPUSHBUTTON,
               // so we ALSO test for a non-zero dimension.
               if ( p->lines > ZERO && p->cols > ZERO )
               {
                  //* Control must be inside the dialog window.*
                  if ( (this->AutoPositionX ( p )) != OK )
                     saveCntrlULX = p->ulX - this->dulX ;
                  if ( (this->AutoPositionY ( p )) != OK )
                     saveCntrlULY = p->ulY - this->dulY ;
                  this->dCtrl[ci] = new DialogPushbutton ( p ) ;
                  ++this->lastCtrl ;         // index the last control in list
               }
               else
               {  //* Unitialized control object, end initialization loop *
                  p->nextCtrl = NULL ;
               }
               break ;

            case dctTEXTBOX:
               //* Control must be inside the dialog window.*
               if ( (this->AutoPositionX ( p )) != OK )
                  saveCntrlULX = p->ulX - this->dulX ;
               if ( (this->AutoPositionY ( p )) != OK )
                  saveCntrlULY = p->ulY - this->dulY ;

               //*Convert label offsets to dialog-window relative *
               p->labY += p->ulY - this->dulY ;
               p->labX += p->ulX - this->dulX ;
               this->dCtrl[ci] = new DialogTextbox ( p ) ;
               ++this->lastCtrl ;         // index the last control in list
               break ;

            case dctBILLBOARD:
               //* Control must be inside the dialog window.*
               if ( (this->AutoPositionX ( p )) != OK )
                  saveCntrlULX = p->ulX - this->dulX ;
               if ( (this->AutoPositionY ( p )) != OK )
                  saveCntrlULY = p->ulY - this->dulY ;

               //*Convert label offsets to dialog-window relative *
               p->labY += p->ulY - this->dulY ;
               p->labX += p->ulX - this->dulX ;
               this->dCtrl[ci] = new DialogBillboard ( p ) ;
               ++this->lastCtrl ;         // index the last control in list
               break ;

            case dctRADIOBUTTON:
               p->lines = 1 ;                // a radio button has only one line

               //* Control must be inside the dialog window.*
               // Programmer's Note: Because the 'cols' parameter is unused
               // for Radiobuttons, we plug in a dummy value for positioning.
               {
               short savedCols = p->cols ;
               switch ( p->rbSubtype )
               {
                  case rbtS3a: case rbtS3s: case rbtS3p: case rbtC3:
                     p->cols = 3 ; break ;
                  case rbtS1: case rbtC1: p->cols = 1 ; break ;
                  case rbtC2: p->cols = 2 ; break ;
                  case rbtC4: p->cols = 4 ; break ;
                  case rbtC6: p->cols = 6 ; break ;
                  case rbtS5a: case rbtS5s: case rbtS5p: case rbtC5:
                  default: p->cols = 5 ; break ;
               }
               if ( (this->AutoPositionX ( p )) != OK )
                  saveCntrlULX = p->ulX - this->dulX ;
               if ( (this->AutoPositionY ( p )) != OK )
                  saveCntrlULY = p->ulY - this->dulY ;
               p->cols = savedCols ;
               }

               //*Convert label offsets to dialog-window relative *
               p->labY += p->ulY - this->dulY ;
               p->labX += p->ulX - this->dulX ;
               this->dCtrl[ci] = new DialogRadiobutton ( p ) ;
               ++lastCtrl ;                  // index the last control in list
               break ;

            case dctSCROLLBOX:
               //* Control must be inside the dialog window.*
               // Programmer's Note: If the AUTOPOS constant (above) is set to
               // disallow controls in the border area, then the application 
               // will not be able to place Scrollbox and Scrollext controls 
               // in the border area.
               if ( (this->AutoPositionX ( p )) != OK )
                  saveCntrlULX = p->ulX - this->dulX ;
               if ( (this->AutoPositionY ( p )) != OK )
                  saveCntrlULY = p->ulY - this->dulY ;

               if ( p->labY != ZERO || p->labX != ZERO )
               {
                  //*Convert label offsets to dialog-window relative *
                  p->labY += p->ulY - this->dulY ;
                  p->labX += p->ulX - this->dulX ;
               }
               else
                  ;  // label will be processed as a scroll box title
               this->dCtrl[ci] = new DialogScrollbox ( p ) ;
               ++this->lastCtrl ;         // index the last control in list
               break ;

            case dctDROPDOWN:
               //* Control must be inside the dialog window.*
               //* Fine vertical positioning a sizing are   *
               //* handled in DialogDropdown constructor.   *
               // Programmer's Note: p->lines refers to the height of the
               // 'expanded' control, so we temporarily reduce this parameter 
               // to the size of the 'collapsed' control for positioning.
               {
               short savedLines = p->lines  ;
               p->lines = DDBOX_MIN_LINES ;
               if ( (this->AutoPositionX ( p )) != OK )
                  saveCntrlULX = p->ulX - this->dulX ;
               if ( (this->AutoPositionY ( p )) != OK )
                  saveCntrlULY = p->ulY - this->dulY ;
               p->lines = savedLines ;
               }

               //* Convert label offsets to dialog-window relative *
               p->labY += p->ulY - this->dulY ;
               p->labX += p->ulX - this->dulX ;

               this->dCtrl[ci] = new DialogDropdown ( p, this->dulY, this->dLines ) ;
               ++this->lastCtrl ;         // index the last control in list
               break ;

            case dctMENUWIN:
               //* Control must be horizontally positioned inside the dialog   *
               //* window; however, vertical _expansion_ is allowed as far     *
               //* below the dialog as there is space in the terminal window.  *
               //* This is a useful (if dangerous) feature.                    *
               if ( (this->AutoPositionX ( p )) != OK )
                  saveCntrlULX = p->ulX - this->dulX ;
               if ( (p->ulY < this->dulY) ||
                    (p->ulY >= (this->dulY + this->dLines)) )
               {
                  while ( p->ulY < this->dulY )
                     ++p->ulY ;
                  while ( p->ulY >= (this->dulY + this->dLines) )
                     --p->ulY ;
                  saveCntrlULY = p->ulY - this->dulY ;
               }
               short scrY, scrX ;
               this->ScreenDimensions ( scrY, scrX ) ;
               if ( (p->ulY + p->scrItems + 3) > scrY )
               {
                  while ( ((p->ulY + p->scrItems + 3) > scrY) && 
                          (p->ulY > this->dulY) )
                     --p->ulY ;
                  saveCntrlULY = p->ulY - this->dulY ;
               }

               this->dCtrl[ci] = new DialogMenuwin ( p, this->dulY, this->dLines ) ;
               ++this->lastCtrl ;         // index the last control in list
               break ;

            case dctSCROLLEXT:
               //* Control must be inside the dialog window.*
               // Programmer's Note: If the AUTOPOS constant (above) is set to
               // disallow controls in the border area, then the application 
               // will not be able to place Scrollbox and Scrollext controls 
               // in the border area.
               if ( (this->AutoPositionX ( p )) != OK )
                  saveCntrlULX = p->ulX - this->dulX ;
               if ( (this->AutoPositionY ( p )) != OK )
                  saveCntrlULY = p->ulY - this->dulY ;

               if ( p->labY != ZERO || p->labX != ZERO )
               {
                  //*Convert label offsets to dialog-window relative *
                  p->labY += p->ulY - this->dulY ;
                  p->labX += p->ulX - this->dulX ;
               }
               else
                  ;  // label will be processed as a scroll ext title
               this->dCtrl[ci] = new DialogScrollext ( p ) ;
               ++this->lastCtrl ;         // index the last control in list

               //* If caller has provided live data, initialize it now.*
               if ( p->dispText != NULL && p->scrColor != NULL && 
                    p->scrItems > ZERO && 
                    (p->scrSel >= ZERO && p->scrSel < p->scrItems) )
               {
                  DialogScrollext* cp = (DialogScrollext*)this->dCtrl[ci] ;
                  const char** tmpTextptr = cp->bText ;
                  const attr_t* tmpAttrptr = cp->bColor ;
                  ssetData sData( (const char**)p->dispText, p->scrColor, 
                                   p->scrItems, p->scrSel ) ;
                  if ((this->SetScrollextText ( ci, sData )) != OK )
                  {  //* Restore dummy data *
                     cp->bText  = tmpTextptr ;
                     cp->bColor = tmpAttrptr ;
                  }
               }
               break ;

            case dctSPINNER:
               p->lines = 1 ;             // spinners have only one line

               //* Control must be inside the dialog window.*
               if ( (this->AutoPositionX ( p )) != OK )
                  saveCntrlULX = p->ulX - this->dulX ;
               if ( (this->AutoPositionY ( p )) != OK )
                  saveCntrlULY = p->ulY - this->dulY ;

               //*Convert label offsets to dialog-window relative *
               p->labY += p->ulY - this->dulY ;
               p->labX += p->ulX - this->dulX ;
               this->dCtrl[ci] = new DialogSpinner ( p ) ;
               ++this->lastCtrl ;         // index the last control in list
               break ;

            case dctSLIDER:
               //* Sliders must be >= 1 in each direction. *
               if ( p->lines <= ZERO )    p->lines = 1 ;
               if ( p->cols  <= ZERO )    p->cols  = 1 ;

               //* Control must be inside the dialog window.*
               if ( (this->AutoPositionX ( p )) != OK )
                  saveCntrlULX = p->ulX - this->dulX ;
               if ( (this->AutoPositionY ( p )) != OK )
                  saveCntrlULY = p->ulY - this->dulY ;

               //*Convert label offsets to dialog-window relative *
               p->labY += p->ulY - this->dulY ;
               p->labX += p->ulX - this->dulX ;
               this->dCtrl[ci] = new DialogSlider ( p ) ;
               ++this->lastCtrl ;         // index the last control in list
               break ;

            case dctTYPES:                // quiet idiotic compiler warning
            default:                      // invalid type ignored
               //* If first control is invalid, then 'lastCtrl' == -1 and *
               //* 'currCtrl' == -1 i.e. no controls defined.             *
               //* Otherwise, at least one valid control, but discard     *
               //* current and subsequent definitions.                    *
               //* Note that an unitialized object WILL have a valid type.*
               p->nextCtrl = NULL ;
               break ;
         }
         p->ulY  = saveCntrlULY ;// restore caller's initialization data
         p->ulX  = saveCntrlULX ;
         p->labY = saveLabelULY ;
         p->labX = saveLabelULX ;

         //* Default hotkey is assigned if control's label is *
         //* defined without a hotkey. (for mouse interface)  *
         if ( (this->dCtrl[ci] != NULL) &&
              (this->dCtrl[ci]->bHotkey.hotkey == false) )
            this->meAssignDefaultHotkey ( ci ) ;

         p = p->nextCtrl ;                // point to next object initializer
      }  // for(;;)
      this->currCtrl = ZERO ;             // first object in list gets initial focus
   }

   //* If the NCurses Engine shows that the mouse interface is enabled,   *
   //* then set our local mouse flags to match those of the parent dialog.*
   //* a) meAuto   : Set as 'true' because there is no point in having    *
   //*               a mouse inteface without conversion to keycodes.     *
   //* b) meStable : Test whether our event types match the 'stable'      *
   //*               mouse interface and set the flag accordingly.        *
   //* c) meDClick : We don't have access to the parent dialog's value    *
   //*               for this member, so we use the default.              *
   if ( this->meMouseEnabled () != false )
   {
      mmask_t eventTypes ;
      this->meGetEventTypes ( eventTypes ) ;
      if ( (eventTypes == (BUTTON1_RELEASED | REPORT_SCROLL_WHEEL))
           || (eventTypes == BUTTON1_RELEASED) )
      {
         this->meEnableStableMouse ( ncmiSTABLE, (eventTypes & REPORT_SCROLL_WHEEL) ) ;
      }
      else
         this->meAutoConvert ( true ) ;
   }

}  //* End NcDialog() *

//*************************
//*     OpenWindow        *
//*************************
//******************************************************************************
//* Allocate additional resources for a previously-instantiatiated dialog      *
//* and draw the dialog in the terminal window.                                *
//*                                                                            *
//* Input  : none                                                              *
//*                                                                            *
//* Returns: OK if successful, else ERR                                        *
//******************************************************************************

short NcDialog::OpenWindow ( void )
{
short    result ;

   if ( (result = NcWindow::OpenWindow ()) == OK )
   {
      //* Draw the dialog window and all of its control objects *

      //* If a dialog title was specified during instantiation, include it in  *
      //* the border; else, draw a plain border.                               *
      if ( *this->dTitle != NULLCHAR )
      {
         gString title( this->dTitle ) ;
         this->DrawBorder ( this->bColor, title.ustr(), 
                            this->bStyle, this->rtlLabels ) ;
      }
      else
         this->DrawBorder ( this->bColor, NULL, this->bStyle ) ;
      this->ClearWin () ;                 // draw the interior in the specified color

      //* If one or more dialog sub-objects have been specified and *
      //* instantiated by the constructor, display them.            *
      for ( short i = ZERO ; i < MAX_DIALOG_CONTROLS && this->dCtrl[i] != NULL ; i++ )
      {
         //* Control has been previously instantiated; make it visible *
         // (first control in list (index ZERO) initially has the input focus)
         this->dCtrl[i]->OpenControl ( i ? false : true ) ;
         switch ( dCtrl[i]->type )
         {
            case dctTEXTBOX:
            case dctBILLBOARD:
            case dctRADIOBUTTON:
            case dctDROPDOWN:
            case dctSPINNER:
            case dctSLIDER:
               dCtrl[i]->DrawLabel ( this, this->iColor, this->rtlLabels ) ;
               break ;
            case dctSCROLLBOX:
               //* If control's label was written as a title,   *
               //* it's been handled; else, it's a normal label.*
               if ( dCtrl[i]->labY != ZERO || dCtrl[i]->labX != ZERO )
                  dCtrl[i]->DrawLabel ( this, this->iColor, this->rtlLabels ) ;
               break ;
            case dctSCROLLEXT:
               //* If control's label was written as a title,   *
               //* it's been handled; else, it's a normal label.*
               if ( dCtrl[i]->labY != ZERO || dCtrl[i]->labX != ZERO )
                  dCtrl[i]->DrawLabel ( this, this->iColor, this->rtlLabels ) ;
               break ;
            case dctPUSHBUTTON:  // pushbuttons do not have labels
            case dctMENUWIN:     // menu labels are embedded within the control
            default:
               break ;
         }
      }

      //* Refresh entire dialog window *
      this->RefreshWin () ;
   }
   return result ;

}  //* End OpenWindow() *

//*************************
//*     RefreshWin        *
//*************************
//******************************************************************************
//* Refresh display of dialog window and all its controls. Used to update      *
//* display with changes made to the dialog or its controls.                   *
//* If the dialog had previously been marked as 'obscured', (see HideWin()),   *
//* re-draw the dialog image and discard the saved image data.                 *
//*                                                                            *
//* Input  : none                                                              *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************

void NcDialog::RefreshWin ( void )
{
   //* If dialog window is hidden or obscured, restore it *
   if ( this->winObscured != false )
   {
      this->ShowWin () ;
   }
   NcWindow::RefreshWin () ;        // refresh the underlying dialog window

   //* Refresh the objects in the dialog-object list *
   for ( short i = ZERO ; i < MAX_DIALOG_CONTROLS && dCtrl[i] != NULL ; i++ )
   {
      if ( dCtrl[i]->type == dctSCROLLBOX )  // scroll box requires special processing
      {
         DialogScrollbox* cp = (DialogScrollbox*)(dCtrl[i]) ;
         cp->RefreshControl () ;
      }
      else if ( dCtrl[i]->type == dctDROPDOWN ) // Dropdown requires special processing
      {
         DialogDropdown* cp = (DialogDropdown*)(dCtrl[i]) ;
         cp->RefreshControl () ;
      }
      else if ( dCtrl[i]->type == dctMENUWIN ) // menu-win requires special processing
      {
         DialogMenuwin* cp = (DialogMenuwin*)(dCtrl[i]) ;
         cp->RefreshControl () ;
      }
      else if ( dCtrl[i]->type == dctSCROLLEXT )  // scroll ext requires special processing
      {
         DialogScrollext* cp = (DialogScrollext*)(dCtrl[i]) ;
         cp->RefreshControl () ;
      }
      //* all other controls use the default method *
      else
         dCtrl[i]->RefreshControl () ;
   }

}  //* End RefreshWin() *

//*************************
//*      ClearWin         *
//*************************
//******************************************************************************
//* Erase (overwrite with spaces) contents of the window using the window's    *
//* background color, but do not refresh display.                              *
//*                                                                            *
//* Input  : clearAll: (optional, false by default)                            *
//*                    if 'false' clear interior, leaving border               *
//*                    if 'true' clear entire window including border          *
//*                                                                            *
//* Returns: OK                                                                *
//******************************************************************************

short NcDialog::ClearWin ( bool clearAll )
{
short    winCols, firstRow, firstCol, rows ;

   //* Clear entire window *
   if ( (clearAll != false) || (this->dLines == 1) || (this->dCols == 1) )
   {
      winCols = this->dCols ;
      firstRow = ZERO ;
      firstCol = ZERO ;
      rows = this->dLines ;
   }
   //* Clear only interior of window *
   else
   {
      winCols = this->dCols - 2 ;
      firstRow = 1 ;
      firstCol = 1 ;
      rows = this->dLines - 2 ;
   }

   char  outBuff[MAX_DIALOG_WIDTH * 2] ;
   short i ;
   for ( i = ZERO ; i < winCols ; i++ )   // construct fill string
      outBuff[i] = SPACE ;
   outBuff[i] = NULLCHAR ;

   //* Clear the defined area of the window *
   for ( i = firstRow ; i <= rows ; i++ )
      WriteString ( i, firstCol, outBuff, iColor ) ;

   return OK ;
   
}  //* End ClearWin() *

//*************************
//*      ClearLine        *
//*************************
//******************************************************************************
//* Clear the specified line of the dialog using the defined background color. *
//*                                                                            *
//* Input  : lIndex  : index of line to be cleared (zero-based)                *
//*          clearAll: (optional, 'false' by default)                          *
//*                    if 'true', clear entire line                            *
//*                    if 'false' do not clear border area                     *
//*          xpos : (optional, by default, for LTR: one(1), for RTL: columns-2)*
//*                 starting column (zero-based)                               *
//*                 (ignored if clearAll != false)                             *
//*          rtl  : (optional, 'false' by default)                             *
//*                 if 'false', then clear from 'xpos' toward right            *
//*                 if 'true',  then clear from 'xpos' toward left             *
//*                 (ignored if clearAll != false)                             *
//* Returns: OK if successful, ERR if invalid line index                       *
//******************************************************************************
//* Note: This is a pass-through method to NcWindow parent class.              *
//******************************************************************************

short NcDialog::ClearLine ( short lIndex, bool clearAll, short xpos, bool rtl )
{

   return ( NcWindow::ClearLine ( lIndex, clearAll, xpos, rtl ) ) ;

}  //* End ClearLine() *

//*************************
//*      ClearLine        *
//*************************
//******************************************************************************
//* Clear the specified line of the dialog using an alternate color attribute. *
//*                                                                            *
//* Input  : lIndex  : index of line to be cleared                             *
//*          altColor: color attribute for the target line                     *
//*          clearAll: (optional, 'false' by default)                          *
//*                    if 'true', clear entire line                            *
//*                    if 'false' do not clear border area                     *
//*                                                                            *
//* Returns: OK if successful, ERR if invalid line index                       *
//******************************************************************************

short NcDialog::ClearLine ( short lIndex, attr_t altColor, bool clearAll )
{
   short xOffset = 1,
         xCount  = this->dCols - 2,
         status = ERR ;

   if ( clearAll == false && lIndex > ZERO && lIndex < (this->dLines - 1) )
      status = OK ;
   else if ( clearAll != false && lIndex >= ZERO && lIndex < this->dLines )
   {
      --xOffset ;
      xCount += 2 ;
      status = OK ;
   }
   
   if ( status == OK )
   {
      while ( xCount-- > ZERO )
         this->WriteChar ( lIndex, xOffset++, L' ', altColor ) ;
      this->RefreshWin () ;
   }
   return status ;

}  //* End ClearLine() *

//*************************
//*       ClearArea       *
//*************************
//******************************************************************************
//* Clear the specified rectangular area of the dialog window.                 *
//* Optionally use an alternate color attribute and/or an alternate fill       *
//* character.                                                                 *
//*                                                                            *
//* Input  : lIndex   : index of top line of target area                       *
//*          cIndex   : index of left column of target area                    *
//*          lCount   : number of lines in target area                         *
//*          cCount   : number of columns in target area                       *
//*          fillColor: (optional, dialog window's background color by default)*
//*                     alternate color attribute for the target area          *
//*          fillChar : (optional, SPACE character by default)                 *
//*                     alternate character to write into each character cell  *
//*                     NOTE: Specified character must be a single-column      *
//*                           character. A multi-column character              *
//*                           specification will be ignored.                   *
//*                                                                            *
//* Returns: OK if successful, ERR if parameter(s) out-of-range                *
//******************************************************************************

short NcDialog::ClearArea ( short lIndex, short cIndex, 
                            short lCount, short cCount, 
                            attr_t fillColor, wchar_t fillChar )
{
   short status = ERR ;       // return value

   if ( (lIndex >= ZERO && lIndex < this->dLines) &&
        (cIndex >= ZERO && cIndex < this->dCols)  &&
        (lCount > ZERO) && (cCount > ZERO)        &&
        ((lIndex + lCount) <= this->dLines)        &&
        ((cIndex + cCount) <= this->dCols) )
   {
      if ( fillColor == attr_t(-1) )
         fillColor = this->iColor ;

      if ( fillChar != nckSPACE )
      {
         gString gs( "%C", &fillChar ) ;
         if ( gs.gscols() > 1 )
            fillChar = nckSPACE ;
      }

      short lastRow = lIndex + lCount - 1,
            lastCol = cIndex + cCount - 1 ;
      for ( short ln = lIndex ; ln <= lastRow ; ln++ )
      {
         for ( short col = cIndex ; col <= lastCol ; col++ )
            this->WriteChar ( ln, col, fillChar, fillColor ) ;
      }
      this->RefreshWin () ;
      status = OK ;
   }

   return status ;

}  //* End ClearArea() *

//*************************
//*  ClearTerminalWindow  *
//*************************
//******************************************************************************
//* Clear the entire terminal window, then redraw the dialog.                  *
//* Call this method if an external process called from within your application*
//* may have written garbage into the terminal window.                         *
//*                                                                            *
//* Display data for the calling dialog will be automatically saved, and the   *
//* restored after the terminal window has been cleared.                       *
//*                                                                            *
//* Important Note:                                                            *
//* ---------------                                                            *
//* If multiple dialog windows are open within the terminal window, it is      *
//* caller's responsibility to protect the data of the other dialogs.          *
//* Before calling this method, call SetDialogObscured() for each of the other *
//* dialogs, and then after returning from ClearTerminalWindow(),              *
//* call RefreshWin() for each of the other dialogs.                           *
//*                                                                            *
//* Input  : none                                                              *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************

void NcDialog::ClearTerminalWindow ( void )
{

   this->SetDialogObscured () ;
   nc.ClearScreen () ;
   this->RefreshWin () ;

}  //* End ClearTerminalWindow() *

//*************************
//*       HideWin         *
//*************************
//******************************************************************************
//* Hide the dialog window from view, that is, save its display data, then     *
//* erase it from the screen.                                                  *
//* If display data have not already been saved by a previous call to          *
//* SetDialogObscured(), data will be saved before erase.                      *
//* If application has already saved the display data through a previous call  *
//* to SetDialogObscured(), just erase the dialog's display data.              *
//*                                                                            *
//* A call to RefreshWin() will make window visible again and release the      *
//* saved data.                                                                *
//*                                                                            *
//* Input  : blankingColor: (optional) specifies a background color to be      *
//*                         used for erasing the dialog window                 *
//*                         default==use parent window's background color      *
//*                                                                            *
//* Returns: OK                                                                *
//******************************************************************************

short NcDialog::HideWin ( attr_t blankingColor )
{
   //* If display data have not already been saved, save now *
   if ( this->winObscured == false )
      this->SetDialogObscured () ;

   //* Erase the dialog display area *
   attr_t dColor = this->iColor ;   // save our existing background color
   //* By default, erase the window using parent window's background color *
   if ( blankingColor == attrDFLT )                                             
      this->iColor = this->wp->_bkgd ; // substitute parent's background color
   else                                // use caller's background color
      this->iColor = blankingColor ;
   this->ClearWin ( true ) ;                          
   this->iColor = dColor ;          // restore original background color

   //* Refresh the underlying window (but not the dialog controls) *
   NcWindow::RefreshWin () ;

   return OK ;

}  //* End HideWin() *

//*************************
//*      TermResized      *
//*************************
//******************************************************************************
//* PRIVATE METHOD:                                                            *
//* Called from inside control editing routines ONLY, and only if we have      *
//* received a terminal-resize-event signal (nckRESIZE).                       *
//* The underlying ncurses library sees this event and refreshes the terminal  *
//* screen, making all windows in the screen, i.e. our dialog invisible.       *
//* There is a potential timing issue here, so we first refresh the terminal   *
//* screen, so it will think everything has been updated, THEN we refresh our  *
//* dialog window.                                                             *
//*   a) Update the NCurses class screen dimension variables.                  *
//*   b) Refresh the terminal screen                                           *
//*   c) Refresh the dialog window.                                            *
//*                                                                            *
//* Input  : none                                                              *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************

void NcDialog::TermResized ( void )
{
   short r, c ;
   this->ScreenDimensions ( r, c ) ;
   nc.RefreshScreen () ;
   this->RefreshWin () ;

}  //* End TermResized() *

//****************************
//* CaptureDialogDisplayData *
//****************************
//******************************************************************************
//* Capture the display data for the dialog window. Display data include       *
//* character data, color data, and attribute data.                            *
//*                                                                            *
//* The data are stored in a doubly-linked list of dSaveWin class objects.     *
//* The application can only create a single copy of the display data.         *
//* This is done through a call to HideWin() or SetDialogObscured().           *
//* However, within the NcDialog class, we can save as many copies as we       *
//* like through a direct call to this method, provided that we release them   *
//* before returning to the application.                                       *
//*                                                                            *
//* Input  : none                                                              *
//*                                                                            *
//* Returns: OK if successful,                                                 *
//*          ERR if memory-allocation error                                    *
//******************************************************************************

void  NcDialog::CaptureDialogDisplayData ( void )
{
   dSaveWin*  previousNode = NULL ;
   dSaveWin** dsPtr = &this->dswData ;    // point to top of linked list
   while ( *dsPtr != NULL )               // Point to the next free pointer
   {
      previousNode = *dsPtr ;             // pointer to current node
      dsPtr = &(*dsPtr)->nextNode ;
   }
   *dsPtr = new dSaveWin( this->dLines, this->dCols ) ;
   (*dsPtr)->prevNode = previousNode ;
   this->CaptureWindow ( *(*dsPtr)->swPtr ) ;
   this->winObscured = true ; // indicate that display data have been saved

}  //* End CaptureDialogDisplayData() *

//*************************
//*     CaptureDialog     *
//*************************
//********************************************************************************
//* PUBLIC METHOD.                                                               *
//* Capture the dialog's display data, text and color attributes to a file.      *
//*                                                                              *
//* Input  : fPath       : full path/filename for data to be saved               *
//*          fhtml       : (optional, false by default)                          *
//*                        if 'false', then save as text data                    *
//*                                    (viewable in text editor)                 *
//*                        if 'true',  then save as HTML data                    *
//*                                    (viewable in web browser)                 *
//*          timeStamp   : (optional, default == true)                           *
//*                        if 'true', then write the timestamp record at the     *
//*                                   top of the output file.                    *
//*                        if 'false, then do not write the timestamp record     *
//*          stylePath   : (optional, HTML output only)                          *
//*                        if specified, path/filename to CSS definition file    *
//*                        (path will be written into the HTML <head></head>)    *
//*                        default == "screenshot-styles.css"                    *
//*          cellsPerLine: (optional, HTML output only)                          *
//*                        range: 1-40,  default == 4                            *
//*                        if specified, the number of <td></td> cells written   *
//*                        per output line                                       *
//*          lineComments: (optional, HTML output only, default == true)         *
//*                        if 'true', then the raw text of each line is written  *
//*                                   as a comment for easy searching            *
//*                        if 'false', then do not write the comment lines       *
//*          simpleColor : (optional, HTML output only, default == ZERO)         *
//*                        interior color of the of the dialog being captured    *
//*                        Referenced ONLY when simple HTML capture has been     *
//*                        specified (see docs for details)                      *
//*          microSpace  : (optional, HTML output only, default == false)        *
//*                        if 'false', do not perform micro-spacing scan         *
//*                        if 'true', scan for CJK characters and add            *
//*                                   micro-spacing for column alignment         *
//*                        Referenced ONLY when simple HTML capture has been     *
//*                        specified (see docs for details)                      *
//*                                                                              *
//* Returns: OK if successful                                                    *
//*          ERR  : a) if parameter out-of-range                                 *
//*                 b) if unable to write data to specified file                 *
//*                 c) if development methods are disabled                       *
//********************************************************************************
//* Programmer's Note:                                                           *
//* - We first call the low-level window capture method to capture the main      *
//*   dialog window.                                                             *
//* - Then, we scan all the sub-windows (control objects) and integrate their    *
//*   display data into the main dialog's data.                                  *
//*                                                                              *
//* Programmer's Note:                                                           *
//* Each ncurses 'window' object has its own memory space for display data, so   *
//* accessing the display data for window 'A' will not capture any window        *
//* object 'B' which lies within 'A'.                                            *
//*                                                                              *
//* For this reason, capture of the main dialog window object will not, by       *
//* default, include data for the control objects within the dialog because      *
//* control objects are themselves window objects. This behavior is no problem   *
//* if we are simply saving the window (see 'SetDialogObscured', 'HideWin' and   *
//* 'ShowWin') because each control has a copy of its own data and can refresh   *
//* itself when the dialog is restored.                                          *
//*                                                                              *
//* However, if we want a more complete set of display data, we must capture     *
//* the control objects separately and integrate them with the data of the       *
//* main window.                                                                 *
//*                                                                              *
//* Conceptually, this is easy, and for controls that are composed of only one   *
//* window object, the operation is straightforward. What proves tricky in       *
//* practice is capture and integration of control objects which consist of      *
//* MULTIPLE window objects, which are functionally bound together e.g.          *
//* controls with borders. We must also be aware of these controls' 'STATE'      *
//* such and 'open', 'closed', 'expanded', 'collapsed', etc.                     *
//*                                                                              *
//* Another issue is that we must capture 'expanded' controls AFTER other data   *
//* because the 'expanded' control will obscure some underlying data, either     *
//* parent-window data or other controls. Dropdown controls are easy because     *
//* they are only 'expanded' when they have focus. Menuwin controls may be       *
//* cascaded, so the control with focus may be obscuring its parent, the parent  *
//* obscuring the grandparent and so on. Fortunately, we believe that child      *
//* menus will naturally be instantiated in the corrent order, so we don't       *
//* worry about cascading. Context menus, if visible, have the focus, and must   *
//* be captured LAST.                                                            *
//* -- When the data of the interior line of an expanded Dropdown or an expanded *
//*    menu has a different number of characters than the data it obscures, the  *
//*    attribute shift for HTML targets may be incorrect. This is fairly rare,   *
//*    but annoying.                                                             *
//* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  - *
//* Example Invocaton:                                                           *
//* dp->CaptureDialog ( "./capturedlgMSO.txt" ) ;                                *
//* dp->CaptureDialog ( "./capturedlgMSO.html", true, false,                     *
//*                     "infodoc-styles.css", 4, false, nc.blR ) ;               *
//* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  - *
//* The algorithm used here for control object capture is inefficient, but       *
//* robust for both single-column and multi-column characters. This is OK        *
//* because it's only a development/documentation method.                        *
//*             See ccapFile() for additional information.                       *
//********************************************************************************

short NcDialog::CaptureDialog ( const char* fPath, bool fhtml, bool timeStamp, 
                                const char* stylePath, short cellsPerLine,
                                bool lineComments, attr_t simpleColor, 
                                bool microSpace )
{
   short status = ERR ;             // return value

   //* Capture the parent dialog's static display data *
   SaveWin sw( this->wLines, this->wCols ) ;
   if ( (status = this->CaptureDialog ( sw )) == OK )
   {
      #if ENABLE_DEVELOPMENT_METHODS != 0
      //******************************************************
      //* Format the parent dialog's display data for output.*
      //******************************************************
      wchar_t  txtData[sw.wRows][sw.wCols+1] ;  // formatted text data
      attr_t   atrData[sw.wRows][sw.wCols+1] ;  // formatted color attribute data
      gString  gsfmt ;                          // display-data formatting
      short    sIndex = ZERO,                   // source index
               rIndex,                          // target row index
               cIndex,                          // target column index
               charCount,                       // char count (not incl. NULLCHAR)
               colCount ;                       // column count

      #if DEBUG_CAPTURE != 0
      ofsdc.open( dclog, ofstream::out | ofstream::trunc ) ;
      if ( ofsdc.is_open() )
      {
         gsdbg.compose( "CaptureDialog - SaveWin - wRows:%02hd wCols:%03hd\n",
                        &sw.wRows, &sw.wCols ) ;
         gsdbg.padCols( gsdbg.gscols() * 2, L'=' ) ;
         ofsdc << gsdbg.ustr() << endl ;
      }
      #endif   // DEBUG_CAPTURE

      //* Scan each row of captured dialog data and map it to our work buffer *
      for ( rIndex = ZERO ; rIndex < sw.wRows ; rIndex++ )
      {
         gsfmt = &sw.wText[sIndex] ;            // get a buffer-full of raw data
         gsfmt.limitCols( sw.wCols ) ;          // truncate to dialog width
         gsfmt.copy( txtData[rIndex], gsfmt.gschars() ) ; // save formatted text
         charCount = gsfmt.gschars() - 1 ;
         for ( short i = ZERO ; i < charCount ; i++ ) // copy color attributes
            atrData[rIndex][i] = sw.wAttr[sIndex++] ; // and advance source index
      }

      //**********************************************************
      //* Capture display data for individual control objects    *
      //* and overlay them onto the parent dialog's data.        *
      //* (Note that this loop is only for single-state controls)*
      //* (and other controls only in the 'collapsed' state.)    *
      //**********************************************************
      for ( short ctrl = ZERO ; ctrl <= this->lastCtrl ; ctrl++ )
      {
         if (   (this->dCtrl[ctrl]->type == dctPUSHBUTTON)
             || (this->dCtrl[ctrl]->type == dctRADIOBUTTON)
             || (this->dCtrl[ctrl]->type == dctTEXTBOX)
             || (this->dCtrl[ctrl]->type == dctBILLBOARD)
             || (this->dCtrl[ctrl]->type == dctSPINNER)
             || (this->dCtrl[ctrl]->type == dctSLIDER)
            ) 
         {
            DialogPushbutton *cpt = (DialogPushbutton*)(dCtrl[ctrl]) ;
            rIndex = cpt->ulY - this->dulY ;
            this->ccapSimple ( cpt, (wchar_t*)txtData, (attr_t*)atrData, (sw.wCols+1) ) ;
         }  // dctPUSHBUTTON, dctRADIOBUTTON, dctTEXTBOX, dctBILLBOARD, dctSPINNER, dctSLIDER


         else if (   (this->dCtrl[ctrl]->type == dctSCROLLBOX )
                  || (this->dCtrl[ctrl]->type == dctSCROLLEXT) )
         {
            DialogScrollbox *cpt = (DialogScrollbox*)(dCtrl[ctrl]) ;
            this->ccapMulti ( cpt, (wchar_t*)txtData, (attr_t*)atrData, (sw.wCols+1) ) ;
         }  // dctSCROLLBOX, dctSCROLLEXT

         //* Process Dropdown controls here ONLY if the *
         //* object is in 'collapsed; state.            *
         else if ( this->dCtrl[ctrl]->type == dctDROPDOWN )
         {
            DialogDropdown *cpt = (DialogDropdown*)(dCtrl[ctrl]) ;
            if ( cpt->expanded == false )
            {
               SaveWin swt( cpt->tLines, cpt->tCols ) ;
               cpt->tPtr->CaptureWindow ( swt ) ;
               rIndex = cpt->tPtr->wulY - this->dulY ;
               sIndex = ZERO ;
               short colOffset = (cpt->tPtr->wulX - this->dulX), j ;

               #if DEBUG_CAPTURE != 0
               if ( ofsdc.is_open() )
               {
                  gsdbg.compose( "%S: %02hd x %02hd", 
                                 ctrlName[cpt->type], &swt.wRows, &swt.wCols ) ;
                  ofsdc << gsdbg.ustr() << endl ;
               }
               #endif   // DEBUG_CAPTURE

               for ( short i = ZERO ; i < swt.wRows ; i++ )
               {  //* Get character offset of target column *
                  gsfmt = txtData[rIndex + i] ;
                  cIndex = ccapXOffset ( gsfmt, colOffset ) ;
   
                  gsfmt = &swt.wText[sIndex] ;
                  gsfmt.limitCols( swt.wCols ) ;
                  charCount = gsfmt.gschars() - 1 ;
                  colCount  = gsfmt.gscols() ;

                  #if DEBUG_CAPTURE != 0
                  if ( ofsdc.is_open() )
                  {
                     short ri = rIndex + i ;
                     gsdbg.compose( "    %02hd) '%S' chars:%02hd cols:%02hd r+i:%02hd\n", 
                                    &i, gsfmt.gstr(), &charCount, &colCount, &ri ) ;
                     ofsdc << gsdbg.ustr() ;
                  }
                  #endif   // DEBUG_CAPTURE

                  j = ZERO ;
                  for ( short cit = ZERO ; cit < charCount ; cit++, j++ )
                  {
                     txtData[rIndex + i][cIndex + j] = gsfmt.gstr()[cit] ;
                     atrData[rIndex + i][cIndex + j] = swt.wAttr[sIndex + cit] ;
                  }
                  sIndex += charCount ;
                  if ( colCount > charCount )
                  {
                     #if DEBUG_CAPTURE != 0
                     if ( ofsdc.is_open() )
                     {
                        gsdbg.compose( "        '%S'\n", &txtData[rIndex + i][cIndex] ) ;
                        ofsdc << gsdbg.ustr() ;
                     }
                     #endif   // DEBUG_CAPTURE

                     ccapShift ( &txtData[rIndex + i][cIndex + j],
                                 &atrData[rIndex + i][cIndex + j], 
                                 ZERO, (charCount - colCount) ) ;

                     #if DEBUG_CAPTURE != 0
                     if ( ofsdc.is_open() )
                     {
                        gsdbg.compose( "        '%S'\n", &txtData[rIndex + i][cIndex] ) ;
                        ofsdc << gsdbg.ustr() ;
                     }
                     #endif   // DEBUG_CAPTURE
                  }
               }
            }
         }     // dctDROPDOWN (collapsed)

         else if ( this->dCtrl[ctrl]->type == dctMENUWIN )
         {  //* Note that this capture is for dctMENUWIN objects which are *
            //* both visible AND in the the 'collapsed' state.             *
            //* 1) Independent, non-context menus are always visible and   *
            //*    will be captured regardless of whether they are active. *
            //* 2) Collapsed context menus are inactive and invisible, and *
            //*    thus are not captured. Context menus are only visible   *
            //*    when expanded, and thus are ignored here.               *
            //* 3) Grouped menus may be visible or hidden when in the      *
            //*    collapsed state.                                        *
            DialogMenuwin *cpt = (DialogMenuwin*)(dCtrl[ctrl]) ;
            if ( (cpt->expanded == false) && 
                 ((cpt->groupCode > ZERO && cpt->grpVisible != false) ||
                  (cpt->groupCode == ZERO && *cpt->wLabel != NULLCHAR)) )
            {
               rIndex = cpt->tPtr->wulY - this->dulY ;
               this->ccapMTit ( cpt, txtData[rIndex], atrData[rIndex] ) ;
            }
         }     // dctMENUWIN (collapsed and visible)
      }

      //***************************************************
      //* Capture display data for 'expanded' control     *
      //* objects (which may be obscuring other controls) *
      //* and overlay them onto the parent dialog's data. *
      //***************************************************
      for ( short ctrl = ZERO ; ctrl <= this->lastCtrl ; ctrl++ )
      {
         if ( this->dCtrl[ctrl]->type == dctDROPDOWN )
         {
            DialogDropdown *cpt = (DialogDropdown*)(dCtrl[ctrl]) ;
            if ( cpt->expanded != false )
            {
               this->ccapMulti ( (DialogScrollbox*)cpt, (wchar_t*)txtData, 
                                 (attr_t*)atrData, (sw.wCols+1) ) ;
            }
         }     // dctDROPDOWN (expanded)

         else if ( this->dCtrl[ctrl]->type == dctMENUWIN )
         {
            DialogMenuwin *cpt = (DialogMenuwin*)(dCtrl[ctrl]) ;
            if ( cpt->expanded != false )
            {
               //* If this is not a context menu, capture the menu-title line.*
               if ( *cpt->wLabel != NULLCHAR )
               {
                  rIndex = cpt->tPtr->wulY - this->dulY ;
                  this->ccapMTit ( cpt, txtData[rIndex], atrData[rIndex] ) ;
               }

               //* Capture the primary menu window *
               this->ccapMulti ( (DialogScrollbox*)cpt, (wchar_t*)txtData, 
                                (attr_t*)atrData, (sw.wCols+1) ) ;
            }
         }     // dctMENUWIN (expanded)
      }

      //*******************************************
      //* Write the captured data to target file. *
      //*******************************************
      status = this->ccapFile ( sw, (wchar_t*)txtData, (attr_t*)atrData, 
                                fPath, fhtml, timeStamp, stylePath, cellsPerLine, 
                                lineComments, simpleColor, microSpace ) ;

      #if DEBUG_CAPTURE != 0
      if ( ofsdc.is_open() )
         ofsdc.close() ;
      #endif   // DEBUG_CAPTURE
      #else    // CAPTURE-TO-FILE IS DISABLED
      status = ERR ;
      #endif   // ENABLE_DEVELOPMENT_METHODS
   }
   return status ;

}  //* End CaptureDialog() *

//*************************
//*     CaptureDialog     *
//*************************
//******************************************************************************
//* PRIVATE METHOD:                                                            *
//* Capture the dialog's display data, text and color attributes.              *
//*                                                                            *
//* Input  : sw       : (by reference) initialized SaveWin object              *
//*                     specifies position and size of area to be captured     *
//*                     and contains memory allocated for the capture          *
//*                                                                            *
//* Returns: OK if successful                                                  *
//*          ERR if: parameter out of range OR                                 *
//*                  unable to write data to specified file (development only) *
//******************************************************************************

short NcDialog::CaptureDialog ( SaveWin& sw )
{
   //* Capture the dialog display data to memory *
   return ( this->CaptureWindow ( sw ) ) ;

}  //* End CaptureDialog() *

//*************************
//*       ccapFile        *
//*************************
//********************************************************************************
//* Called only by 'CaptureDialog'. Write the captured data to the target file.  *
//*                                                                              *
//* Input  : sw      : statistics for dialog window                              *
//*          txtData : pointer to two-dimentional text-data array                *
//*          atrData : pointer to two-dimentional attribute-data array           *
//*          fPath   : full path/filename for data to be saved                   *
//*          fhtml   : if false, save to plain text file                         *
//*                    if true, save in HTML format                              *
//*          tStamp  : if true, insert timestamp into file                       *
//*                    if false, omit timestamp                                  *
//*          sPath   : path/filename of CSS definition file       (HTML only)    *
//*          cpl     : <td> cells per output line                 (HTML only)    *
//*          lComment: if true, insert                            (HTML only)    *
//*          sbg     : background color for 'simpleFormat'        (HTML only)    *
//*          microsp : if true, scan for CJK characters and add   (HTML only)    *
//*                      microspacing for column alignent                        *
//*                                                                              *
//* Returns: OK if data successfully written, else ERR                           *
//********************************************************************************
//* Programmer's Note:                                                           *
//* - Plain Text Output:                                                         *
//*   Plain text output is quite straightforward. First, the text data are       *
//*   written using the same format as the source data, and then the color       *
//*   attributes are written as 8 columns of ASCII hex.                          *
//*                                                                              *
//* - HTML Output:                                                               *
//*   HTML output comes in two flavors:                                          *
//*   a) Table-based output for maximum color-attribute support.                 *
//*      This format looks great, but the downside is that it needs extensive    *
//*      CSS support and the file size is moderately huge.                       *
//*      - Required CSS definitions: 'screenshot-styles.css'                     *
//*      - 'sbg' is ignored                                                      *
//*   b) Simple block-based output for use in Texinfo documents.                 *
//*      This format supports only a subset of the color attributes used in      *
//*      NcDialog applications, but requires far less CSS support and the        *
//*      file size is relatively small, allowing for easy cut-and-paste into     *
//*      Texinfo documents.                                                      *
//*      - Required CSS definitions: 'infodoc-styles.css'                        *
//*      - 'tStamp' and 'lComment' are forced to 'false'.                        *
//*      - 'cpl' is ignored                                                      *
//*   Note that HTML capture lines and attributes are padded with null           *
//*   characters, so that each line of source data, has the same number of       *
//*   characters.                                                                *
//*   Refer to the Texinfo documentation for details on dialog capture.          *
//*                                                                              *
//*                                                                              *
//* NOTES:                                                                       *
//* ======                                                                       *
//* - 'simpleFormat' capture is invoked by having the CSS path include the       *
//*    filename 'infodoc-styles.css'. This is the CSS file used by the NcDialog  *
//*    API Texinfo documentation (HTML format).                                  *
//*    - The background color of the display area ('sbg') must be specified by   *
//*      caller. We tried to find it automagically, but the test was unreliable  *
//*      because there is no guarantee that any particular cell is actually a    *
//*      character in the dialog background.                                     *
//*    - The width of the display area is calculated according to the ratio      *
//*      of character width to character height; however,the multiplier is       *
//*      subject to minor adjustment to align the right edge of background and   *
//*      foreground. While this is mathematically, 0.61257, the amount of        *
//*      magnification used in the browser window does not track well because    *
//*      the foreground expands by pixel and the background expands by quanta    *
//*      (em). This is not a big issue, but it is annoying.                      *
//*                area_width == dialog width in columns * 0.61257               *
//*      See 'colMultiplier' below.                                              *
//* - 'simpleFormat' capture is not particularly beautiful.                      *
//*    - The colors are a bit dull and the foreground/background contrast is     *
//*      not very good.                                                          *
//*    - There are artifacts between characters due to character spacing.        *
//*    - If background of a control != background of dialog, we get an artifact  *
//*      between lines due to line spacing. This is compensated by the CSS       *
//*      style: "line-spacing:117%;" in the tscap class.                         *
//*    - For the color attributes 'gybk' 'gyre' 'gygr' 'gybr' 'gybl' 'gyma'      *
//*      and 'gycy', the text is very dim because we strip the ncbATTR (bold)    *
//*      foreground attribute bit. This makes for an ugly capture. Other of      *
//*      the special color combinations suffer from a similar degradation.       *
//*      We do our best to compensate with CSS in 'infodoc-styles.css'.          *
//*                                                                              *
//* - Multi-column characters will cause vertical misalignment in the HTML       *
//*   document because the browser renders them at less than two full            *
//*   columns.                                                                   *
//*   - If we write two columns-worth of characters per <td> sequence, then      *
//*     we can correctly display Chinese (two-column) characters so long as      *
//*     the characters fall on an even-numbered column.                          *
//*       <td><span class="wxyz">C</span><span class="wxyz">C</span></td>        *
//*     While this is certainly possible, it causes minor artifacts,             *
//*     especially with line-drawing characters.                                 *
//*   - Instead of creating tables to align CJK characters, we apply             *
//*     micro-spacing for column alignment.                                      *
//*     See discussion of micro-spacing in ccapMicrospace() method.              *
//*                                                                              *
//* - For HTML only: certain characters are rendered by some fonts in a browser  *
//*   as two-column characters. These characters may be automagically replaced   *
//*   by similar single-column characters.                                       *
//*   Currently, only the U+25C6 character is replaced. The other characters     *
//*   listed are not regularly used in the API, and are therefore not worth the  *
//*   performance hit needed to scan for them. We may revisit this occasionally. *
//*   - The primary character is the diamond used for dropdown scrolling         *
//*     controls and radiobuttons. Replace ( '◆' U+25C6 ) with ( '♦' U+2666 ).   *
//*   - Other offenders are the right and left-pointing triangles:               *
//*     ( '▶' U+25B6 )                                                           *
//*     ( '◀' U+25C0 )                                                           *
//********************************************************************************

short NcDialog::ccapFile ( SaveWin& sw, const wchar_t* txtData, const attr_t* atrData, 
                           const char* fPath, bool fhtml, bool tStamp, 
                           const char* sPath, short cpl,  bool lComment, 
                           attr_t sbg, bool microsp )
{
   //* The mathematically-calculated width multiplier used to calculate   *
   //* the CSS style element "max-width" is 0.61257. Practically speaking *
   //* however, this value is slightly too large.                         *
   //* The actual multiplier value was determined experimentally.         *
   //const double colMultiplier = 0.61257 ;
   const double colMultiplier = 0.60220 ;

   short status = ERR ;             // return value

   #if ENABLE_DEVELOPMENT_METHODS != 0
   //*****************************
   //**  Shared text/HTML data  **
   //*****************************
   //* Date-time stamp for output files *
   const wchar_t* const DateTimeHdrA = 
      L"// Created: %04hu-%02hu-%02hu @ %02hu:%02hu:%02hu" ;
   const char* const DateTimeHdrB = 
      "// ------------------------------" ;
   const short xDim = sw.wCols + 1 ;   // columns per row + NULLCHAR

   //*****************************
   //**   HTML-specific data    **
   //*****************************
   //* Color lookup table *
   const short colorATTR = 16 ;
   const short colorCOMBO = 8 ;
   const short customATTR = 56 ;
   const attr_t ncxATTR = ncbATTR | ncuATTR ;
   const attr_t ncyATTR = ncrATTR | ncuATTR ;
   const attr_t nczATTR = ncbATTR | ncrATTR | ncuATTR ;
   const char* classBW[colorCOMBO] = 
   { "bw_n", "bw_b", "bw_u", "bw_r", "bw_g", "bw_x", "bw_y", "bw_z" } ;
   const char* classRE[colorCOMBO] =
   { "re_n", "re_b", "re_u", "re_r", "re_g", "re_x", "re_y", "re_z" } ;
   const char* classGR[colorCOMBO] =
   { "gr_n", "gr_b", "gr_u", "gr_r", "gr_g", "gr_x", "gr_y", "gr_z" } ;
   const char* classBR[colorCOMBO] =
   { "br_n", "br_b", "br_u", "br_r", "br_g", "br_x", "br_y", "br_z" } ;
   const char* classBL[colorCOMBO] =
   { "bl_n", "bl_b", "bl_u", "bl_r", "bl_g", "bl_x", "bl_y", "bl_z" } ;
   const char* classMA[colorCOMBO] =
   { "ma_n", "ma_b", "ma_u", "ma_r", "ma_g", "ma_x", "ma_y", "ma_z" } ;
   const char* classCY[colorCOMBO] =
   { "cy_n", "cy_b", "cy_u", "cy_r", "cy_g", "cy_x", "cy_y", "cy_z" } ;
   const char* classGY[colorCOMBO] =
   { "gy_n", "gy_b", "gy_u", "gy_r", "gy_g", "gy_x", "gy_y", "gy_z" } ;

   const char* classBBK[colorCOMBO] =
   { "bbkn", "bbkb", "bbku", "bbkr", "bbkg", "bbkx", "bbky", "bbkz" } ;
   const char* classBRE[colorCOMBO] =
   { "bren", "breb", "breu", "brer", "breg", "brex", "brey", "brez" } ;
   const char* classBGR[colorCOMBO] =
   { "bgrn", "bgrb", "bgru", "bgrr", "bgrg", "bgrx", "bgry", "bgrz" } ;
   const char* classBBR[colorCOMBO] =
   { "bbrn", "bbrb", "bbru", "bbrr", "bbrg", "bbrx", "bbry", "bbrz" } ;
   const char* classBBL[colorCOMBO] =
   { "bbln", "bblb", "bblu", "bblr", "bblg", "bblx", "bbly", "bblz" } ;
   const char* classBMA[colorCOMBO] =
   { "bman", "bmab", "bmau", "bmar", "bmag", "bmax", "bmay", "bmaz" } ;
   const char* classBCY[colorCOMBO] =
   { "bcyn", "bcyb", "bcyu", "bcyr", "bcyg", "bcyx", "bcyy", "bcyz" } ;
   const char* classBGY[colorCOMBO] =
   { "bgyn", "bgyb", "bgyu", "bgyr", "bgyg", "bgyx", "bgyy", "bgyz" } ;
                                           
   const char** classes[colorATTR] = 
   {
      classBW, 
      classRE, 
      classGR, 
      classBR, 
      classBL, 
      classMA, 
      classCY, 
      classGY, 
      classBBK, 
      classBRE, 
      classBGR, 
      classBBR, 
      classBBL, 
      classBMA, 
      classBCY, 
      classBGY, 
   } ;

   const char* custom[customATTR] = 
   {
      "bkre", "bkgr", "bkbr", "bkbl", "bkma", "bkcy", "bkgy",
      "rebk", "regr", "rebr", "rebl", "rema", "recy", "regy", 
      "grbk", "grre", "grbr", "grbl", "grma", "grcy", "grgy", 
      "brbk", "brre", "brgr", "brbl", "brma", "brcy", "brgy", 
      "blbk", "blre", "blgr", "blbr", "blma", "blcy", "blgy", 
      "mabk", "mare", "magr", "mabr", "mabl", "macy", "magy", 
      "cybk", "cyre", "cygr", "cybr", "cybl", "cyma", "cygy",            
      "gybk", "gyre", "gygr", "gybr", "gybl", "gyma", "gycy",
   } ;

   const short WHITEBG = 8 ;
   const char* bgName[WHITEBG + 2] = 
   {
      "black",       // black
      "#CC0000",     // red
      "green",       // green
      "maroon",      // brown
      "blue",        // blue
      "#990099",     // magenta
      "#009999",     // cyan
      "gray",        // grey
      "white",       // white
      "ERROR" // this would be a program error
   } ;

   //* Header, <head></head> information for HTML output. *
   static const char* htmlHead = 
   "<!DOCTYPE HTML>\n"
   "<html>\n"
   "<head>\n"
   "<!-- Copyright (c) 2024 The Software Samurai - Released under GNU GPL version 3. -->\n"
   "<meta charset=\"utf-8\" />  <!-- Import the global stylesheet -->\n"
   "<link rel=\"stylesheet\" href=\"%s\" lang=\"en\" type=\"text/css\"/>\n"
   "</head>\n"
   "\n"
   "<body>\n"
   "<div class=\"curses_container\">" ;

   static const char* htmlTail = 
   "\n<br></div>\n"
   "</body>\n"
   "</html>\n"
   "\n" ;

   static const char* dfltStyles = "screenshot-styles.css" ;
   static const char* infoStyles = "infodoc-styles.css" ;
   //* Table-formatted (complex) output *
   static const char* tableStart = "<table class=\"dialog\">\n" ;
   static const char* tableEnd   = "</table>\n" ;
   static const char* trStart    = "  <tr>\n" ;
   static const char* trEnd      = "  </tr>\n" ;
   static const char* tdTemplate = " <td class=\"%s\">%C</td>" ;
   static const char* tdPad      = "   " ;
   //* Div-formatted (simple) output *
   static const char* divStart = 
      "<div class=\"tscap\" style=\"background-color:%s; max-width:%.2lfem;\">" ;
   static const char* divEnd   = "</div>" ;
   static const char* spanStart = 
      "<span class=\"%s\">%C" ; // insert the color class and first character
   static const char* spanEnd = "</span>" ;

   //* Get current system date/time.                 *
   //* (if system call fails, zeros will be written) *
   USHORT date = ZERO,     // Day of the month (1-[28|29|30|31])
          month = ZERO,    // Month of the year (1 == Jan, ... 12 == Dec)
          year = ZERO,     // Year (four digit year)
          hours = ZERO,    // Time of day, hour (0-23)
          minutes = ZERO,  // Time of day, minutes (0-59)
          seconds = ZERO ; // Time of day, seconds (0-59)
   time_t epoch = time ( NULL ) ;
   if ( epoch >= 0 )
   {
      typedef struct tm Tm ;
      Tm tm ;
      if ( (localtime_r ( &epoch, &tm )) != NULL )
      {
         date    = tm.tm_mday ;       // today's date
         month   = tm.tm_mon + 1 ;    // month
         year    = tm.tm_year + 1900 ;// year
         hours   = tm.tm_hour ;       // hour
         minutes = tm.tm_min ;        // minutes
         seconds = tm.tm_sec ;        // seconds
      }
   }

   //* Open the file, discarding any previous contents *
   ofstream ofs ;
   ofs.open( fPath, ofstream::out | ofstream::trunc ) ;
   if ( ofs.is_open() )       // if input file open
   {
      status = OK ;           // good news
      gString gsOut ;         // output formatting

      //******************************
      //* Output as plain UTF-8 text *
      //******************************
      if ( fhtml == false )
      {
         if ( tStamp )
         {
            ofs << "// ***  Capture Display Data  ***" << endl ;
            gsOut.compose( "// ***  Rows:%3hu Cols:%3hu     ***", 
                           &sw.wRows, &sw.wCols ) ;
            ofs << gsOut.ustr() << endl ;
            short py = this->wulY + sw.wulY, px = this->wulX + sw.wulX ;
            gsOut.compose( "// ***  WinOffset: Y%3hu X%3hu  ***", &py, &px ) ;
            ofs << gsOut.ustr() << endl ;
            gsOut.compose( DateTimeHdrA, &year, &month, &date,
                           &hours, &minutes, &seconds ) ;
            ofs << gsOut.ustr() << endl ;
            ofs << DateTimeHdrB << "\n" << endl ;
         }

         //* Write the text data *
         for ( short i = ZERO ; i < sw.wRows ; i++ )
         {
            gsOut = &txtData[i * xDim] ;
            ofs << gsOut.ustr() << endl ;
         }

         //* Write the color attribute data *
         ofs << "\n// COLOR ATTRIBUTES (hex):" << endl ;
         short charCount ;
         for ( short rIndex = ZERO ; rIndex < (sw.wRows * xDim) ; rIndex += xDim )
         {
            gsOut = &txtData[rIndex] ;
            charCount = gsOut.gschars() - 1 ;
            for ( short i = ZERO ; i < charCount ; i++ )
            {
               gsOut.compose( L"%08X ", &atrData[rIndex + i] ) ;
               ofs << gsOut.ustr() ;
               if ( (i % 8 == 7) || (i == (charCount-1)) )
                  ofs << endl ;
            }
         }
         ofs << "\n// END CAPTURE" << endl ;
      }     // text format

      //******************************
      //* Output as an HTML document *
      //******************************
      else
      {
         gString gsLine,               // input-data parsing
                 cssName = dfltStyles, // path/filename for CSS definitions
                 gsTmp ;               // misc formatting
         attr_t basePair ;             // color pair bits in original position
         double  max_width = 1.0 ;     // block width (simpleFormat only)
         short   bgindex = WHITEBG ;   // dialog background color (simpleFormat only)
         short naughtyChar ;           // index of misbehaving character(s) (see note above)
         bool simpleFormat = false ;   // if 'true', then simple HTML, else table-based capture
         if ( sPath != NULL )
         {
            cssName = sPath ;          // alternate CSS style
            if ( (cssName.find( infoStyles, ZERO, true )) >= ZERO )
            {
               simpleFormat = true ;
               max_width = (sw.wCols * colMultiplier) ; // (see note in method header)
               tStamp = false ;        // disable timestamp output
               lComment = false ;      // disable per-line comments in output
               basePair = sbg & ncmPAIR_MASK ;
               NcColorMap cmap ;
               nc.GetColorMap ( cmap ) ;        // get a copy of the color map
               short mapIndex = basePair >> 8 ; // convert color to color pair
               if ( basePair >= nc.bbk )        // if 16-color, map to 8-color
                  mapIndex -= (nc.bbk >> 8) ;   // Range: 0x00 through 0x3F
               if ( (basePair == nc.bw || basePair == nc.bbk) && sbg & ncrATTR )
                  bgindex = ZERO ;
               else
                  bgindex = (sbg & ncrATTR) ? cmap.pairMap[mapIndex].fgnd 
                                            : cmap.pairMap[mapIndex].bkgnd ;
               //* If ncurses '-1' default background, or (GASP) programmer error *
               if ( bgindex < ZERO || bgindex > WHITEBG )
                  bgindex = WHITEBG ;
            }
         }
         // Programmer's Note: cells-per-line works for any positive integer; 
         // however, we enforce an upper limit to keep each line within the 
         // working range of a gString object: (1 <= cpl <= gsALLOCDFLT).
         // A <td> cell is approximately 24 characters (ses tdTemplate), so 
         // 24 * 40 == 960 characters.
         if ( cpl < 1 || cpl > 40 )
            cpl = 4 ;

         const wchar_t* wPtr ;         // source pointer
         int   lineLen,                // characters on line
               cIndex,                 // character index ;
               td_count ;              // number of <td> tags written on current line
         const char** grpPtr ;
         attr_t classIndex, pairIndex, attrBits ;
         //* Note: Supported color pairs 00h - 7Fh (128 pairs).        *
         //* Note: Supported color-attribute bits for HTML output are: *
         //*       Table Format : Bold, Underline, and Reverse         *
         //*       Simple Format: Underline, and Reverse               *
         const attr_t attrMASK = simpleFormat ? (ncuATTR | ncrATTR) :
                                 (ncbATTR | ncuATTR | ncrATTR) ;
                      //pairMASK = (ncmPAIR_MASK >> 8) ;

         //* Write HTML header and link in CSS definitions. *
         gsOut.compose( htmlHead, cssName.ustr() ) ;
         ofs << gsOut.ustr() << endl ;

         if ( tStamp )
         {
            ofs << "<div class=\"timestamp\">\n"
                << "// ***  Capture Display Data  ***\n" ;
            gsOut.compose( "// ***  Rows:%3hu Cols:%3hu     ***\n", 
                           &sw.wRows, &sw.wCols ) ;
            ofs << gsOut.ustr() ;
            short py = this->wulY + sw.wulY, px = this->wulX + sw.wulX ;
            gsOut.compose( "// ***  WinOffset: Y%3hu X%3hu  ***\n", &py, &px ) ;
            ofs << gsOut.ustr() ;
            gsOut.compose( DateTimeHdrA, &year, &month, &date,
                           &hours, &minutes, &seconds ) ;
            ofs << gsOut.ustr() << "\n"
                << DateTimeHdrB << "\n"
                << "</div> <!-- End Timestamp -->\n" << endl ;
         }


         //* Complex table-based HTML output *
         if ( simpleFormat == false )
         {
            ofs << tableStart ;        // start-of-table tag
            for ( short lIndex = ZERO ; lIndex < sw.wRows ; lIndex++ )
            {
               //* Get a line of text data *
               gsLine = &txtData[lIndex * xDim] ;

               if ( (naughtyChar = gsLine.find( L'◆' )) >= ZERO )
               { gsLine.replace( L'◆', L'♦', naughtyChar, false, true ) ; }

               wPtr = gsLine.gstr( lineLen ) ;
               --lineLen ;             // don't count the null character
               cIndex = ZERO ;         // initialize character index
               td_count = ZERO ;       // reset the <td> counter

               if ( lComment )         // if comments enabled
                  ofs << "  <!-- " << gsLine.ustr() << " -->\n" ;
               ofs << trStart ;        // start-of-row tag

               while ( cIndex < lineLen )
               {  //* Get color attribute of next character *
                  basePair  = (atrData[lIndex * xDim + cIndex]) ;
                  attrBits  = basePair & attrMASK ;
                  pairIndex = (basePair &= ncmPAIR_MASK) >> 8 ;

                  //* For the basic 16 pairs, select the class with the correct   *
                  //* pair AND the corresponding color attributes.                *
                  //* Because pairs 8-15 are actually defined at 40h-47h, we must *
                  //* translate them.                                             *
                  if (   (basePair >= nc.bw && basePair <= nc.gy) 
                      || (basePair >= nc.bbk && basePair <= nc.bgy) )
                  {
                     if ( basePair >= nc.bbk && basePair <= nc.bgy )
                        pairIndex -= 0x38 ;
                     grpPtr = classes[pairIndex] ;
                     switch ( attrBits )
                     {
                        case ncbATTR:  classIndex = 1 ;    break ;   // Bold
                        case ncuATTR:  classIndex = 2 ;    break ;   // Underline
                        case ncrATTR:  classIndex = 3 ;    break ;   // Reverse
                        case ncgATTR:  classIndex = 4 ;    break ;   // Bold + Reverse
                        case ncxATTR:  classIndex = 5 ;    break ;   // Bold + Underline
                        case ncyATTR:  classIndex = 6 ;    break ;   // Reverse + Underline
                        case nczATTR:  classIndex = 7 ;    break ;   // Bold+Reverse+Underline
                        case ZERO:                                   // normal
                        default:       classIndex = ZERO ; break ;
                     }
                  }

                  //* For custom color pairs, select the corresponding class,     *
                  //* but INGNORE the color attributes.                           *
                  //* Range check the color pair to avoid array overrun.          *
                  else if ( ((basePair >= (nc.bkre & ncmPAIR_MASK)) && 
                             (basePair <= (nc.gycy & ncmPAIR_MASK)))
                            ||
                            ((basePair >= (nc.bbkre & ncmPAIR_MASK)) && 
                             (basePair <= (nc.bgycy & ncmPAIR_MASK))) )
                  {
                     //* Color pairs constructed using RGB registers 0x08-0x0F    *
                     //* do not have their own CSS definitions at this time, so   *
                     //* we map them to the 8-color definitions.                  *
                     if ( (basePair >= (nc.bbkre & ncmPAIR_MASK)) && 
                          (basePair <= (nc.bgycy & ncmPAIR_MASK)) )
                        pairIndex -= 0x40 ;
                     attrBits = ZERO ;       // discard attribute bits
                     grpPtr = custom ;
                     classIndex = pairIndex - ncbcCOLORS ;
                  }
                  else
                  {  //* Color pairs > 0x7F receive the default f/b color, and we *
                     //* insert a comment into the HTML markup.                   *
                     grpPtr = classes[ZERO] ; classIndex = ZERO ;
                     gsTmp.compose( "<!--UNSUPPORTED COLOR PAIR: (%02lXh) ON LINE %hd-->\n", 
                                    &pairIndex, &lIndex ) ;
                     ofs << gsTmp.ustr() ;
                  }

                  //* Write a <tr>x</tr> sequence. *
                  if ( td_count == ZERO )    // if this is a new output line
                     ofs << tdPad ;
                  gsOut.compose( tdTemplate, grpPtr[classIndex], &wPtr[cIndex++] ) ;
                  ofs << gsOut.ustr() ;

                  //* Control the number of <td> tags per output line.*
                  if ( (++td_count >= cpl) || (cIndex >= lineLen) )
                  {
                     ofs << "\n" ;        // terminate the output line
                     td_count = ZERO ;    // reset the counter
                  }
               }
               ofs << trEnd ;          // end-of-row tag
            }
            ofs << tableEnd ;          // end-of-table tag
         }

         //* Simple block-based HTML output *
         // Programmer's Note: See note above about scanning for multi-column 
         // characters and adjusting the character cell width.
         // Programmer's Note: See note above about the dull nature of some 
         // color combinations.
         else     // (simpleFormat != false)
         {
            //* start-of-div tag *
            gsOut.compose( divStart, bgName[bgindex], &max_width ) ;
            ofs << gsOut.ustr() ;
   
            //* Process dialog lines *
            attr_t firstAttr, firstPair ;
            for ( short lIndex = ZERO ; lIndex < sw.wRows ; ++lIndex )
            {
               //* Get a line of text data *
               gsLine = &txtData[lIndex * xDim] ;

               if ( (naughtyChar = gsLine.find( L'◆' )) >= ZERO )
               { gsLine.replace( L'◆', L'♦', naughtyChar, false, true ) ; }

               wPtr = gsLine.gstr( lineLen ) ;
               --lineLen ;             // don't count the null character
               cIndex = ZERO ;         // initialize character index
   
               //* Start of row *
               firstAttr = ((atrData[lIndex * xDim + cIndex]) & (ncmPAIR_MASK | attrMASK)) ;
               firstPair = (firstAttr & ncmPAIR_MASK) ;
               if ( firstPair >= nc.bbk )
                  firstPair -= 0x00004000 ;
               pairIndex = firstPair >> 8 ;
               if ( firstPair >= nc.bw && firstPair <= nc.gy)
               {
                  grpPtr = classes[pairIndex] ;
                  attrBits = firstAttr & attrMASK ;
                  switch ( attrBits )
                  {
                     case ncuATTR:  classIndex = 2 ;    break ;   // Underline
                     case ncrATTR:  classIndex = 3 ;    break ;   // Reverse
                     case ncyATTR:  classIndex = 6 ;    break ;   // Reverse + Underline
                     case ZERO:                                   // normal
                     default:       classIndex = ZERO ; break ;
                  }
               }
               //* For custom color pairs, select the corresponding class,     *
               //* but INGNORE the color attributes.                           *
               //* Range check the color pair to avoid array overrun.          *
               else if ( (firstPair >= (nc.bkre & ncmPAIR_MASK)) && 
                         (firstPair <= (nc.gycy & ncmPAIR_MASK)) )
               {
                  grpPtr = custom ;
                  classIndex = pairIndex - ncbcCOLORS ;
               }
               else
               {  //* Color pairs > 0x7F receive the default f/b color, and we *
                  //* insert a comment into the HTML markup.                   *
                  grpPtr = classes[ZERO] ; classIndex = ZERO ;
                  gsOut.compose( "<!--UNSUPPORTED COLOR PAIR ON LINE %hd-->\n", &lIndex ) ;
                  ofs << gsOut.ustr() ;
               }
               gsOut.compose( spanStart, grpPtr[classIndex], &wPtr[cIndex++] ) ;
   
               //* Scan to end-of-line to find where color attribute changes.*
               while ( cIndex < lineLen )
               {  //* Get color attribute of next character *
                  attrBits  = ((atrData[lIndex * xDim + cIndex]) & (ncmPAIR_MASK | attrMASK)) ;
                  if ( attrBits == firstAttr )
                     gsOut.append( wPtr[cIndex++] ) ;
                  else
                  {
                     gsOut.append( spanEnd ) ;  // end run for current color attribute
   
                     //* Begin run for new attribute *
                     firstAttr = attrBits ;
                     firstPair = (firstAttr & ncmPAIR_MASK ) ;
                     if ( firstPair >= nc.bbk )
                        firstPair -= 0x00004000 ;
                     pairIndex = firstPair >> 8 ;
                     if ( firstPair >= nc.bw && firstPair <= nc.gy)
                     {
                        grpPtr = classes[pairIndex] ;
                        attrBits = firstAttr & attrMASK ;
                        switch ( attrBits )
                        {
                           case ncuATTR:  classIndex = 2 ;    break ;   // Underline
                           case ncrATTR:  classIndex = 3 ;    break ;   // Reverse
                           case ncyATTR:  classIndex = 6 ;    break ;   // Reverse + Underline
                           case ZERO:                                   // normal
                           default:       classIndex = ZERO ; break ;
                        }
                     }
                     else if ( (firstPair >= (nc.bkre & ncmPAIR_MASK)) && 
                               (firstPair <= (nc.gycy & ncmPAIR_MASK)) )
                     {
                        grpPtr = custom ;
                        classIndex = pairIndex - ncbcCOLORS ;
                     }
                     else
                     {  //* Color pairs > 0x7F receive the default f/b color, and we *
                        //* insert a comment into the HTML markup.                   *
                        grpPtr = classes[ZERO] ; classIndex = ZERO ;
                        gsTmp.compose( "<!--UNSUPPORTED COLOR PAIR ON LINE %hd-->\n", &lIndex ) ;
                        ofs << gsTmp.ustr() ;
                     }
                     gsTmp.compose( spanStart, grpPtr[classIndex], &wPtr[cIndex++] ) ;
                     gsOut.append( gsTmp.gstr() ) ;
                  }
   
                  // Important Note: It is possible that gsOut _could_ be filled
                  // before the line is fully concatenated. Logically, this would
                  // require more than 25 color changes on a single line which is 
                  // very unlikely. If this happens, the gString object will
                  // automatically expand its storage capacity to accomodate.
                  // Therefore, this overflow test is no longer required.
                  //if ( gsOut.gschars() >= (gsALLOCDFLT - 10) )  break ;
               }
   
               //* End of row *
               gsOut.append( spanEnd ) ;

               //* If specified, apply micro-spacing to the CJK text.*
               if ( microsp )
                  this->ccapMicrospace ( gsOut ) ;

               ofs << gsOut.ustr() << '\n' ;
            }
            ofs << divEnd ;            // end-of-div tag
         }

         ofs << htmlTail << endl ;  // close the HTML elements
      }     // html format

      ofs.close() ;           // close the target file
   }
   #endif   // ENABLE_DEVELOPMENT_METHODS

   return status ;

}  //* End ccapFile() *

//*************************
//*    ccapMicrospace     *
//*************************
//******************************************************************************
//* Apply microspacing for multi-column characters.                            *
//* Called by ccapFile() method (HTML output only) to align column output.     *
//*                                                                            *
//* Scan the data for multi-column characters and encapsulate each multi-column*
//* character sequence within the "cjk" CSS class. Micro-space characters are  *
//* added as necessary for column alignment.                                   *
//*                                                                            *
//* Input  : gsHtml : HTML string to be adjusted                               *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************
//* Using unicode micro-spaces for alignment of CJK (Chinese/Japanese/Korean)  *
//* characters.                                                                *
//*                                                                            *
//* 1) For the 'simple' HTML format, we COULD adjust the column spacing on a   *
//*    per-character basis. For example:                                       *
//*     <span class="bl_n" style="letter-spacing:0.15em;">是</span>            *
//*     This works, but is difficult, slow and produces unreadable HTML.       *
//* 2) The less-elegant, but more practical solution is to insert              *
//*    fractional-width characters into sequences of CJK characters to provide *
//*    micro-alignment.                                                        *
//*    a) Potential alignment characters are:                                  *
//*        -- &emsp13; (&#x2004;)   3.0-per-em width                           *
//*        -- &emsp14; (&#x2005;)   4.0-per-em width                           *
//*        -- &hairsp; (&#x200A;)   5.5-per-em width                           *
//*        --          (&#x2006;)   6.0-per-em width                           *
//*    b) Note that inside a fixed-width class, all of these micro-space       *
//*       characters are rendered as 1.0em width; therefore, we need a CSS     *
//*       class with a variable-width font for application of micro-space      *
//*       alignment. The CSS styling file, "infodoc-styles.css" includes the   *
//*       "cjk" class specifically for this purpose.                           *
//*       Example: <span class="cjk">统&hairsp;&hairsp;</span>                 *
//*    c) A full-width 2.0em character occupies (approximately) the same       *
//*       space as eleven(11) &hairsp; characters.                             *
//*    d) CJK characters, when rendered in a browser, actually occupy          *
//*       (approximately) the same space as nine(9) &hairsp; characters.       *
//*       Thus, for each CJK character in the span, two(2) &hairsp; characters *
//*       must be added to to achieve acceptable column alignment.             *
//*       Some example span definitions would be:                              *
//*         <span class="cjk">统&hairsp;&hairsp;计&hairsp;&hairsp;</span>       *
//*         <span class="cjk">统计&hairsp;&hairsp;&hairsp;&hairsp;</span>       *
//*       The first example shows two &hairsp; characters inserted after each  *
//*       CJK character, while the second example shows all needed &hairsp;    *
//*       characters grouped at the end of the sequence. For most sample data, *
//*       these two formats produce nearly identical output; however, the      *
//*       first example is the implementation used here.                       *
//*    e) Note that because we are working within a variable-width font,       *
//*       non-CJK characters should not be enclosed within the "cjk" span      *
//*       because they will be kerned differently from the 2.0em characters.   *
//*    f) We could get cute by using a combination of different micro-space    *
//*       characters to provide alignment; however, we have determined         *
//*       experimentally that alignment for CJK characters is more accurate    *
//*       when using only &hairspace; characters. This finding may not hold    *
//*       for other multi-column character sets.                               *
//*                                                                            *
//* This implementation is not perfect. Font kerning uses a complex algorithm  *
//* with calculations in the hundredths of an EM. We cannot hope remove the    *
//* kerning with the same precision. With that said, the output produced       *
//* during testing is as good as (or better than) manual tweaking of the       *
//* HTML source. Testing was performed on dialog display data captured by the  *
//* author's "Exercalc" application which is implemented using a multi-lingual *
//* user interface. The application captures mixed numerical and text data in  *
//* columnar format and saves it in HTML format.                               *
//*                                                                            *
//******************************************************************************

void NcDialog::ccapMicrospace ( gString& gsHtml )
{
   #if ENABLE_DEVELOPMENT_METHODS != 0
   #define TWO_PER (1)     // '1' for production, '0' for experimental algorithm
   #if TWO_PER == 0
   short hairs ;     // number of hair-space padding characters needed
   #endif   // TWO_PER

   const wchar_t* const beginSpan = L"<span class=\"cjk\">" ;
   const wchar_t* const endSpan   = L"&hairsp;&hairsp;</span>" ;
   const wchar_t* const hairPlug  = L"&hairsp;&hairsp;" ;

   int   charCount ;             // total wchar_t characters in text string
   //* Pointer to array of column values *
   const short *colPtr = gsHtml.gscols( charCount ) ;

// BUG! - THERE ARE OCCASIONAL PARSING ERRORS WHERE A TRAILING SPAN IS LOST.
//      - SEE CAPTURE OF EXERCALC userDlg WINDOW IN ZHONGWEN.
   short begi,       // index beginning of multi-column character sequence
         endi ;      // index end of multi-column character sequence

   for ( short indx = charCount - 1 ; indx > ZERO ; --indx )
   {
      if ( colPtr[indx] > 1 )                // multi-column character found
      {
         endi = indx + 1 ;                   // index AFTER last char in the sequence
         --indx ;
         while ( (colPtr[indx] > 1) && (indx >= ZERO) )
            --indx ;
         begi = indx + 1 ;                   // index AT first char in sequence

         #if TWO_PER != 0
         gsHtml.insert( endSpan, endi ) ;    // end the 'cjk' span
         while ( --endi > begi )             // two(2) hair spaces follow each char
            gsHtml.insert( hairPlug, endi ) ;
         gsHtml.insert( beginSpan, begi ) ;  // begin the 'cjk' span

         #else    // micro-spaces grouped and end of sequence (experimental only)
         hairs = (endi - begi) * 2 ;   // two(2) hair spaces for each char
         gsHtml.insert( "</span>", endi ) ;  // end the 'cjk' span
         while ( hairs > ZERO )              // grow some hair
         { gsHtml.insert( L"&hairsp;", endi ) ; --hairs ; }
         gsHtml.insert( beginSpan, begi ) ;  // begin the 'cjk' span
         #endif   // TWO_PER
      }
   }
   #endif   // ENABLE_DEVELOPMENT_METHODS

}  //* End ccapMicrospace() *

//*************************
//*       ccapDocs        *
//*************************
//******************************************************************************
//* Capture the dialog in both plain text and in 'Simple' HTML format for use  *
//* in the Texinfo documentation.                                              *
//* Data are captured to "capturedlg.txt" and "capturedlg.htm", respectively.  *
//*                                                                            *
//* Input  : bkgnd   : dialog background color                                 *
//*                                                                            *
//* Returns: character offset for first display column of control object       *
//******************************************************************************

short NcDialog::ccapDocs ( const attr_t bkgnd )
{
   short status = ERR ;             // return value

   #if ENABLE_DEVELOPMENT_METHODS != 0
   status = this->CaptureDialog ( "capturedlg.txt" ) ;
   short stmp = this->CaptureDialog ( "capturedlg.htm", true, false, 
                                      "infodoc-styles.css", 4, false, bkgnd ) ;
   if ( stmp != OK )
      status = ERR ;
   #endif   // ENABLE_DEVELOPMENT_METHODS

   return status ;

}  //* End ccapDocs() *

//*************************
//*      ccapXOffset      *
//*************************
//******************************************************************************
//* STATIC, NON-MEMBER METHOD. Called only by 'CaptureDialog'.                 *
//*                                                                            *
//* Input  : src     : display data for one line (or only line) of the control *
//*          colOff  : required _column_ offset                                *
//*                                                                            *
//* Returns: character offset for first display column of control object       *
//******************************************************************************

#if ENABLE_DEVELOPMENT_METHODS != 0
static short ccapXOffset ( gString& src, short colOff )
{
   short cc = ZERO,           // accumulator
         cIndex = ZERO ;      // character offset (return value)

   //* Get number of columns for each character *
   int   colCount ;
   const short* colPtr = src.gscols( colCount ) ;

   //* Find character offset *
   for ( short i = ZERO ; i < src.gschars() ; i++ )
   {
      if ( (cc += colPtr[i]) > colOff )
         break ;
      ++cIndex ;
   }
   return cIndex ;

}  //* End ccapXOffset() *
#endif   // ENABLE_DEVELOPMENT_METHODS

//*************************
//*       ccapShift       *
//*************************
//********************************************************************************
//* STATIC, NON-MEMBER METHOD. Called only by 'CaptureDialog' group.             *
//* 1) Shift the text data.                                                      *
//* 2) Pad the vacated character positions with nullchars.                       *
//* 3) Shift the attribute data.                                                 *
//* 4) Padding the vacated attribute positions is unnecessary because they are   *
//*    not referenced by the algorithm.                                          *
//*                                                                              *
//* Input  : txtsrc   : display data which _follows_ recent line-data change     *
//*          atrsrc   : color attributes corresponding to display data           * 
//*          shiftBase: index text/attributes to be shifted                      *
//*          shiftCnt : number of text columns to shift                          *
//*                     (usually a negative value indicating left-shift)         *
//*                                                                              *
//* Returns: nothing                                                             *
//********************************************************************************

#if ENABLE_DEVELOPMENT_METHODS != 0
static void ccapShift ( wchar_t* txtsrc, attr_t* atrsrc, short shiftBase, short shiftCnt )
{
   #define DEBUG_ATTRSHIFT (0)            // for debugging only

   gString gs( &txtsrc[shiftBase] ) ;     // load the text data
   short oldChars = gs.gschars(),         // original text char count
         newChars,                        // number of characters in modified segment
         padCnt,                          // number of pad chars added to tail
         ati = shiftBase,                 // attribute target index
         asi,                             // attribute source index
         atrCnt ;                         // number of attributes to be shifted


   gs.shiftCols( shiftCnt ) ;             // shift the text data
   gs.copy( &txtsrc[shiftBase],           // save the shifted data
            gs.gschars() ) ;
   newChars = gs.gschars() ;              // modified text char count
   padCnt   = oldChars - newChars ;       // difference in string lengths
   asi      = ati + padCnt ;              // attribute source index
   atrCnt   = newChars - 2 ;              // attribute-shift count

   if ( shiftCnt < ZERO )     // (be safe)
   {
      //* Pad the shifted text data with null chars *
      //* to the width of the target dialog.        *
      short loopCnt = padCnt,
            ci = shiftBase + gs.gschars() ;
 
      #if DEBUG_CAPTURE != 0 && DEBUG_ATTRSHIFT != 0
      short tmpasi = asi, tmpati = ati, ai ;
      if ( ofsdc.is_open() )
      {
       gsdbg.compose( "     ATTR :shiftBase:%02hd  oldChars:%02hd newChars:%02hd padCnt:%02hd ati:%02hd asi:%02hd", 
                      &shiftBase, &oldChars, &newChars, &padCnt, &ati, &asi ) ;
       if ( ofsdc.is_open() ) { ofsdc << gsdbg.ustr() << endl ; }
       ai = tmpati ;
       gsdbg.compose( "     ATTRa: %02hd:", &ai ) ;
       for ( short i = ZERO ; i < (loopCnt*2) ; ++i )
          gsdbg.append( " %06X", &atrsrc[ai++] ) ;
       ofsdc << gsdbg.ustr() << endl ;
      }
      #endif   // DEBUG_CAPTURE && DEBUG_ATTRSHIFT

      while ( loopCnt-- > ZERO )
         txtsrc[ci++] = NULLCHAR ;

      //* Shift the associated attribute data for the remainder of line. *
      loopCnt = atrCnt ;
      while ( loopCnt-- > ZERO )
         atrsrc[ati++] = atrsrc[asi++] ;

      #if DEBUG_CAPTURE != 0 && DEBUG_ATTRSHIFT != 0
      if ( ofsdc.is_open() )
      {
       ati = tmpati ; asi = tmpasi ;
       ai = tmpati ;
       loopCnt = padCnt ;
       gsdbg.compose( "     ATTRb: %02hd:", &ai ) ;
       for ( short i = ZERO ; i < padCnt ; ++i )
        gsdbg.append( " %06X", &atrsrc[ai++] ) ;
       ofsdc << gsdbg.ustr() << endl ;
      }
      #endif   // DEBUG_CAPTURE && DEBUG_ATTRSHIFT
   }
   #if DEBUG_CAPTURE != 0 && DEBUG_ATTRSHIFT != 0
   else
   { if ( ofsdc.is_open() ) { ofsdc << "   Shift Count >= 0" << endl ; } }
   #endif   // DEBUG_CAPTURE && DEBUG_ATTRSHIFT

}  //* End ccapShift() *
#endif   // ENABLE_DEVELOPMENT_METHODS

//*************************
//*      ccapSimple       *
//*************************
//********************************************************************************
//* Called only by 'CaptureDialog'.                                              *
//* Capture display data for simple dialog controls.                             *
//*                                                                              *
//* Simple controls are stateless (fixed size and position), and consist of a    *
//* single underlying window object.                                             *
//*   a) dctPUSHBUTTON controls                                                  *
//*   b) dctTEXTBOX controls                                                     *
//*   c) dctRADIOBUTTON controls                                                 *
//*   d) dctBILLBOARD controls                                                   *
//*   e) dctSPINNER controls                                                     *
//* Note that to avoid code duplication, we maintain the polite fiction that     *
//* the control pointer passed by the caller points to a DialogPushbutton, but   *
//* because all controls are derived from the same parent class, they share      *
//* the data members necessary for the text/attribute data capture.              *
//*                                                                              *
//* Input  : cpt     : pointer to control object                                 *
//*                    NOTE: may, or may not actually be a pointer to a          *
//*                          dctPUSHBUTTON object, but the data are the same     *
//*          txtData : pointer to two-dimentional text-data array                *
//*          atrData : pointer to two-dimentional attribute-data array           *
//*          charsinX: X dimension of 'txtData' and 'atrData'                    *
//*                                                                              *
//* Returns: nothing                                                             *
//********************************************************************************

void NcDialog::ccapSimple ( DialogPushbutton* cpt, 
                            wchar_t* txtData, attr_t* atrData, short charsinX )
{
   #if ENABLE_DEVELOPMENT_METHODS != 0
   #define DEBUG_SIMPLE (0)         // for debugging only

   gString gsfmt ;                  // for analysis of text data
         //* Index the row and column of parent data containing control data.*
   short rIndex = charsinX * (cpt->wPtr->wulY - this->dulY),
         colOffset = (cpt->wPtr->wulX - this->dulX) ;

   short cIndex,                    // character index of target column
         sIndex = ZERO,             // index a row of control data
         charCount,                 // 
         charOffset,                // 
         charCountOld, colCountOld, colCountNew, j ;

   SaveWin swt( cpt->wPtr->wLines, cpt->wPtr->wCols ) ;
   cpt->wPtr->CaptureWindow ( swt ) ;

   #if DEBUG_CAPTURE != 0 && DEBUG_SIMPLE != 0
   if ( ofsdc.is_open() )
   {
      gsdbg.compose( "%S: %02hd x %02hd\n", ctrlName[cpt->type], &swt.wRows, &swt.wCols ) ;
      ofsdc << gsdbg.ustr() ;
   }
   #endif   // DEBUG_CAPTURE && DEBUG_SIMPLE

   for ( short i = ZERO ; i < swt.wRows ; i++ )
   {  //* Get character offset of target column *
      gsfmt = &txtData[rIndex + (i * charsinX)] ;
      cIndex = ccapXOffset ( gsfmt, colOffset ) ;

      //* Get existing substring *
      gsfmt.shiftChars( -cIndex ) ;
      colCountOld = gsfmt.gscols() ;         // save old column count
      gsfmt.limitCols( swt.wCols ) ;
      charCountOld = gsfmt.gschars() - 1 ;   // save old character count

      //* Get a row of source data *
      gsfmt = &swt.wText[sIndex] ;
      gsfmt.limitCols( swt.wCols ) ;
      charCount = gsfmt.gschars() - 1 ;

      if ( charCount > charCountOld )
      {  // Unnecessary for this control type (but harmless) *
         gString gs( &txtData[rIndex + (i * charsinX) + charCountOld] ) ;
         gs.shiftChars( charCount - charCountOld ) ;
         gs.copy( &txtData[rIndex + (i * charsinX) + charCountOld], gs.gschars() ) ;
      }

      //* Insert the captured data into the parent dialog's data *
      j = ZERO ;
      for ( short cit = ZERO ; cit < charCount ; cit++, j++ )
      {
         charOffset = (rIndex + (i * charsinX)) + (cIndex + j) ;
         txtData[charOffset] = gsfmt.gstr()[cit] ;
         atrData[charOffset] = swt.wAttr[sIndex + cit] ;
      }
      sIndex += charCount ;
      gsfmt = &txtData[rIndex + (i * charsinX) + cIndex] ;
      colCountNew = gsfmt.gscols() ;

      //* If modified text is wider than original text *
      if ( colCountNew > colCountOld )
      {
         #if DEBUG_CAPTURE != 0 && DEBUG_SIMPLE != 0
         if ( ofsdc.is_open() )
         { gsdbg.compose( "    '%S'\n", &txtData[rIndex + (i * charsinX) + cIndex] ) ;
           ofsdc << gsdbg.ustr() ; }
         #endif   // DEBUG_CAPTURE && DEBUG_SIMPLE

         ccapShift ( &txtData[rIndex + (i * charsinX) + (cIndex + j)],
                     &atrData[rIndex + (i * charsinX) + (cIndex + j)],
                     ZERO, (colCountOld - colCountNew) ) ;

         #if DEBUG_CAPTURE != 0 && DEBUG_SIMPLE != 0
         if ( ofsdc.is_open() )
         { gsdbg.compose( "    '%S'\n", &txtData[rIndex + (i * charsinX) + cIndex] ) ;
           ofsdc << gsdbg.ustr() ; }
         #endif   // DEBUG_CAPTURE && DEBUG_SIMPLE
      }
   }
   #if DEBUG_CAPTURE != 0 && DEBUG_SIMPLE != 0
   if ( ofsdc.is_open() )
   { ofsdc.flush() ; }
   #endif   // DEBUG_CAPTURE && DEBUG_SIMPLE

   #undef DEBUG_SIMPLE
   #endif   // ENABLE_DEVELOPMENT_METHODS
}  //* End ccapSimple() *

//*************************
//*      ccapMulti        *
//*************************
//********************************************************************************
//* Called only by 'CaptureDialog'.                                              *
//* Capture display data for multi-window dialog controls.                       *
//*                                                                              *
//* Input  : cpt     : pointer to control object                                 *
//*                    NOTE: may, or may not actually be a pointer to a          *
//*                          dctSCROLLBOX object, but the data are the same      *
//*          txtData : pointer to two-dimentional text-data array                *
//*          atrData : pointer to two-dimentional attribute-data array           *
//*          charsinX: X dimension of 'txtData' and 'atrData'                    *
//*                                                                              *
//* Returns: nothing                                                             *
//********************************************************************************

void NcDialog::ccapMulti ( DialogScrollbox* cpt, 
                           wchar_t* txtData, attr_t* atrData, short charsinX )
{
   #if ENABLE_DEVELOPMENT_METHODS != 0
   gString gsfmt ;
   short rIndex = charsinX * (cpt->bPtr->wulY - this->dulY),
         cIndex,
         sIndex = ZERO,
         charCount,
         charOffset,
         colOffset = (cpt->bPtr->wulX - this->dulX),
         charCountOld, colCountOld, colCountNew, colDiff, j ;

   //* Capture and integrate the control's border.*
   SaveWin swb( cpt->bPtr->wLines, cpt->bPtr->wCols ) ;
   cpt->bPtr->CaptureWindow ( swb ) ;

   #if DEBUG_CAPTURE != 0
   if ( ofsdc.is_open() )
   { gsdbg.compose( "%S: %02hd x %02hd (ccapMulti)", ctrlName[cpt->type], 
                    &swb.wRows, &swb.wCols ) ; ofsdc << gsdbg.ustr() << endl ; }
   #endif   // DEBUG_CAPTURE

   for ( short i = ZERO ; i < swb.wRows ; i++ )
   {  //* Get character offset of target column *
      gsfmt = &txtData[rIndex + (i * charsinX)] ;
      cIndex = ccapXOffset ( gsfmt, colOffset ) ;

      //* Get existing substring *
      gsfmt.shiftChars( -cIndex ) ;
      colCountOld = gsfmt.gscols() ;         // save old column count
      gsfmt.limitCols( swb.wCols ) ;
      charCountOld = gsfmt.gschars() - 1 ;   // save old character count

      gsfmt = &swb.wText[sIndex] ;
      gsfmt.limitCols( swb.wCols ) ;
      charCount = gsfmt.gschars() - 1 ;

      //* If new data have more characters than existing  *
      //* data, then shift the existing data to the right.*
      if ( charCount > charCountOld )
      {
         charOffset = rIndex + (i * charsinX) + cIndex ;
         gString gs( &txtData[charOffset] ) ;
         gs.shiftChars( charCount - charCountOld ) ;
         gs.copy( &txtData[charOffset], gs.gschars() ) ;
      }

      j = ZERO ;
      for ( short cit = ZERO ; cit < charCount ; cit++, j++ )
      {
         charOffset = (rIndex + (i * charsinX)) + (cIndex + j) ;
         txtData[charOffset] = gsfmt.gstr()[cit] ;
         atrData[charOffset] = swb.wAttr[sIndex + cit] ;
      }
      sIndex += charCount ;
      gsfmt = &txtData[charOffset + 1] ;
      colCountNew = gsfmt.gscols() ;
      if ( colCountNew > colCountOld )
      {  // Programmer's Note: This will probably never be executed.
         #if DEBUG_CAPTURE != 0
         if ( ofsdc.is_open() )
         { gsdbg.compose( "    '%S'\n", &txtData[charOffset + 1] ) ;
           ofsdc << gsdbg.ustr() ; }
         #endif   // DEBUG_CAPTURE

         colDiff = colCountOld - colCountNew ;
         ccapShift ( &txtData[charOffset + 1],
                     &atrData[charOffset + 1], ZERO, colDiff ) ;

         #if DEBUG_CAPTURE != 0
         if ( ofsdc.is_open() )
         { gsdbg.compose( "    '%S'\n", &txtData[charOffset + 1] ) ;
           ofsdc << gsdbg.ustr() ; }
         #endif   // DEBUG_CAPTURE
      }
   }

   //* Capture and integrate the control's interior.*
   SaveWin swt( cpt->wPtr->wLines, cpt->wPtr->wCols ) ;
   cpt->wPtr->CaptureWindow ( swt ) ;

   rIndex = charsinX * (cpt->wPtr->wulY - this->dulY),
   colOffset = (cpt->wPtr->wulX - this->dulX) ;
   sIndex = ZERO ;

   for ( short i = ZERO ; i < swt.wRows ; i++ )
   {  //* Get character offset of target column *
      gsfmt = &txtData[rIndex + (i * charsinX)] ;
      cIndex = ccapXOffset ( gsfmt, colOffset ) ;

      //* Get existing substring *
      gsfmt.shiftChars( -cIndex ) ;
      colCountOld = gsfmt.gscols() ;         // save old column count
      gsfmt.limitCols( swt.wCols ) ;
      charCountOld = gsfmt.gschars() - 1 ;   // save old character count

      gsfmt = &swt.wText[sIndex] ;
      gsfmt.limitCols( swt.wCols ) ;
      charCount = gsfmt.gschars() - 1 ;

      //* If new data have more characters than existing data.    *
      //* then shift the existing data to the right.              *
      //* Note: FEWER characters does not necessarily mean fewer  *
      //* columns, so we check for change in column count below.  *
      if ( charCount > charCountOld )
      {  // (This should never be executed since the target is an empty)
         // (box i.e. an array of spaces, one column per character.    )
         charOffset = rIndex + (i * charsinX) + cIndex ;
         gString gs( &txtData[charOffset] ) ;
         gs.shiftChars( charCount - charCountOld ) ;  // shift rightward
         gs.copy( &txtData[charOffset], gs.gschars() ) ;
      }

      //* Replace the old substring with the new substring. *
      j = ZERO ;
      for ( short cit = ZERO ; cit < charCount ; cit++, j++ )
      {
         charOffset = (rIndex + (i * charsinX)) + (cIndex + j) ;
         txtData[charOffset] = gsfmt.gstr()[cit] ;
         atrData[charOffset] = swt.wAttr[sIndex + cit] ;
      }
      sIndex += charCount ;
      gsfmt = &txtData[rIndex + (i * charsinX) + cIndex] ;
      colCountNew = gsfmt.gscols() ;

      //* If new data have more columns than existing     *
      //* data, then shift the trailing data to the left. *
      //* (The chance of having fewer columns is remote.) *
      if ( colCountNew > colCountOld ) // shift leftward
      {
         charOffset = rIndex + (i * charsinX) + (cIndex + j) ;

         #if DEBUG_CAPTURE != 0
         if ( ofsdc.is_open() )
         { gsdbg.compose( "    '%S'\n", &txtData[charOffset - j] ) ;
           ofsdc << gsdbg.ustr() ; }
         #endif   // DEBUG_CAPTURE

         ccapShift ( txtData, atrData, charOffset, (colCountOld - colCountNew) ) ;

         #if DEBUG_CAPTURE != 0
         if ( ofsdc.is_open() )
         { gsdbg.compose( "    '%S'\n", &txtData[charOffset - j] ) ;
           ofsdc << gsdbg.ustr() ; }
         #endif   // DEBUG_CAPTURE
      }
   }
   #endif   // ENABLE_DEVELOPMENT_METHODS
}  //* End ccapMulti()

//*************************
//*       ccapMTit        *
//*************************
//********************************************************************************
//* Called only by 'CaptureDialog'. Capture display data for title portion of    *
//* a dctMENUWIN control.                                                        *
//*                                                                              *
//* Input  : cpt     : pointer to control object                                 *
//*                    NOTE: may, or may not actually be a pointer to a          *
//*                          dctPUSHBUTTON object, but the data are the same     *
//*          txtData : pointer to target text-data array                         *
//*          atrData : pointer to target attribute-data array                    *
//*                                                                              *
//* Returns: nothing                                                             *
//********************************************************************************

void NcDialog::ccapMTit ( DialogMenuwin* cpt, wchar_t* txtData, attr_t* atrData )
{
   #if ENABLE_DEVELOPMENT_METHODS != 0
   //* Capture the control's display data *
   SaveWin swt( cpt->tLines, cpt->tCols ) ;
   cpt->tPtr->CaptureWindow ( swt ) ;

   //* Get character offset of target column *
   gString gsfmt( txtData ) ;
   short cIndex = ccapXOffset ( gsfmt, short(cpt->tPtr->wulX - this->dulX) ) ;

   #if DEBUG_CAPTURE != 0
   short baseIndex = cIndex ;
   if ( ofsdc.is_open() )
   { gsdbg.compose( "%S: '%S'\n", ctrlName[cpt->type], &txtData[baseIndex] ) ;
     ofsdc << gsdbg.ustr() ; }
   #endif   // DEBUG_CAPTURE

   //* Get a copy of display text for the control *
   gsfmt = swt.wText ;
   short charCount = gsfmt.gschars() - 1,
         colCount  = gsfmt.gscols() ;

   //* Overlay the control's display data onto parent dialog's data *
   for ( short cit = ZERO ; cit < charCount ; cit++, cIndex++ )
   {
      txtData[cIndex] = gsfmt.gstr()[cit] ;  // text data
      atrData[cIndex] = swt.wAttr[cit] ;     // color attributes
   }

   //* If 'colCount' > 'charCount', then trailing parent *
   //* characters must be shifted left by the difference.*
   if ( colCount > charCount )
   {
      ccapShift ( &txtData[cIndex], &atrData[cIndex], ZERO, (charCount - colCount) ) ;

      #if DEBUG_CAPTURE != 0
      if ( ofsdc.is_open() )
      { gsdbg.compose( "    '%S'\n", &txtData[baseIndex] ) ; ofsdc << gsdbg.ustr() ; }
      #endif   // DEBUG_CAPTURE
   }

   #endif   // ENABLE_DEVELOPMENT_METHODS
}  //* End ccapMTit() *

//*************************
//*       ShowWin         *
//*************************
//******************************************************************************
//* Restore a dialog that was previously hidden or obscured.                   *
//* Discard the saved screen data.                                             *
//* This method is only called from inside RefreshWin() so we DO NOT refresh   *
//* the window here.                                                           *
//*                                                                            *
//* Input  : none                                                              *
//*                                                                            *
//* Returns: OK if successful, ERR if dialog display data not previously saved *
//******************************************************************************
//* Programmer's Note: The output loop is convoluted and somewhat inefficient, *
//* but it handles multi-column characters correctly. The alternative would be *
//* to use ncurses primitives, which we don't want to do in the NcDialog class.*
//******************************************************************************

short NcDialog::ShowWin ( void )
{
   short result = ERR ;
   if ( this->winObscured != false )
   {
      //* Grab the tail of linked list. Contains saved text/color data. *
      dSaveWin* dsPtr = this->dswData ;
      while ( dsPtr->nextNode != NULL )
         dsPtr = dsPtr->nextNode ;

      const wchar_t* wPtr ;         // pointer to output buffer
      const short*   colPtr ;       // pointer to array of column-counts
      int   gsIndex,                // output buffer index
            sdIndex = ZERO,         // source-data index
            charcount ;             // loop limit
      short y = ZERO, x ;           // y/x coordinates

      do
      {
         gsIndex = x = ZERO ;                                                 
         gString gs( &dsPtr->swPtr->wText[sdIndex], dsPtr->swPtr->wCols + 20 ) ;
         gs.limitCols( dsPtr->swPtr->wCols ) ;
         wPtr = gs.gstr() ;
         colPtr = gs.gscols( charcount ) ;
         --charcount ;        // subtract NULLCHAR
         do
         {
            this->WriteChar ( y, x, wPtr[gsIndex], dsPtr->swPtr->wAttr[sdIndex++] ) ;
            x += colPtr[gsIndex] ;
         }
         while ( ++gsIndex < charcount ) ;                         
         ++y ;
      }
      while ( y < dsPtr->swPtr->wRows ) ;

      //* Release the stored source data *
      if ( dsPtr->prevNode != NULL )
         (*dsPtr->prevNode).nextNode = NULL ;
      delete dsPtr ;
      //* If all copies of data released, so indicate *
      if ( dsPtr == this->dswData )
      {
         this->dswData = NULL ;
         this->winObscured = false ;
      }
      result = OK ;
   }
   return result ;

}  //* End ShowWin() *

//*************************
//*   SetDialogObscured   *
//*************************
//******************************************************************************
//* Capture the dialog window display data and set the winObscured flag.       *
//* Application should call this method in anticipation of the dialog being    *
//* wholly or partially obscured by another object.                            *
//* Note: you must call this method BEFORE the dialog is actually obscured.    *
//* Similar to HideWin() except that the dialog is not erased.                 *
//*                                                                            *
//* Input  : none                                                              *
//*                                                                            *
//* Returns: OK if successful                                                  *
//*          ERR if window data has already been saved                         *
//******************************************************************************

short NcDialog::SetDialogObscured ( void )
{
short    result = ERR ;

   //* Don't allow overwrite of existing data *
   if ( this->winObscured == false )
   {
      //* Capture the display data *
      this->CaptureDialogDisplayData () ;
      result = OK ;
   }

   return result ;

}  //* End SetDialogObscured() *

//*************************
//*        MoveWin        *
//*************************
//******************************************************************************
//* Move the dialog window from its current position in the terminal window    *
//* to the specified position (Y/X coordinates of upper left corner of         *
//* dialog window).                                                            *
//*                                                                            *
//*                                                                            *
//* Input  : ulYX    : Y/X offset of new position                              *
//*          relative: (optional, false by default)                            *
//*                    if 'true', coordinates are interpreted as an offset     *
//*                     from current dialog position.                          *
//*                    if 'false', coordinates are interpreded as an offset    *
//*                     from upper left of terminal window.                    *
//*                                                                            *
//* Returns: OK if successful,                                                 *
//*           On successful return, the ulYX parameter has been updated        *
//*           with the previous coordinates of the dialog window.              *
//*          ERR if:                                                           *
//*           1. window data has already been saved (see SetDialogObscured()). *
//*           2. if the new position would place all or part of the dialog     *
//*              outside the terminal window's display area                    *
//*           3. memory-allocation error                                       *
//******************************************************************************

short NcDialog::MoveWin ( winPos& ulYX, bool relative )
{
short    result = ERR ;

   //* If we don't have old (potentially outdated) saved data in our way *
   if ( this->winObscured == false )
   {
      //* Save current dialog position for caller *
      winPos oldPos(this->dulY, this->dulX) ;

      //* Convert relative coordinates to absolute *
      if ( relative != false )
      {
         ulYX.ypos += oldPos.ypos ;
         ulYX.xpos += oldPos.xpos ;
      }

      //* Test whether the move will put any part of *
      //* the dialog outside the screen display area *
      short sLines, sCols ;
      nc.ScreenDimensions ( sLines, sCols ) ;
      if (   ulYX.ypos >= ZERO && ulYX.xpos >= ZERO 
          && ((ulYX.xpos + this->dCols) <= sCols) 
          && ((ulYX.ypos + this->dLines) <= sLines)
         )
      {
         //* Save the dialog window's display data *
         if ( (result = HideWin ()) == OK )
         {
            //* Set new Y/X position for the dialog window *
            this->wp->_begy = this->dulY = ulYX.ypos ;
            this->wp->_begx = this->dulX = ulYX.xpos ;
   
            //* Reposition the control objects *
            short diffY = ulYX.ypos - oldPos.ypos, 
                  diffX = ulYX.xpos - oldPos.xpos ;
            for ( short i = ZERO ; i <= this->lastCtrl ; i++ )
            {
               //* Scroll Box requires an additional step because *
               //* it is actually composed of two NcWindow objects*
               if ( dCtrl[i]->type == dctSCROLLBOX )
               {
                  DialogScrollbox *cpt = (DialogScrollbox*)(dCtrl[i]) ;
                  cpt->bPtr->wp->_begy = cpt->bPtr->wulY = dCtrl[i]->ulY += diffY ;
                  cpt->bPtr->wp->_begx = cpt->bPtr->wulX = dCtrl[i]->ulX += diffX ;
                  dCtrl[i]->wPtr->wp->_begy = dCtrl[i]->wPtr->wulY = dCtrl[i]->ulY + 1 ;
                  dCtrl[i]->wPtr->wp->_begx = dCtrl[i]->wPtr->wulX = dCtrl[i]->ulX + 1 ;
               }
               //* Dropdown requires an additional step because it *
               //* is actually composed of three NcWindow objects  *
               else if ( dCtrl[i]->type == dctDROPDOWN )
               {
                  DialogDropdown *cpt = (DialogDropdown*)(dCtrl[i]) ;
                  cpt->tPtr->wp->_begy = cpt->tPtr->wulY = cpt->tulY += diffY ;
                  cpt->tPtr->wp->_begx = cpt->tPtr->wulX = cpt->tulX += diffX ;
                  cpt->tcYpos += diffY ;
                  cpt->tcXpos += diffX ;
                  cpt->bPtr->wp->_begy = cpt->bPtr->wulY = dCtrl[i]->ulY += diffY ;
                  cpt->bPtr->wp->_begx = cpt->bPtr->wulX = dCtrl[i]->ulX += diffX ;
                  dCtrl[i]->wPtr->wp->_begy = dCtrl[i]->wPtr->wulY = dCtrl[i]->ulY + 1 ;
                  dCtrl[i]->wPtr->wp->_begx = dCtrl[i]->wPtr->wulX = dCtrl[i]->ulX + 1 ;
               }
               //* Menu-win requires an additional step because      *
               //* it is actually composed of three NcWindow objects *
               else if ( dCtrl[i]->type == dctMENUWIN )
               {
                  DialogMenuwin *cpt = (DialogMenuwin*)(dCtrl[i]) ;
                  cpt->tPtr->wp->_begy = cpt->tPtr->wulY = cpt->tulY += diffY ;
                  cpt->tPtr->wp->_begx = cpt->tPtr->wulX = cpt->tulX += diffX ;
                  cpt->bPtr->wp->_begy = cpt->bPtr->wulY = dCtrl[i]->ulY += diffY ;
                  cpt->bPtr->wp->_begx = cpt->bPtr->wulX = dCtrl[i]->ulX += diffX ;
                  dCtrl[i]->wPtr->wp->_begy = dCtrl[i]->wPtr->wulY = dCtrl[i]->ulY + 1 ;
                  dCtrl[i]->wPtr->wp->_begx = dCtrl[i]->wPtr->wulX = dCtrl[i]->ulX + 1 ;
               }
               //* Scroll Ext requires an additional step because *
               //* it is actually composed of two NcWindow objects*
               else if ( dCtrl[i]->type == dctSCROLLEXT )
               {
                  DialogScrollext *cpt = (DialogScrollext*)(dCtrl[i]) ;
                  cpt->bPtr->wp->_begy = cpt->bPtr->wulY = dCtrl[i]->ulY += diffY ;
                  cpt->bPtr->wp->_begx = cpt->bPtr->wulX = dCtrl[i]->ulX += diffX ;
                  dCtrl[i]->wPtr->wp->_begy = dCtrl[i]->wPtr->wulY = dCtrl[i]->ulY + 1 ;
                  dCtrl[i]->wPtr->wp->_begx = dCtrl[i]->wPtr->wulX = dCtrl[i]->ulX + 1 ;
               }
               else
               {
                  // Update all layers of abstraction: ncurses WINDOW structure,
                  // NcWindow class, and NcDialogControl class.
                  dCtrl[i]->wPtr->wp->_begy = dCtrl[i]->wPtr->wulY = dCtrl[i]->ulY += diffY ;
                  dCtrl[i]->wPtr->wp->_begx = dCtrl[i]->wPtr->wulX = dCtrl[i]->ulX += diffX ;
               }
            }
            
            //* Display the dialog at the new position *
            this->RefreshWin () ;
            
            //* Return previous dialog position to caller *
            ulYX = oldPos ;
         }
      }
   }

   return result ;

}  //* End MoveWin() *

//*************************
//*   GetDialogPosition   *
//*************************
//******************************************************************************
//* Report the dialog window's current position as an offset from the upper    *
//* left corner of the terminal window.                                        *
//*                                                                            *
//* Input  : none                                                              *
//*                                                                            *
//* Returns: Y/X window position                                               *
//******************************************************************************

winPos NcDialog::GetDialogPosition ( void )
{

   winPos wp( this->dulY, this->dulX ) ;
   return wp ;

}  //* End GetDialogPosition() *

//***********************
//* GetDialogDimensions *
//***********************
//******************************************************************************
//* Report the dialog window's dimensions as the number of display lines and   *
//* display columns.                                                           *
//*                                                                            *
//* Input  : dLines (by reference): on return, number of display lines         *
//*          dCols  (by reference): on return, number of display columns       *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************

void NcDialog::GetDialogDimensions ( short& dLines, short& dCols )
{

   dLines = this->dLines ;
   dCols  = this->dCols ;

}  //* End GetDialogDimensions() *

//*************************
//*   EstablishCallback   *
//*************************
//******************************************************************************
//* Establish (or disable) a callback method that allows the mainline code     *
//* to dynamically update the controls within the dialog window.               *
//*                                                                            *
//* The external method handles situations that the dialog code cannot.        *
//* For example:                                                               *
//*  - secondary validation of text data in a text box                         *
//*  - manual update of non-active controls i.e. display-only controls that    *
//*    user can view, but cannot access                                        *
//*                                                                            *
//*                                                                            *
//* Input  : valid pointer to caller's method of the correct type              *
//*          OR NULL pointer to disable existing callback                      *
//*                                                                            *
//* Returns: OK                                                                *
//******************************************************************************
//* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -    *
//* Notes:                                                                     *
//* - Dialog must be instantiated AND opened before calling this method        *
//*   since the callback will be performed immediately after it is             *
//*   established.                                                             *
//* - The EstablishCallback() method calls the specified method once with      *
//*   the parameter firstTime==true, to perform any required initialization.   *
//*   (wkey parameter will be meaningless for first call)                      *
//*   Subsequently, the NcDialog class always calls with firstTime==false.     *
//* - See typedef CUPTR  for a definition of the callback method.              *
//* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -    *
//* Programmer's Note: If caller passes an invalid pointer, the application    *
//* will immediately crash.  Serves the bastard right...                       *
//******************************************************************************
                                                                            
short NcDialog::EstablishCallback ( CUPTR methodname )
{
   this->ExternalControlUpdate = methodname ;

   //* Initial call to callback method initializes variables and other     *
   //* first-call stuff as specified when 'firstTime' parameter == 'true'. *
   wkeyCode wkey ;
   if ( this->ExternalControlUpdate != NULL )
      this->ExternalControlUpdate ( currCtrl, wkey, true ) ;
   return OK ;
   
}  //* End EstablishCallback() *

//*************************
//*    SetDialogTitle     *
//*************************
//******************************************************************************
//* Create a centered title in line ZERO of the dialog window.                 *
//*                                                                            *
//* Input  : dTitle : title string, character columns <= dialog width-4        *
//*                     (truncated if necessary to fit available display area) *
//*                     title may be in UTF-8, wchar_t or gString format       *
//*          cAttr  : (optional, default == dialog's border color)             *
//*                     alternate color attribute for title text               *
//*                                                                            *
//* Returns: Y/X position for start of string                                  *
//******************************************************************************
//* Programmer's Note: Possible future enhancement: support for a hotkey in    *
//* the dialog title, so if multiple dialogs are simultaneously open, user     *
//* can move among them more easily.                                           *
//******************************************************************************

winPos NcDialog::SetDialogTitle ( gString& dTitle, attr_t cAttr )
{
   winPos   wPos(0,0) ;    // return value == title position

   //* If title is not an empty string *
   if ( dTitle.gschars() > 1 )
   {
      //* Save dialog title.                                                *
      //* String is truncated if necessary to fit into target buffer AND    *
      //* to fit within the display space available.                        *
      dTitle.limitChars( MAX_LABEL_CHARS ) ;
      dTitle.limitCols( this->dCols - 4 ) ;
      dTitle.copy( this->dTitle, MAX_LABEL_CHARS ) ;

      //* Redraw dialog border including new title, and if an alternate *
      //* color attribute was specified, overwrite title in new color.  *
      wPos.xpos = this->DrawBorder ( this->bColor, dTitle.ustr(), 
                                     this->bStyle, this->rtlLabels ) ;
      if ( cAttr != attrDFLT )
         this->WriteString ( wPos.ypos, wPos.xpos, dTitle.gstr(), 
                             cAttr, false, this->rtlLabels ) ;
   }
   return wPos ;

}  //* End SetDialogTitle() *

winPos NcDialog::SetDialogTitle ( const char* dTitle, attr_t cAttr )
{  //* Stub for UTF-8 input *

   gString gs(dTitle) ;             // copy title to gString object
   return ( this->SetDialogTitle ( gs, cAttr ) ) ;   // call primary method
   
}  //* End SetDialogTitle() *

winPos NcDialog::SetDialogTitle ( const wchar_t* dTitle, attr_t cAttr )
{  //* Stub for wchar_t input *

   gString gs(dTitle) ;             // copy title to gString object
   return ( this->SetDialogTitle ( gs, cAttr ) ) ;   // call primary method
   
}  //* End SetDialogTitle() *

//*************************
//*    DrawLabelsAsRTL    *
//*************************
//******************************************************************************
//* Specify that when the dialog is opened, all control labels and the dialog  *
//* title should be interpreted as RTL (right-to-left) language text.          *
//* - By default, all control labels and the dialog title (if specified) are   *
//*   interpreted as LTR (left-to-right) language text.                        *
//* - To draw labels and title as RTL language text, this method must be       *
//*   called AFTER dialog instantiation but BEFORE the call to OpenWindow().   *
//* - NOTE: Normally, it would make no sense to call with rtlFormat==false     *
//*   because this would have no effect on labels or title which have already  *
//*   been written into the dialog's display space. However, calling with      *
//*   rtlFormat==false would allow any SUBSEQUENT calls to SetDialogTitle()    *
//*   to be interpreted as LTR text.                                           *
//*                                                                            *
//* Input  : rtlFormat : (optional, 'true' by default) draw all labels and     *
//*                      title as RTL                                          *
//*                                                                            *
//* Returns: OK                                                                *
//******************************************************************************
//* - Typically, at this point, the dialog and its controls have been          *
//*   instantiated, BUT have not yet been drawn to the display. Note that if   *
//*   the dialog has already been made visible by the call to OpenWindow(),    *
//*   then setting this flag will have no effect on the label display or a     *
//*   previously-established dialog title.                                     *
//*                                                                            *
//* - dctPUSHBUTTON controls have no labels; however, the control's display    *
//*   data ACT as the label. Therefore, we set (but not reset)                 *
//*   'DialogControl.rtlContent' for pushbutton controls before they are drawn.*
//*                                                                            *
//* - dctMENUWIN controls may, or may not have labels; but if they do, the     *
//*   label IS embedded as the menu title. This is handled elsewhere.          *
//*                                                                            *
//* - For dctSCROLLBOX, dctSCROLLEXT controls:                                 *
//*   Controls of these types may, or may not have labels; but if they do,     *
//*   the label MAY BE either external to the control or embedded within it.   *
//*   a) If external, then the label is controlled by our 'rtlLabels' flag.    *
//*   b) If embedded as the control's title (labY == labX == ZERO), then it is *
//*      handled elsewhere.                                                    *
//*                                                                            *
//******************************************************************************

short NcDialog::DrawLabelsAsRTL ( bool rtlFormat )
{
   //* Set the flag so OpenWindow() and SetDialogTitle() methods will see it.*
   this->rtlLabels = rtlFormat ;

   //* Scan for dctPUSHBUTTON controls (see note above). *
   for ( short i = ZERO ; i <= this->lastCtrl ; i++ )
   {
      if ( this->dCtrl[i]->type == dctPUSHBUTTON && rtlFormat != false )
         this->DrawContentsAsRTL ( i ) ;
   }
   return OK ;

}  //* End DrawLabelsAsRTL() *

//*************************
//*   DrawContentsAsRTL   *
//*************************
//******************************************************************************
//* Enable (or disable) drawing/redrawing the contents of the control object   *
//* as RTL-language text. Does not refresh display.                            *
//* - By default, contents of all controls are interpreted as                  *
//*   LTR (left-to-right) language text.                                       *
//* - For RTL languages, it is strongly recommended, though not enforced, that *
//*   this method be called BEFORE the first time dialog display is refreshed  *
//*   (see error conditions below).                                            *
//* - Normally, there will be no need to call this method a second time for a  *
//*   particular control; however, for some control types, it may be           *
//*   theoretically useful to toggle between RTL and LTR data. Toggling        *
//*   between RTL and LTR formatting is supported for controls whose contents  *
//*   can be dynamically updated:                                              *
//*    dctPUSHBUTTON, dctTEXTBOX, dctBILLBOARD, dctSCROLLEXT and dctMENUWIN.   *
//* - Please refer to the Dialog4 test application, Test06 for examples.       *
//*                                                                            *
//* Input  : cIndex   : index of control for which to enable/disable RTL       *
//*                     content formatting                                     *
//*          rtlFormat: (optional, true by default)                            *
//*                     if true, output control contents as RTL text           *
//*                     if false, output control contents as LTR text          *
//*                                                                            *
//* Returns: OK if successful                                                  *
//*          ERR if invalid index OR if specified format cannot be applied     *
//*              to target control.                                            *
//*              a) Not applicable for dctSPINNER and dctRADIOBUTTON controls  *
//*                 (spinners contain only ASCII numeric text)                 *
//*                 (radio buttons contain only single-character symbols)      *
//*              b) For controls with static contents format may only be set   *
//*                 before display is drawn for the first time.                *
//*              c) For dctTEXTBOX controls: formatting may not be changed if  *
//*                 control currently has the input focus.                     *
//*              d) For dctMENUWIN controls: formatting may not be changed if  *
//*                 control is currently in the 'expanded' state.              *
//******************************************************************************
//* Programmer's Note:                                                         *
//* a) The error conditions will be handled by the individual control's code   *
//*    EXCEPT that we must test for dctTEXTBOX focus here because controls     *
//*    don't know whether they have focus.                                     *
//* b) There is however a logical problem here. If a Textbox has focus BUT     *
//*    the window has not yet been opened, then we must allow setting/resetting*
//*    of RTL formatting for the control.                                      *
//* c) Unfortunately, there is no flag to indicate whether the window is       *
//*    actually open.                                                          *
//* d) Therefore we compromise: If target control is a Textbox AND if          *
//*    'rtlFormat' != false, THEN we _ASSUME_ that the window is not yet open  *
//*    and allow RTL to be set. This works because it is highly unlikely that  *
//*    the control will be actively under edit when this method is called.     *
//* e) If the command is to _reset_ RTL for a Textbox, then we insist that     *
//*    the target control NOT have focus.                                      *
//******************************************************************************

short NcDialog::DrawContentsAsRTL ( short cIndex, bool rtlFormat )
{
   short status = ERR ;
#if 1    // NEW
   if ( (cIndex >= ZERO) && (cIndex <= this->lastCtrl) &&
        ((dCtrl[cIndex]->type != dctTEXTBOX) ||
         ((dCtrl[cIndex]->type == dctTEXTBOX) && 
            ((cIndex != this->currCtrl) || (rtlFormat == true))))
      )
#else    // OLD
   if ( cIndex >= ZERO && cIndex <= this->lastCtrl &&
        !(dCtrl[cIndex]->type == dctTEXTBOX && cIndex == this->currCtrl) )
#endif   // OLD
   {
      status = dCtrl[cIndex]->SetOutputFormat ( rtlFormat ) ;
   }
   return status ;

}  //* End DrawLabelsAsRTL() *

//*************************
//*     AutoPositionX     *
//*************************
//******************************************************************************
//* Calculate the best horizontal position fit for controls that must live     *
//* inside the dialog borders. Called by the NcDialog constructor.             *
//*                                                                            *
//* A valid position is not guaranteed; however, the magical positioning       *
//* should alert the application developer that he/she/it screwed up.          *
//* Note that we do the outer test for speed and the inner test for effect.    *
//*                                                                            *
//* Input  : p : pointer to control initialization parameters                  *
//*                                                                            *
//* Returns: OK  if position unchanged                                         *
//*          ERR if position modified                                          *
//******************************************************************************

short NcDialog::AutoPositionX ( InitCtrl* p )
{
   short status = OK ;
   #if AUTOPOS == 1     // Position within parent dialog
   if ( (p->ulX < this->dulX) ||
        ((p->ulX + p->cols) > (this->dulX + this->dCols)) )
   {
      if ( p->ulX < this->dulX )
         p->ulX = this->dulX ;
      while ( (p->ulX > (this->dulX)) && 
              ((p->ulX + p->cols) > (this->dulX + this->dCols)) )
         --p->ulX ;

      status = ERR ;
   }
   #elif AUTOPOS == 2   // Position within dialog borders
   if ( (p->ulX <= this->dulX) ||
        ((p->ulX + p->cols) >= (this->dulX + this->dCols)) )
   {
      if ( p->ulX <= this->dulX )
         p->ulX = this->dulX + 1 ;
      while ( (p->ulX > (this->dulX+1)) && 
              ((p->ulX + p->cols) >= (this->dulX + this->dCols)) )
         --p->ulX ;

      status = ERR ;
   }
   #endif   // AUTOPOS
   return status ;

}  //* End AutoPositionX() *

//*************************
//*     AutoPositionY     *
//*************************
//******************************************************************************
//* Calculate the best vertical position fit for controls that must live       *
//* inside the dialog borders. Called by the NcDialog constructor.             *
//*                                                                            *
//* A valid position is not guaranteed; however, the magical positioning       *
//* should alert the application developer that he/she/it screwed up.          *
//* Note that we do the outer test for speed and the inner test for effect.    *
//*                                                                            *
//* Input  : p : pointer to control initialization parameters                  *
//*                                                                            *
//* Returns: OK  if position unchanged                                         *
//*          ERR if position modified                                          *
//******************************************************************************

short NcDialog::AutoPositionY ( InitCtrl* p )
{
   short status = OK ;

   #if AUTOPOS == 1     // Position within parent dialog
   if ( (p->ulY < this->dulY) ||
        ((p->ulY + p->lines) > (this->dulY + this->dLines)) )
   {
      if ( p->ulY < this->dulY )
         p->ulY = this->dulY ;
      while ( (p->ulY > (this->dulY)) && 
              ((p->ulY + p->lines) > (this->dulY + this->dLines)) )
         --p->ulY ;

      status = ERR ;
   }
   #elif AUTOPOS == 2   // Position within dialog borders
   if ( (p->ulY <= this->dulY) ||
        ((p->ulY + p->lines) >= (this->dulY + this->dLines)) )
   {
      if ( p->ulY <= this->dulY )
         p->ulY = this->dulY + 1 ;
      while ( (p->ulY > (this->dulY+1)) && 
              ((p->ulY + p->lines) >= (this->dulY + this->dLines)) )
         --p->ulY ;

      status = ERR ;
   }
   #endif   // AUTOPOS
   return status ;

}  //* End AutoPositionY() *

//*************************
//*      genDialog        *
//*************************
//******************************************************************************
//* Full-initialization constructor for genDialog class.                       *
//*                                                                            *
//* Input  : see below                                                         *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************
//*                                                                            *
//*                                                                            *
//******************************************************************************
genDialog::genDialog ( const char** ml, attr_t c, short dl, short dc, 
                       short yoff, short xoff, const attr_t* ma, 
                       bool r, attr_t pn, attr_t pf,
                       const char* yt, const char* nt )
{
   static const char* dfltList[] = { "unitialized", NULL } ; // default message strings

   this->msgList  = ml != NULL ? ml : dfltList ; // pointer to list of message strings
   this->dColor   = c ;                // base color attribute for dialog
   this->dLines   = dl ;               // dialog lines
   this->dCols    = dc ;               // dialog columns
   this->dUL      = { yoff, xoff } ;   // (optional) Y/X offset
   this->msgAttr  = ma ;               // (optional) pointer to attribute array
   this->rtl      = r ;                // (optional) direction of text flow
   this->pnColor  = pn != attrDFLT ? pn : nc.gyR ; // (optional)
   this->pfColor  = pf != attrDFLT ? pf : nc.reG ; // (optional)

   //* Initialize the display text for Pushbutton controls. *
   gString gs ;
   if ( yt != NULL )    // if custom text for 'YES' Pushbutton
   {
      gs = yt ;
      gs.copy( this->yesTxt, MAX_genDialog_TEXT ) ;
      gs.copy( this->okTxt, MAX_genDialog_TEXT ) ;
   }
   else                 // default text for 'YES' Pushbutton
   {
      gs = DFLT_genDialog_YES ;
      gs.copy( this->yesTxt, MAX_genDialog_TEXT ) ;
      gs = DFLT_genDialog_OK ;
      gs.copy( this->okTxt, MAX_genDialog_TEXT ) ;
   }
   if ( nt != NULL )
      gs = nt ;
   else
      gs = DFLT_genDialog_NO ;
   gs.copy( this->noTxt, MAX_genDialog_TEXT ) ;

}  //* End genDialog() *

//*************************
//*      InfoDialog       *
//*************************
//******************************************************************************
//* Generic information dialog. May be used to display any list of constant    *
//* strings, then waits for user to press Enter (or ESC).                      *
//*                                                                            *
//* For reasons of beauty, messages begin at offset 2 in X and SHOULD end at   *
//* dialog-width minus 2.                                                      *
//*                                                                            *
//* Input  : gd : initialized genDialog class object (by reference)            *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************

void NcDialog::InfoDialog ( genDialog& gd )
{

   this->GenericDialog ( gd, false ) ;

}  //* End DecisionDialog() *

//*************************
//*    DecisionDialog     *
//*************************
//******************************************************************************
//* Generic decision dialog. May be used to display any list of constant       *
//* strings, then waits for user to select either the 'YES' or 'NO' pushbutton *
//* (or ESC == 'NO').                                                          *
//*                                                                            *
//* For reasons of beauty, messages begin at offset 2 in X and SHOULD end at   *
//* dialog-width minus 2.                                                      *
//*                                                                            *
//* Note that the question posed by the dialog should be written in such a way *
//* that can be answered with either a 'Yes' or 'No' response.                 *
//*                                                                            *
//* Input  : gd : initialized genDialog class object (by reference)            *
//* Returns: 'true' if user selects 'YES', else 'false'                        *
//******************************************************************************

bool NcDialog::DecisionDialog ( genDialog& gd )
{

   return (this->GenericDialog ( gd, true )) ;

}  //* End DecisionDialog() *

//*************************
//*    GenericDialog      *
//*************************
//********************************************************************************
//* Private method. Implements the public methods, InfoDialog() and              *
//* DecisionDialog().                                                            *
//*                                                                              *
//* Input  : gd    : initialized genDialog class object (by reference)           *
//*          decide: if 'true', display decision buttons                         *
//*                  if 'false', display Ok button                               *
//*                                                                              *
//* Returns: 'true' if user selects 'YES', else 'false'                          *
//********************************************************************************
//* Programmer's Note:                                                           *
//* If caller specifies that the data are to be drawn as RTL text, then          *
//* logically, the correct thing would be to call DrawLabelsAsRTL() so that the  *
//* title would be drawn as RTL. Unfortunately, we cannot do that because it     *
//* would mean that our (English) Pushbutton text would also be written as RTL.  *
//* To overcome this, we have two choices:                                       *
//*   1) Draw the dialog without the title and THEN call DrawLabelsAsRTL() and   *
//*      SetDialogTitle().                                                       *
//*   2) Reverse the title text so that it APPEARS to have been written as RTL.  *
//* We have chosen the second option because array manipulation is fast and      *
//* screen updates are slow.                                                     *
//*                                                                              *
//* In a future version, we may add support for the following genDialog-class    *
//* parameters allowing the caller to specify the text displayed in the          *
//* Pushbuttons (currently ignored).                                             *
//*   - yes_text (includes 'YES' and 'OK' button initialization)                 *
//*   - no_text  (includes 'NO' button initialization)                           *
//* Width of the Pushbutton would be the width of the provided string.           *
//********************************************************************************

bool NcDialog::GenericDialog ( genDialog& gd, bool decide )
{
enum gdControls : short { okPush = ZERO, noPush } ;
short ulY,                    // upper left corner in Y
      ulX ;                   // upper left corner in X
bool  userDecision = false ;  // return value

   //* Save parent dialog's display data *
   this->CaptureDialogDisplayData () ;

   //* Validate in input parameters and position dialog *
   if ( gd.dLines > this->dLines )
      gd.dLines = this->dLines ;
   else if ( gd.dLines < MIN_genDialog_LINES )
      gd.dLines = MIN_genDialog_LINES ;
   if ( gd.dCols > this->dCols )
      gd.dCols = this->dCols ;
   else if ( gd.dCols < MIN_genDialog_COLS )
      gd.dCols = MIN_genDialog_COLS ;

   //* Default dialog position is centered in parent dialog *
   if ( gd.dUL.ypos < ZERO || gd.dUL.xpos < ZERO )
   {
      short ctrY = this->dulY + this->dLines / 2,
            ctrX = this->dulX + this->dCols / 2 ;
      ulY = ctrY - gd.dLines / 2 ;
      ulX = ctrX - gd.dCols / 2 ;
   }
   //* Non-centered position. Note: force a centered position if *
   //* dialog would extend beyond parent's border.               *
   if ( gd.dUL.ypos >= ZERO )
   {
      ulY = this->dulY + gd.dUL.ypos ;
      while ( (ulY + gd.dLines) > (this->dulY + this->dLines) && (ulY > this->dulY) )
         --ulY ;
   }
   if ( gd.dUL.xpos >= ZERO )
   {
      ulX = this->dulX + gd.dUL.xpos ;
      while ( (ulX + gd.dCols) > (this->dulX + this->dCols) && (ulX > this->dulX) )
         --ulX ;
   }
   //* If invalid color attributes *
   if ( gd.dColor == attrDFLT )  gd.dColor  = nc.bw ;
   if ( gd.pnColor == attrDFLT ) gd.pnColor = nc.gyR ;
   if ( gd.pfColor == attrDFLT ) gd.pfColor = nc.reG ;

   //* Pushbutton control text, and control width *
   const char *yPtr = decide ? gd.yesTxt : gd.okTxt ;    // Pointer to 'YES' button text
   short yWidth = ZERO,       // 'YES' button column count
         nWidth = ZERO,       // 'NO'  button column count
         yXoff  = ZERO,       // 'YES' button X offset
         nXoff  = ZERO ;      // 'NO'  button X offset
   gString gs( yPtr ) ;
   yWidth = (gs.gscols()) - (((gs.find( L'^' )) >= ZERO) ? 1 : 0) ;
   gs = gd.noTxt ;
   nWidth = (gs.gscols()) - (((gs.find( L'^' )) >= ZERO) ? 1 : 0) ;
   if ( decide != false )     // 2 Pushbuttons
   {
      short //freeX = gd.dCols - (yWidth + nWidth),  // free space on Pushbutton row
            center = gd.dCols / 2 ;
      // Programmer's Note: To position the two buttons comfortably within the 
      // dialog, there must be at least three(3) free columns (2 border columns 
      // and one column between buttons). If user defines a poor-quality layout, 
      // the buttons might overlap.
      yXoff = center - (yWidth + 2) ;
      nXoff = center + 2 ;
      if ( yXoff < 1 )
         yXoff = 1 ;
      while ( (nXoff + nWidth) >= gd.dCols )
         --nXoff ;
   }
   else                       // 1 Pushbutton
   {  // Programmer's Note: The pushbutton should fit within the dialog borders, 
      // and if the button is wider than the dialog, it will not instantiate.
      yXoff = (gd.dCols / 2 - yWidth / 2) ;
   }

   const short controlsDEFINED = 2 ;
   InitCtrl ic[controlsDEFINED] =      // control initialization structures
   {
      {  //* 'OK' / 'YES' pushbutton - - - - - - - - - - - - - - - -    okPush *
         dctPUSHBUTTON,                // type:      
         rbtTYPES,                     // rbSubtype: (n/a)
         false,                        // rbSelect:  (n/a)
         (short)(gd.dLines - 2),       // ulY:       upper left corner in Y
         yXoff,                        // ulX:        upper left corner in X
         1,                            // lines:     control lines
         yWidth,                       // cols:      control columns
         yPtr,                         // dispText:  
         gd.pnColor,                   // nColor:    non-focus color
         gd.pfColor,                   // fColor:    focus color
         tbPrint,                      // filter:    (n/a)
         "",                           // label:     (n/a)
         ZERO,                         // labY:      (n/a)
         ZERO,                         // labX       (n/a)
         ddBoxTYPES,                   // exType:    (n/a)
         1,                            // scrItems:  (n/a)
         1,                            // scrSel:    (n/a)
         NULL,                         // scrColor:  (n/a)
         NULL,                         // spinData:  (n/a)
         true,                         // active:    allow control to gain focus
         NULL,                         // nextCtrl:  link in next structure
      },
      {  //* 'NO' pushbutton   - - - - - - - - - - - - - - - - - - -    noPush *
         dctPUSHBUTTON,                // type:      
         rbtTYPES,                     // rbSubtype: (n/a)
         false,                        // rbSelect:  (n/a)
         (short)(gd.dLines - 2),       // ulY:       upper left corner in Y
         nXoff,                        // ulX: upper left corner in X
         1,                            // lines:     control lines
         nWidth,                       // cols:      control columns
         gd.noTxt,                     // dispText:  
         gd.pnColor,                   // nColor:    non-focus color
         gd.pfColor,                   // fColor:    focus color
         tbPrint,                      // filter:    (n/a)
         "",                           // label:     (n/a)
         ZERO,                         // labY:      (n/a)
         ZERO,                         // labX       (n/a)
         ddBoxTYPES,                   // exType:    (n/a)
         1,                            // scrItems:  (n/a)
         1,                            // scrSel:    (n/a)
         NULL,                         // scrColor:  (n/a)
         NULL,                         // spinData:  (n/a)
         true,                         // active:    allow control to gain focus
         NULL,                         // nextCtrl:  link in next structure
      },
   } ;

   //* Control data are initially configured for InfoDialog(), a single 'OK'   *
   //* pushbutton. If this is a DecisionDialog(), enable the second pushbutton.*
   if ( decide != false )
      ic[okPush].nextCtrl = &ic[noPush] ;

   //* Initial parameters for dialog window *
   InitNcDialog dInit( gd.dLines,      // number of display lines
                       gd.dCols,       // number of display columns
                       ulY,            // Y offset from upper-left of terminal 
                       ulX,            // X offset from upper-left of terminal
                       NULL,           // (dialog title set below)
                       ncltSINGLE,     // border line-style
                       gd.dColor,      // border color attribute
                       gd.dColor,      // interior color attribute
                       ic              // pointer to list of control definitions
                     ) ;

   //* Instantiate the dialog window *
   NcDialog* dp = new NcDialog ( dInit ) ;
   
   //* If display text is RTL, then draw title and label text as RTL also.*
   //* Note that caller should have set non-default label text.           *
   if ( gd.rtl != false )
      dp->DrawLabelsAsRTL () ;

   //* Open the dialog window *
   if ( (dp->OpenWindow ()) == OK )
   {
      short basex = gd.rtl ? (gd.dCols - 3) : 2 ;

      //* Set the dialog title (a blank line indicates no title) *
      attr_t txtColor = gd.msgAttr != NULL ? gd.msgAttr[0] : gd.dColor ;
      gString rTitle( gd.msgList[0] ) ; // analyze the first string in the array
      if ( rTitle.gschars() > 2 || *rTitle.gstr() != nckSPACE )
         dp->SetDialogTitle ( rTitle, txtColor ) ;

      //* Write the static text *
      for ( short i = 1 ; (i <= gd.dLines - 3) && gd.msgList[i] != NULL ; i++ )
      {
         txtColor = gd.msgAttr != NULL ? gd.msgAttr[i] : gd.dColor ;
         dp->WriteString ( i, basex, gd.msgList[i], txtColor, false, gd.rtl ) ;
      }

      #if ENABLE_DEVELOPMENT_METHODS != 0 && GD_CAPTURE != 0
      //* Establish a callback for capturing screenshots *
      //* of the dialog for documentation purposes.      *
      dp->EstablishCallback ( &gd_callback ) ;
      gdDialogPtr = dp ;
      gdDialogColor = gd.dColor ;
      #endif   // ENABLE_DEVELOPMENT_METHODS && GD_CAPTURE

      dp->RefreshWin () ;        // make everything visible

      //* Get user's key input *
      uiInfo   Info ;
      bool     done = false ;
      while ( ! done )
      {
         if ( Info.viaHotkey == false )
            dp->EditPushbutton ( Info ) ;
         else
            Info.HotData2Primary () ;
         if ( Info.dataMod != false || Info.keyIn == nckESC )
         {
            if ( Info.ctrlIndex == okPush && decide != false )
            { userDecision = true ; }
            else
            { /* Info.ctrlIndex == noPush || !decide */ }
            done = true ;
         }
         else
            dp->NextControl () ;
      }
   }
   if ( dp != NULL )                      // close the window
   {
// CZONE - Test for WaylandCB object, and if it exits, restore it after
//       - local dialog deleted. Potentially create an overload of the 
//       - destructor which retains the WaylandCB object.

      delete ( dp ) ;

      #if ENABLE_DEVELOPMENT_METHODS != 0 && GD_CAPTURE != 0
      gdDialogPtr = NULL ;
      #endif   // ENABLE_DEVELOPMENT_METHODS && GD_CAPTURE
   }

   //* Restore parent dialog's display *
   this->RefreshWin () ;

   return userDecision ;

}  //* End GenericDialog() *

//*************************
//*      gd_callback      *
//*************************
//******************************************************************************
//* Callback method for 'GenericDialog'.                                       *
//* Used to capture screenshots of the dialog for documentation.               *
//*   1) Screenshot activation key: nckAINSERT (ALT+INSERT)                    *
//*   2) Captures both text and HTML versions to the current working directory.*
//*      a) Text output: 'capture_dlgGD.txt'                                   *
//*      b) HTML output: 'capture_dlgGD.html'                                  *
//*                                                                            *
//* Input  : currIndex: index of control that currently has focus              *
//*          wkey     : user's key input data                                  *
//*          firstTime: the EstablishCallback() method calls this method once  *
//*                     with firstTime==true, to perform any required          *
//*                     initialization. Subsequently, the NcDialog class       *
//*                     always calls with firstTime==false.                    *
//* Returns: OK                                                                *
//******************************************************************************

#if ENABLE_DEVELOPMENT_METHODS != 0 && GD_CAPTURE != 0
static short gd_callback ( const short currIndex, const wkeyCode wkey, bool firstTime )
{
   if ( (wkey.type == wktFUNKEY) && (wkey.key == nckAINSERT) && gdDialogPtr != NULL )
   {
      gdDialogPtr->CaptureDialog ( "./capturedlgGD.txt" ) ;
      gdDialogPtr->CaptureDialog ( "./capturedlgGD.html", true, false, 
                                   "infodoc-styles.css", 4, false, 
                                   gdDialogColor ) ;
   }
   return OK ;

}  //* End gd_callback() *
#endif   // ENABLE_DEVELOPMENT_METHODS && GD_CAPTURE

//**************************
//*  Get_NcDialog_Version  *
//**************************
//******************************************************************************
//* Returns a pointer to NcDialogVersion, the NcDialog class version number.   *
//*                                                                            *
//* Input  : none                                                              *
//*                                                                            *
//* Returns: (const char*) pointer to version string                           *
//******************************************************************************

const char* NcDialog::Get_NcDialog_Version ( void )
{

   return NcDialogVersion ;

}  //* End Get_NcDialog_Version() *

//**************************
//* DisplayAltCharacterSet *
//**************************
//******************************************************************************
//* Display the characters of the Alternate Character Set (ACS).               *
//*                                                                            *
//* The ACS is accessed by setting the ncaATTR bit of the color attribute used *
//* to display the character. The ACS is used for drawing lines in the window  *
//* or displaying certain special characters. The individual characters may be *
//* accessed through the acsXXX group of constants in NCurses.hpp.             *
//*                                                                            *
//* Example of drawing a line-intersect character:                             *
//*       char intersection = acsINSECT ;                                      *
//*       this->WriteChar ( 2, 2, &intersection, nc.bw | ncaATTR ) ;           *
//*                                                                            *
//* Input  : wPos     : screen coordinates for display                         *
//*        : baseColor: display color dialog background                        *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************

void NcDialog::DisplayAltCharacterSet ( winPos wPos, attr_t baseColor )
{
#if ENABLE_DEVELOPMENT_METHODS != 0
static const short dLines = 31, dCols = 85 ;

//* Display data *
class Ident 
{
public:
   char     s[11] ;
   short    h ;
} ;
Ident Id[33] = 
{
   { "acsRARROW ", acsRARROW  },
   { "acsLARROW ", acsLARROW  },
   { "acsUARROW ", acsUARROW  },
   { "acsDARROW ", acsDARROW  },
   { "acsBLOCK  ", acsBLOCK   },
   { "acsDIAMOND", acsDIAMOND },
   { "acsPATTERN", acsPATTERN },
   { "acsDEGREE ", acsDEGREE  },
   { "acsPLMINUS", acsPLMINUS },
   { "acsBOARD  ", acsBOARD   },
   { "acsLANTERN", acsLANTERN },
   { "acsLR     ", acsLR      },
   { "acsUR     ", acsUR      },
   { "acsUL     ", acsUL      },
   { "acsLL     ", acsLL      },
   { "acsINSECT ", acsINSECT  },
   { "acsSCAN1  ", acsSCAN1   },
   { "acsSCAN3  ", acsSCAN3   },
   { "acsHORIZ  ", acsHORIZ   },
   { "acsSCAN7  ", acsSCAN7   },
   { "acsSCAN9  ", acsSCAN9   },
   { "acsLTEE   ", acsLTEE    },
   { "acsRTEE   ", acsRTEE    },
   { "acsBTEE   ", acsBTEE    },
   { "acsTTEE   ", acsTTEE    },
   { "acsVERT   ", acsVERT    },
   { "acsLEQUAL ", acsLEQUAL  },
   { "acsGEQUAL ", acsGEQUAL  },
   { "acsPI     ", acsPI      },
   { "acsNEQUAL ", acsNEQUAL  },
   { "acsSTRLING", acsSTRLING },
   { "acsBULLET ", acsBULLET  },
   { "acsSPACE  ", acsSPACE   },
} ;

   //* Save parent dialog, just in case *
   this->CaptureDialogDisplayData () ;

   //* Initial parameters for dialog window *
   InitNcDialog dInit( dLines,         // number of display lines
                       dCols,          // number of display columns
                       wPos.ypos,      // Y offset from upper-left of terminal 
                       wPos.xpos,      // X offset from upper-left of terminal
                       " Display Alternate Character Set ", // dialog title
                       ncltSINGLE,     // border line-style
                       baseColor,      // border color attribute
                       baseColor,      // interior color attribute
                       NULL            // pointer to list of control definitions
                     ) ;

   //* Instantiate the dialog window *
   NcDialog* dp = new NcDialog ( dInit ) ;
   
   //* Open the dialog window *
   if ( (dp->OpenWindow ()) == OK )
   {
      wchar_t mBuff[MAX_DIALOG_WIDTH] ;
      winPos wp( 2, 2 ) ;
      for ( short i = ZERO ; i < 11 ; i++ )
      {
         swprintf ( mBuff, MAX_DIALOG_WIDTH, 
            L"bbb %s 0x%02X ('%c')   bbb %s 0x%02X ('%c')   bbb %s 0x%02X ('%c')", 
               Id[i].s, Id[i].h, Id[i].h, Id[i+11].s, Id[i+11].h, Id[i+11].h, 
               Id[i+22].s, Id[i+22].h, Id[i+22].h ) ;
         dp->WriteString ( wp.ypos, wp.xpos, mBuff, baseColor ) ;
         swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c", acsSPACE, Id[i].h, acsSPACE ) ;
         wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
         wp.xpos += 25 ;
         swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c", acsSPACE, Id[i+11].h, acsSPACE) ;
         wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
         wp.xpos += 25 ;
         swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c", acsSPACE, Id[i+22].h, acsSPACE ) ;
         wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
         wp.ypos += 2 ;  wp.xpos = 2 ;
      }

      //* Examples *
      wp.ypos = 24 ;  wp.xpos = 6 ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c%c%c%c%c", acsUL, acsHORIZ, 
         acsHORIZ, acsHORIZ, acsTTEE, acsHORIZ, acsHORIZ, acsHORIZ, acsUR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c", acsPATTERN, acsPATTERN, 
         acsPATTERN, acsPATTERN, acsPATTERN ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c", acsBLOCK, acsBLOCK, 
         acsBLOCK, acsBLOCK, acsBLOCK ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      ++wp.ypos ;  wp.xpos = 6 ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c%c%c%c%c", acsVERT, 
         acsSPACE, acsSPACE, acsSPACE, acsVERT, acsSPACE, acsSPACE, acsSPACE, acsVERT ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c", acsPATTERN, acsPATTERN, 
         acsPATTERN, acsPATTERN, acsPATTERN ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c", acsBLOCK, acsBLOCK, 
         acsBLOCK, acsBLOCK, acsBLOCK ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      ++wp.ypos ;  wp.xpos = 6 ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c%c%c%c%c", acsLTEE, acsHORIZ, 
         acsHORIZ, acsHORIZ, acsINSECT, acsHORIZ, acsHORIZ, acsHORIZ, acsRTEE ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c", acsPATTERN, acsPATTERN, 
         acsPATTERN, acsPATTERN, acsPATTERN ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c", acsBLOCK, acsBLOCK, 
         acsBLOCK, acsBLOCK, acsBLOCK ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      ++wp.ypos ;  wp.xpos = 6 ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c%c%c%c%c", acsVERT, acsSPACE, 
         acsSPACE, acsSPACE, acsVERT, acsSPACE, acsSPACE, acsSPACE, acsVERT ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "  Pattern  Solid", baseColor ) ;
      ++wp.ypos ;  wp.xpos = 6 ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c%c%c%c%c", acsLL, acsHORIZ, 
         acsHORIZ, acsHORIZ, acsBTEE, acsHORIZ, acsHORIZ, acsHORIZ, acsLR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%c%c%c%c%c", acsSCAN1, acsSCAN3, 
         acsHORIZ, acsSCAN7, acsSCAN9 ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw | ncaATTR ) ;
      ++wp.ypos ;  wp.xpos = 6 ;
      dp->WriteString ( wp.ypos, wp.xpos, "Line Draw  Scanlines", baseColor ) ;

      dp->WriteString ( dLines-2, dCols/2-7, " Press Any Key ", nc.reS, true ) ;
      nckPause() ;
   }
   if ( dp != NULL )                      // close the window
      delete ( dp ) ;
   
   this->RefreshWin () ;                  // restore parent dialog

#endif   // ENABLE_DEVELOPMENT_METHODS
}  //* End DisplayAltCharacterSet() *
   
//***************************
//* DisplayWideCharacterSet *
//***************************
//******************************************************************************
//* Display the 'wide' equivalents to the Alternate Character Set (ACS).       *
//*                                                                            *
//* These characters are used for drawing lines in the window or for displaying*
//* certain special characters. The individual characters may be accessed      *
//* through the wcsXXXX group of constants in NCurses.hpp.                     *
//*                                                                            *
//* NOTE: The ncaATTR color-attribute bit IS NOT USED to display these         *
//*       characters.                                                          *
//*                                                                            *
//* Example of drawing a line-intersect character:                             *
//*       wchar_t intersection = wcsINSECT ;                                   *
//*       dp->WriteChar ( 2, 2, intersection, nc.bw ) ;                        *
//*                                                                            *
//* Input  : wPos     : screen coordinates for display                         *
//*        : baseColor: display color dialog background                        *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************

void NcDialog::DisplayWideCharacterSet ( winPos wPos, attr_t baseColor )
{
#if ENABLE_DEVELOPMENT_METHODS != 0
static const short dLines = 31, dCols = 85 ;

//* Display data *
class Ident 
{
public:
   wchar_t  s[11] ;
   wchar_t  h ;
} ;
Ident Id[33] = 
{
   { L"wcsRARROW ", wcsRARROW  },
   { L"wcsLARROW ", wcsLARROW  },
   { L"wcsUARROW ", wcsUARROW  },
   { L"wcsDARROW ", wcsDARROW  },
   { L"wcsBLOCK  ", wcsBLOCK   },
   { L"wcsDIAMOND", wcsDIAMOND },
   { L"wcsPATTERN", wcsPATTERN },
   { L"wcsDEGREE ", wcsDEGREE  },
   { L"wcsPLMINUS", wcsPLMINUS },
   { L"wcsBOARD  ", wcsBOARD   },
   { L"wcsLANTERN", wcsLANTERN },
   { L"wcsLR     ", wcsLR      },
   { L"wcsUR     ", wcsUR      },
   { L"wcsUL     ", wcsUL      },
   { L"wcsLL     ", wcsLL      },
   { L"wcsINSECT ", wcsINSECT  },
   { L"wcsSCAN1  ", wcsSCAN1   },
   { L"wcsSCAN3  ", wcsSCAN3   },
   { L"wcsHORIZ  ", wcsHORIZ   },
   { L"wcsSCAN7  ", wcsSCAN7   },
   { L"wcsSCAN9  ", wcsSCAN9   },
   { L"wcsLTEE   ", wcsLTEE    },
   { L"wcsRTEE   ", wcsRTEE    },
   { L"wcsBTEE   ", wcsBTEE    },
   { L"wcsTTEE   ", wcsTTEE    },
   { L"wcsVERT   ", wcsVERT    },
   { L"wcsLEQUAL ", wcsLEQUAL  },
   { L"wcsGEQUAL ", wcsGEQUAL  },
   { L"wcsPI     ", wcsPI      },
   { L"wcsNEQUAL ", wcsNEQUAL  },
   { L"wcsSTRLING", wcsSTRLING },
   { L"wcsBULLET ", wcsBULLET  },
   { L"wcsSPACE  ", wcsSPACE   },
} ;

   //* Save parent dialog, just in case *
   this->CaptureDialogDisplayData () ;

   //* Initial parameters for dialog window *
   InitNcDialog dInit( dLines,         // number of display lines
                       dCols,          // number of display columns
                       wPos.ypos,      // Y offset from upper-left of terminal 
                       wPos.xpos,      // X offset from upper-left of terminal
                       " Display 'Wide' Equivalents to Alternate Character Set ", // dialog title
                       ncltSINGLE,     // border line-style
                       baseColor,      // border color attribute
                       baseColor,      // interior color attribute
                       NULL            // pointer to list of control definitions
                     ) ;

   //* Instantiate the dialog window *
   NcDialog* dp = new NcDialog ( dInit ) ;
   
   //* Open the dialog window *
   if ( (dp->OpenWindow ()) == OK )
   {
      wchar_t mBuff[MAX_DIALOG_WIDTH] ;
      winPos wp( 2, 2 ) ;
      for ( short i = ZERO ; i < 11 ; i++ )
      {
         swprintf ( mBuff, MAX_DIALOG_WIDTH, 
            L"bbb %S 0x%06X     bbb %S 0x%06X     bbb %S 0x%06X ", 
               Id[i].s, Id[i].h, Id[i+11].s, Id[i+11].h, Id[i+22].s, Id[i+22].h ) ;
         dp->WriteString ( wp.ypos, wp.xpos, mBuff, baseColor ) ;
         swprintf ( mBuff, MAX_DIALOG_WIDTH, L" %C ", Id[i].h ) ;
         wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
         wp.xpos += 25 ;
         swprintf ( mBuff, MAX_DIALOG_WIDTH, L" %C ", Id[i+11].h ) ;
         wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
         wp.xpos += 25 ;
         swprintf ( mBuff, MAX_DIALOG_WIDTH, L" %C ", Id[i+22].h ) ;
         wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
         wp.ypos += 2 ;  wp.xpos = 2 ;
      }

      //* Examples *
      wp.ypos = 24 ;  wp.xpos = 6 ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C%C%C%C%C", wcsUL, wcsHORIZ, 
         wcsHORIZ, wcsHORIZ, wcsTTEE, wcsHORIZ, wcsHORIZ, wcsHORIZ, wcsUR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C", wcsPATTERN, wcsPATTERN, 
         wcsPATTERN, wcsPATTERN, wcsPATTERN ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C", wcsBLOCK, wcsBLOCK, 
         wcsBLOCK, wcsBLOCK, wcsBLOCK ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      ++wp.ypos ;  wp.xpos = 6 ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C%C%C%C%C", wcsVERT, 
         wcsSPACE, wcsSPACE, wcsSPACE, wcsVERT, wcsSPACE, wcsSPACE, wcsSPACE, wcsVERT ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C", wcsPATTERN, wcsPATTERN, 
         wcsPATTERN, wcsPATTERN, wcsPATTERN ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C", wcsBLOCK, wcsBLOCK, 
         wcsBLOCK, wcsBLOCK, wcsBLOCK ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      ++wp.ypos ;  wp.xpos = 6 ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C%C%C%C%C", wcsLTEE, wcsHORIZ, 
         wcsHORIZ, wcsHORIZ, wcsINSECT, wcsHORIZ, wcsHORIZ, wcsHORIZ, wcsRTEE ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C", wcsPATTERN, wcsPATTERN, 
         wcsPATTERN, wcsPATTERN, wcsPATTERN ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C", wcsBLOCK, wcsBLOCK, 
         wcsBLOCK, wcsBLOCK, wcsBLOCK ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      ++wp.ypos ;  wp.xpos = 6 ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C%C%C%C%C", wcsVERT, wcsSPACE, 
         wcsSPACE, wcsSPACE, wcsVERT, wcsSPACE, wcsSPACE, wcsSPACE, wcsVERT ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "  Pattern  Solid", baseColor ) ;
      ++wp.ypos ;  wp.xpos = 6 ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C%C%C%C%C", wcsLL, wcsHORIZ, 
         wcsHORIZ, wcsHORIZ, wcsBTEE, wcsHORIZ, wcsHORIZ, wcsHORIZ, wcsLR ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, "   ", baseColor ) ;
      swprintf ( mBuff, MAX_DIALOG_WIDTH, L"%C%C%C%C%C", wcsSCAN1, wcsSCAN3, 
         wcsHORIZ, wcsSCAN7, wcsSCAN9 ) ;
      wp = dp->WriteString ( wp.ypos, wp.xpos, mBuff, nc.bw ) ;
      ++wp.ypos ;  wp.xpos = 6 ;
      dp->WriteString ( wp.ypos, wp.xpos, "Line Draw  Scanlines", baseColor ) ;

      dp->WriteString ( dLines-2, dCols/2-7, L" Press Any Key ", nc.reS, true ) ;
      nckPause() ;
   }
   if ( dp != NULL )                      // close the window
      delete ( dp ) ;
   
   this->RefreshWin () ;                  // restore parent dialog

#endif   // ENABLE_DEVELOPMENT_METHODS
}  //* End DisplayWideCharacterSet() *
   
//***************************
//*  DisplayLineDrawingSet  *
//***************************
//******************************************************************************
//* Display the line-drawing characters defined within the wcsXXXX group of    *
//* constants in NCurses.hpp.                                                  *
//*                                                                            *
//* These characters are used for drawing lines in the window.                 *
//* See also the LineDef class definition in NcWindow.hpp.                     *
//*                                                                            *
//* Input  : wPos     : screen coordinates for display                         *
//*        : baseColor: display color dialog background                        *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************

void NcDialog::DisplayLineDrawingSet ( winPos wPos, attr_t baseColor )
{
#if ENABLE_DEVELOPMENT_METHODS != 0
static const short dLines = 31, dCols = 85 ;

//* Display data *
class Ident 
{
public:
   wchar_t  s[12] ;
   wchar_t  h ;
} ;
Ident Id[90] = 
{
   { L"wcsHORIZs  ", wcsHORIZs   },    // horizontal lines
   { L"wcsHORIZb  ", wcsHORIZb   },
   { L"wcsHORIZd  ", wcsHORIZd   },
   { L"wcsHDASH2s ", wcsHDASH2s  },
   { L"wcsHDASH2b ", wcsHDASH2b  },
   { L"wcsHDASH3s ", wcsHDASH3s  },
   { L"wcsHDASH3b ", wcsHDASH3b  },
   { L"wcsHDASH4s ", wcsHDASH4s  },
   { L"wcsHDASH4b ", wcsHDASH4b  },

   { L"wcsVERTs   ", wcsVERTs    },    // vertical lines
   { L"wcsVERTb   ", wcsVERTb    },
   { L"wcsVERTd   ", wcsVERTd    },
   { L"wcsVDASH2s ", wcsVDASH2s  },
   { L"wcsVDASH2b ", wcsVDASH2b  },
   { L"wcsVDASH3s ", wcsVDASH3s  },
   { L"wcsVDASH3b ", wcsVDASH3b  },
   { L"wcsVDASH4s ", wcsVDASH4s  },
   { L"wcsVDASH4b ", wcsVDASH4b  },

   { L"wcsULs     ", wcsULs      },    // corners
   { L"wcsULb     ", wcsULb      },
   { L"wcsULd     ", wcsULd      },
   { L"wcsURs     ", wcsURs      },
   { L"wcsURb     ", wcsURb      },
   { L"wcsURd     ", wcsURd      },
   { L"wcsLLs     ", wcsLLs      },
   { L"wcsLLb     ", wcsLLb      },
   { L"wcsLLd     ", wcsLLd      },
   { L"wcsLRs     ", wcsLRs      },
   { L"wcsLRb     ", wcsLRb      },
   { L"wcsLRd     ", wcsLRd      },

   { L"wcsLTEEs   ", wcsLTEEs    },     // T connectors
   { L"wcsLTEEb   ", wcsLTEEb    },
   { L"wcsLTEEd   ", wcsLTEEd    },
   { L"wcsLTEEbv  ", wcsLTEEbv   },
   { L"wcsLTEEbh  ", wcsLTEEbh   },
   { L"wcsLTEEdv  ", wcsLTEEdv   },
   { L"wcsLTEEdh  ", wcsLTEEdh   },

   { L"wcsRTEEs   ", wcsRTEEs    },
   { L"wcsRTEEb   ", wcsRTEEb    },
   { L"wcsRTEEd   ", wcsRTEEd    },
   { L"wcsRTEEbv  ", wcsRTEEbv   },
   { L"wcsRTEEbh  ", wcsRTEEbh   },
   { L"wcsRTEEdv  ", wcsRTEEdv   },
   { L"wcsRTEEdh  ", wcsRTEEdh   },

   { L"wcsTTEEs   ", wcsTTEEs    },
   { L"wcsTTEEb   ", wcsTTEEb    },
   { L"wcsTTEEd   ", wcsTTEEd    },
   { L"wcsTTEEbv  ", wcsTTEEbv   },
   { L"wcsTTEEbh  ", wcsTTEEbh   },
   { L"wcsTTEEdv  ", wcsTTEEdv   },
   { L"wcsTTEEdh  ", wcsTTEEdh   },

   { L"wcsBTEEs   ", wcsBTEEs    },
   { L"wcsBTEEb   ", wcsBTEEb    },
   { L"wcsBTEEd   ", wcsBTEEd    },
   { L"wcsBTEEbv  ", wcsBTEEbv   },
   { L"wcsBTEEbh  ", wcsBTEEbh   },
   { L"wcsBTEEdv  ", wcsBTEEdv   },
   { L"wcsBTEEdh  ", wcsBTEEdh   },

   { L"wcsINSECTs ", wcsINSECTs  },    // intersections
   { L"wcsINSECTb ", wcsINSECTb  },
   { L"wcsINSECTd ", wcsINSECTd  },
   { L"wcsINSECTbv", wcsINSECTbv },
   { L"wcsINSECTbh", wcsINSECTbh },
   { L"wcsINSECTdv", wcsINSECTdv },
   { L"wcsINSECTdh", wcsINSECTdh },

   { L"wcsBLOCKl  ", wcsBLOCKl   },    // block characters
   { L"wcsBLOCKm  ", wcsBLOCKm   },
   { L"wcsBLOCKd  ", wcsBLOCKd   },
   { L"wcsBLOCKs  ", wcsBLOCKs   },
} ;

   //* Save parent dialog, just in case *
   this->CaptureDialogDisplayData () ;

   //* Initial parameters for dialog window *
   InitNcDialog dInit( dLines,         // number of display lines
                       dCols,          // number of display columns
                       wPos.ypos,      // Y offset from upper-left of terminal 
                       wPos.xpos,      // X offset from upper-left of terminal
                       "  Line-drawing Characters  ", // dialog title
                       ncltSINGLE,     // border line-style
                       baseColor,      // border color attribute
                       baseColor,      // interior color attribute
                       NULL            // pointer to list of control definitions
                     ) ;

   //* Instantiate the dialog window *
   NcDialog* dp = new NcDialog ( dInit ) ;

   //* Open the dialog window *
   if ( (dp->OpenWindow ()) == OK )
   {
      attr_t      charColor =          // character display color
                     (baseColor & ncrATTR ? 
                     (baseColor &(~ncrATTR)) : (baseColor | ncrATTR)) ;
      short       bY = 2, bX = 3 ;
      winPos      wp( bY, bX ) ;       // cursor position
      const short oLen = 128 ;         // buffer length
      short       offset ;             // position offset
      wchar_t     oStr[oLen] ;         // output buffer

      //* Left row *
      short i = ZERO ;
      for ( ; i < 24 ; i++ )
      {
         if ( i % 2 )
            offset = 3 ;
         else
            offset = ZERO ;
         swprintf ( oStr, oLen, L" %C ", Id[i].h ) ;
         wp = dp->WriteString ( wp.ypos, (wp.xpos + offset), oStr, charColor ) ;

         if ( i % 2 )
            offset = ZERO ;
         else
            offset = 3 ;
         swprintf ( oStr, oLen, L" %S 0x%04lX", Id[i].s, Id[i].h ) ;
         dp->WriteString ( wp.ypos++, (wp.xpos + offset), oStr, baseColor ) ;
         wp.xpos = bX ;
      }

      //* Left+1 row *
      bX += 27 ;
      wp.ypos = bY ; wp.xpos = bX ;
      for (  ; i < 48 ; i++ )
      {
         if ( i % 2 )
            offset = 3 ;
         else
            offset = ZERO ;
         swprintf ( oStr, oLen, L" %C ", Id[i].h ) ;
         wp = dp->WriteString ( wp.ypos, (wp.xpos + offset), oStr, charColor ) ;

         if ( i % 2 )
            offset = ZERO ;
         else
            offset = 3 ;
         swprintf ( oStr, oLen, L" %S 0x%04lX", Id[i].s, Id[i].h ) ;
         dp->WriteString ( wp.ypos++, (wp.xpos + offset), oStr, baseColor ) ;
         wp.xpos = bX ;
      }

      //* Left+2 row *
      bX += 27 ;
      wp.ypos = bY ; wp.xpos = bX ;
      for (  ; i < 69 ; i++ )
      {
         if ( i % 2 )
            offset = 3 ;
         else
            offset = ZERO ;
         swprintf ( oStr, oLen, L" %C ", Id[i].h ) ;
         wp = dp->WriteString ( wp.ypos, (wp.xpos + offset), oStr, charColor ) ;

         if ( i % 2 )
            offset = ZERO ;
         else
            offset = 3 ;
         swprintf ( oStr, oLen, L" %S 0x%04lX", Id[i].s, Id[i].h ) ;
         dp->WriteString ( wp.ypos++, (wp.xpos + offset), oStr, baseColor ) ;
         wp.xpos = bX ;
      }

      dp->WriteString ( dLines-2, dCols/2-7, L" Press Any Key ", nc.reS, true ) ;
      nckPause() ;
   }
   if ( dp != NULL )                      // close the window
      delete ( dp ) ;
   
   this->RefreshWin () ;                  // restore parent dialog

#endif   // ENABLE_DEVELOPMENT_METHODS
}  //* DisplayLineDrawingSet() *

//********************************
//*  DisplayLineDrawingExamples  *
//********************************
//******************************************************************************
//* Display the line-drawing characters defined within the wcsXXXX group of    *
//* constants in NCurses.hpp.                                                  *
//*                                                                            *
//* These characters are used for drawing lines in the window.                 *
//* See also the LineDef class definition in NcWindow.hpp.                     *
//*                                                                            *
//* Input  : wPos     : screen coordinates for display                         *
//*        : baseColor: display color dialog background                        *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************

void NcDialog::DisplayLineDrawingExamples ( winPos wPos, attr_t baseColor )
{
#if ENABLE_DEVELOPMENT_METHODS != 0
static const short dLines = 31, dCols = 85 ;

   //* Save parent dialog, just in case *
   this->CaptureDialogDisplayData () ;

   //* Initial parameters for dialog window *
   InitNcDialog dInit( dLines,         // number of display lines
                       dCols,          // number of display columns
                       wPos.ypos,      // Y offset from upper-left of terminal 
                       wPos.xpos,      // X offset from upper-left of terminal
                       "  Line-drawing Examples  ", // dialog title
                       ncltSINGLE,     // border line-style
                       baseColor,      // border color attribute
                       baseColor,      // interior color attribute
                       NULL            // pointer to list of control definitions
                     ) ;

   //* Instantiate the dialog window *
   NcDialog* dp = new NcDialog ( dInit ) ;
   
   //* Open the dialog window *
   if ( (dp->OpenWindow ()) == OK )
   {
      short lsY = 2, lsX = 3 ;
      dp->WriteString ( lsY, lsX, "          Line Styles          ", 
                        baseColor | ncuATTR ) ;
      dp->WriteParagraph ( lsY + 1, lsX + 17, 
         "ncltSINGLE\n"
         "ncltSINGLEBOLD\n"
         "ncltDUAL\n"
         "ncltDASH2\n"
         "ncltDASH2BOLD\n"
         "ncltDASH3\n"
         "ncltDASH3BOLD\n"
         "ncltDASH4\n"
         "ncltDASH4BOLD\n", baseColor ) ;
      LineDef lDefH( ncltHORIZ, ncltSINGLE, (lsY + 1), lsX, 16, baseColor ) ;
      dp->DrawLine ( lDefH ) ;
      dp->WriteChar ( lDefH.startY, lDefH.startX, wcsULs, baseColor ) ;
      LineDef lDefV( ncltVERT, ncltSINGLE, (lsY + 2), lsX, 14, baseColor ) ;
      dp->DrawLine ( lDefV ) ;

      lDefH.style = ncltSINGLEBOLD ; ++lDefH.startY ; ++lDefH.startX ; --lDefH.length ;
      dp->DrawLine ( lDefH ) ;
      dp->WriteChar ( lDefH.startY, lDefH.startX, wcsULb, baseColor ) ;
      lDefV.style = ncltSINGLEBOLD ; ++lDefV.startY ; ++lDefV.startX ; --lDefV.length ;
      dp->DrawLine ( lDefV ) ;

      lDefH.style = ncltDUAL ;       ++lDefH.startY ; ++lDefH.startX ; --lDefH.length ;
      dp->DrawLine ( lDefH ) ;
      dp->WriteChar ( lDefH.startY, lDefH.startX, wcsULd, baseColor ) ;
      lDefV.style = ncltDUAL ;       ++lDefV.startY ; ++lDefV.startX ; --lDefV.length ;
      dp->DrawLine ( lDefV ) ;

      lDefH.style = ncltDASH2 ;      ++lDefH.startY ; ++lDefH.startX ; --lDefH.length ;
      dp->DrawLine ( lDefH ) ;
      dp->WriteChar ( lDefH.startY, lDefH.startX, wcsULs, baseColor ) ;
      lDefV.style = ncltDASH2 ;      ++lDefV.startY ; ++lDefV.startX ; --lDefV.length ;
      dp->DrawLine ( lDefV ) ;

      lDefH.style = ncltDASH2BOLD ;  ++lDefH.startY ; ++lDefH.startX ; --lDefH.length ;
      dp->DrawLine ( lDefH ) ;
      dp->WriteChar ( lDefH.startY, lDefH.startX, wcsULb, baseColor ) ;
      lDefV.style = ncltDASH2BOLD ;  ++lDefV.startY ; ++lDefV.startX ; --lDefV.length ;
      dp->DrawLine ( lDefV ) ;

      lDefH.style = ncltDASH3 ;      ++lDefH.startY ; ++lDefH.startX ; --lDefH.length ;
      dp->DrawLine ( lDefH ) ;
      dp->WriteChar ( lDefH.startY, lDefH.startX, wcsULs, baseColor ) ;
      lDefV.style = ncltDASH3 ;      ++lDefV.startY ; ++lDefV.startX ; --lDefV.length ;
      dp->DrawLine ( lDefV ) ;

      lDefH.style = ncltDASH3BOLD ;  ++lDefH.startY ; ++lDefH.startX ; --lDefH.length ;
      dp->DrawLine ( lDefH ) ;
      dp->WriteChar ( lDefH.startY, lDefH.startX, wcsULs, baseColor ) ;
      lDefV.style = ncltDASH3BOLD ;  ++lDefV.startY ; ++lDefV.startX ; --lDefV.length ;
      dp->DrawLine ( lDefV ) ;

      lDefH.style = ncltDASH4 ;      ++lDefH.startY ; ++lDefH.startX ; --lDefH.length ;
      dp->DrawLine ( lDefH ) ;
      dp->WriteChar ( lDefH.startY, lDefH.startX, wcsULs, baseColor ) ;
      lDefV.style = ncltDASH4 ;      ++lDefV.startY ; ++lDefV.startX ; --lDefV.length ;
      dp->DrawLine ( lDefV ) ;

      lDefH.style = ncltDASH4BOLD ;  ++lDefH.startY ; ++lDefH.startX ; --lDefH.length ;
      dp->DrawLine ( lDefH ) ;
      dp->WriteChar ( lDefH.startY, lDefH.startX, wcsULs, baseColor ) ;
      lDefV.style = ncltDASH4BOLD ;  ++lDefV.startY ; ++lDefV.startX ; --lDefV.length ;
      dp->DrawLine ( lDefV ) ;

      short cvY = 2, cvX = 36 ;
      dp->WriteString ( cvY, cvX, "    Connect With Verticals     ", 
                        baseColor | ncuATTR ) ;
      //* Draw some verticals *
      #if 1    // Production: ncltSINGLE
      lDefV.style = ncltSINGLE ;
      #elif 0  // Test only: ncltSINGLEBOLD
      lDefV.style = ncltSINGLEBOLD ;
      #else    // Test only: ncltDUAL
      lDefV.style = ncltDUAL ;
      #endif
      lDefV.length = 11 ; lDefV.startY = cvY+1 ; lDefV.startX = cvX ;
      dp->DrawLine ( lDefV ) ;
      lDefV.startX += 30 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.startX -= 27 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltSINGLEBOLD ; lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDUAL ;       lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH2 ;      lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH2BOLD ;  lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH3 ;      lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH3BOLD ;  lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH4 ;      lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH4BOLD ;  lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;

      //* Draw some horizontals that connect with above verticals *
      dp->WriteParagraph ( cvY + 2, cvX + 32, 
         "ncltSINGLE\n"
         "ncltSINGLEBOLD\n"
         "ncltDUAL\n"
         "ncltDASH2\n"
         "ncltDASH2BOLD\n"
         "ncltDASH3\n"
         "ncltDASH3BOLD\n"
         "ncltDASH4\n"
         "ncltDASH4BOLD\n", baseColor ) ;
      lDefH.length = 31 ; lDefH.cLeft = lDefH.cRight = lDefH.cInsect = true ;
      lDefH.style = ncltSINGLE ; lDefH.startY = cvY + 2 ; lDefH.startX = cvX ; 
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltSINGLEBOLD ; lDefH.startY = 5 ; 
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDUAL ;       lDefH.startY = 6 ; 
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH2 ;      lDefH.startY = 7 ; 
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH2BOLD ;  lDefH.startY = 8 ; 
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH3 ;      lDefH.startY = 9 ; 
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH3BOLD ;  lDefH.startY = 10 ; 
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH4 ;      lDefH.startY = 11 ; 
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH4BOLD ;  lDefH.startY = 12 ; 
      dp->DrawLine ( lDefH ) ;

      short chY = cvY + 13, chX = cvX ;
      dp->WriteString ( chY, chX, "   Connect With Horizontals    ", baseColor | ncuATTR ) ;
      //* Draw some horizontals *
      #if 1    // Production: ncltSINGLE
      lDefH.style = ncltSINGLE ;
      #elif 0  // Test only: ncltSINGLEBOLD
      lDefH.style = ncltSINGLEBOLD ;
      #else    // Test only: ncltDUAL
      lDefH.style = ncltDUAL ;
      #endif
      lDefH.length = 31 ; lDefH.startY = chY + 1 ; lDefH.startX = chX ;
      dp->DrawLine ( lDefH ) ;
      lDefH.startY += 10 ;
      dp->DrawLine ( lDefH ) ;
      lDefH.startY -= 9 ;
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltSINGLEBOLD ; ++lDefH.startY ;
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDUAL ;       ++lDefH.startY ;
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH2 ;      ++lDefH.startY ;
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH2BOLD ;  ++lDefH.startY ;
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH3 ;      ++lDefH.startY ;
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH3BOLD ;  ++lDefH.startY ;
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH4 ;      ++lDefH.startY ;
      dp->DrawLine ( lDefH ) ;
      lDefH.style = ncltDASH4BOLD ;  ++lDefH.startY ;
      dp->DrawLine ( lDefH ) ;

      //* Draw some verticals that connect with above horizontals *
      dp->WriteParagraph ( chY + 2, chX + 32, 
         "ncltSINGLE\n"
         "ncltSINGLEBOLD\n"
         "ncltDUAL\n"
         "ncltDASH2\n"
         "ncltDASH2BOLD\n"
         "ncltDASH3\n"
         "ncltDASH3BOLD\n"
         "ncltDASH4\n"
         "ncltDASH4BOLD\n", baseColor ) ;
      lDefV.length = 11 ; lDefV.cTop = lDefV.cBot = lDefV.cInsect = true ;
      lDefV.style = ncltSINGLE ; lDefV.startY = chY + 1 ; lDefV.startX = chX + 3 ; 
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltSINGLEBOLD ; lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDUAL ;       lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH2 ;      lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH2BOLD ;  lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH3 ;      lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH3BOLD ;  lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH4 ;      lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;
      lDefV.style = ncltDASH4BOLD ;  lDefV.startX += 3 ;
      dp->DrawLine ( lDefV ) ;

      dp->WriteString ( lsY + 17, lsX, "  Boxes With Connections  ", baseColor | ncuATTR ) ;
      short bsY = lsY + 18, bsX = lsX, bsH = 5, bsW = 13 ;
      dp->DrawBox ( bsY, bsX, bsH, bsW, baseColor ) ;
      lDefH.cLeft = lDefH.cRight = lDefV.cTop = lDefV.cBot = 
      lDefH.cInsect = lDefV.cInsect = true ;
      lDefH.length = 13 ; lDefV.length = 5 ;

      lDefH.style = lDefV.style = ncltSINGLE ;
      lDefH.startY = bsY + 2 ; lDefH.startX = bsX ;
      dp->DrawLine ( lDefH ) ;
      lDefV.startY = bsY ; lDefV.startX = bsX + 5 ;
      dp->DrawLine ( lDefV ) ;

      bsY += 5 ;
      dp->DrawBox ( bsY, bsX, bsH, bsW, baseColor, NULL, ncltDUAL ) ;
      lDefH.style = lDefV.style = ncltDUAL ;
      lDefH.startY = bsY + 2 ; lDefH.startX = bsX ;
      dp->DrawLine ( lDefH ) ;
      lDefV.startY = bsY ; lDefV.startX = bsX + 5 ;
      dp->DrawLine ( lDefV ) ;

      bsY -= 5 ; bsX += 13 ;
      dp->DrawBox ( bsY, bsX, bsH, bsW, baseColor, NULL, ncltSINGLEBOLD ) ;
      lDefH.style = lDefV.style = ncltSINGLEBOLD ;
      lDefH.startY = bsY + 2 ; lDefH.startX = bsX ;
      dp->DrawLine ( lDefH ) ;
      lDefV.startY = bsY ; lDefV.startX = bsX + 5 ;
      dp->DrawLine ( lDefV ) ;

      bsY += 5 ;
      dp->DrawBox ( bsY, bsX, bsH, bsW, baseColor, NULL, ncltDASH2 ) ;
      lDefH.style = lDefV.style = ncltDASH2 ;
      lDefH.startY = bsY + 2 ; lDefH.startX = bsX ;
      dp->DrawLine ( lDefH ) ;
      lDefV.startY = bsY ; lDefV.startX = bsX + 5 ;
      dp->DrawLine ( lDefV ) ;


      dp->WriteString ( dLines-2, dCols/2-7, L" Press Any Key ", nc.reS, true ) ;
      nckPause() ;
   }
   if ( dp != NULL )                      // close the window
      delete ( dp ) ;
   
   this->RefreshWin () ;                  // restore parent dialog

#endif   // ENABLE_DEVELOPMENT_METHODS
}  //* End DisplayLineDrawingExamples() *
   
//*************************
//*      DebugMsg         *
//*************************
//******************************************************************************
//* Display a message in the last line of the dialog window.                   *
//* For debugging only, but note that this method is not controlled by the     *
//* ENABLE_DEVELOPMENT_METHODS flag, so it is always available.                *
//*                                                                            *
//* NOTE: We don't bother to check whether the display string is longer than   *
//*       the dialog is wide. That will be handled by the WriteString() method.*
//*                                                                            *
//* Input  : msg   : message to be displayed                                   *
//*                  if message == "%", clear the message area                 *
//*          pause : (optional, ZERO by default): wait before return           *
//*                  interpreted as number of seconds to wait                  *
//*                  pause >= 30 indicates wait for keypress                   *
//*          erase : (optional, false by default): if true, erase the message  *
//*                  after the pause                                           *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************

void NcDialog::DebugMsg ( const char* msg, short pause, bool erase )
{
   const short maxDelay = 30 ;
   if ( !(strncmp ( msg, "%", 2 )) )
   {
      erase = true ;
      pause = ZERO ;
   }
   else
   {
      this->ClearLine ( this->dLines-1, false ) ;
      this->WriteString ( this->dLines-1, 1, msg, nc.bw, true ) ;
   }
   if ( pause > ZERO )
   {
      if ( pause < maxDelay )
      {
         chrono::duration<short, std::milli>pauseTime( pause * 1000 ) ;
         this_thread::sleep_for( pauseTime ) ;
      }
      else
         nckPause() ;
   }
   if ( erase )      // restore dialog border to its virginal state
   {
      LineDef  lDef(ncltHORIZ, this->bStyle, 
                    this->dLines-1, 1, this->dCols-2, this->bColor) ;
      this->DrawLine ( lDef ) ;
      wchar_t lrCorner ;
      switch ( this->bStyle )
      {
         case ncltSINGLEBOLD: lrCorner = wcsLRb ;  break ;
         case ncltDUAL:       lrCorner = wcsLRd ;  break ;
         default:             lrCorner = wcsLRs ;  break ;
      }
      this->WriteChar ( this->dLines-1, this->dCols-1, 
                        lrCorner, this->bColor, true ) ;
   }

}  //* End DebugMsg() *

//*************************
//*                       *
//*************************
//********************************************************************************
//*                                                                              *
//*                                                                              *
//*                                                                              *
//* Input  :                                                                     *
//*                                                                              *
//* Returns:                                                                     *
//********************************************************************************

