//******************************************************************************
//* File      :  BillboardTest.hpp                                             *
//* Author    :  Mahlon R. Smith                                               *
//*              Copyright (c) 2013-2025 Mahlon R. Smith, The Software Samurai *
//* Date      :  02-Jan-2020                                                   *
//*                                                                            *
//* Description: Class definition for the BillboartTest class.                 *
//*              This class exercises the DialogBillboard-class control        *
//*              defined in NcDialog.hpp.                                      *
//*              It is instantiated by the Dialog4 application, Test05.        *
//*                                                                            *
//*                                                                            *
//* Developed using GNU G++ (Gcc v: 4.8.0)                                     *
//*  under Fedora Release 16, Kernel Linux 3.6.11-4.fc16.i686.PAE              *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"

//* Test #5 uses multi-threading to drive the automatic news scroll. *
//* If your system or compiler does not support C++11 multithreading,*
//* then set this definition to '0'. Although the automatic scroll   *
//* will be disabled, the remainder of the test will still function  *
//* properly. See also the Makefile. Note specifically, that the     *
//* pthread library is linked to the application.                    *
#define ENABLE_BT_MULTITHREAD (1)

//* Size of dialog window *
const short btROWS = 35 ;           // display lines
const short btCOLS = 80 ;           // display columns
const short Bill1ROWS = 14 ;        // height of Billboard A control
const short Bill2COLS = 34 ;        // Width of Billboard B control

//* Control definitions for controls in BillboardTest dialog *
enum btControls {
                  btDonePB = 0, btBilaBB, btBilbBB, 
                  btUsRB, btUlRB, btWsRB, btWlRB, btClrRB, btMultiRB, btNextPB, 
                  btCustTB, btCustRB, btAppPB, btPosRB, btRepPB, btLineSP, 
                  btExtPB, btSwpPB, 
                  btControlsDEFINED      // number of controls in dialog
                } ;


//* Description of Test05, DialogBillboard-class test *
class BillboardTest
{
   public:
   virtual ~BillboardTest ( void ) ;// destructor
   //* Constructor *
   BillboardTest ( short tLines, short tCols, short minY ) ;
   bool btDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void btInteract ( void ) ;       // interact with disgusting, dirty users

   private:
   bool  btOpenDialog ( void ) ;    // open the dialog window
   void  btBreakingNews ( bool* quittingTime ) ;   // secondary execution thread

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       minULY ;             // first available display row in termwin
   attr_t      dColor ;             // Dialog background color
   attr_t      bColor ;             // Dialog border color
   bool        btOpen ;             // 'true' if dialog opened successfully
} ;

