//******************************************************************************
//* File       : ChartTest.hpp                                                 *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2020-2025 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       : 21-Mar-2025                                                   *
//* Version    : (see ChartTest.cpp)                                           *
//*                                                                            *
//* Description: Class definition for the ChartTest class.                     *
//*              This class provides a dialog window in which all functionality*
//*              of the Chart class can be tested and demonstrated.            *
//*              This test is called as a menu item within the Dialog4         *
//*              application, Test10.                                          *
//*                                                                            *
//* Development Tools: See NcDialog.cpp.                                       *
//******************************************************************************

#include "GlobalDef.hpp"
#include "Chart.hpp"

//** Charttest class definition **
class ChartTest
{
   public:
   ~ChartTest (void) {}                      // destructor
   ChartTest ( const winPos& wpOrig ) ;      // constructor
   bool  isOpen ( void )
   { return this->dlgOpen ; }

   //* Get minimum terminal dimensions needed for this test dialog.*
   void GetDimensions ( short& rowsNeeded, short& colsNeeded ) ;

   //* For debugging only: Capture screenshot of the target dialog.*
   void  ScreenCapture ( Chart *chartPtr ) ;

   private:
   void  Setup ( const winPos& wpo ) ;    // initial configuration
   void  BlastOff ( void ) ;              // Launch the Chart object
   void  SetChartDefinition ( void ) ;    // initialize the ChartDef object, etc.
   void  ClearTargetArea ( bool restore = false ) ;
   void  Cry4Help ( void ) ;              // view documentation
   int   LaunchDefaultApplication ( const char* targFile, bool redirect = true ) ;
   void  InitHelpPath ( void ) ;          // locate the help files
   void  DisplayStats ( Chart *cp ) ;     // in header area, display stats on dataset
   void  SwapDatasets ( const void*& currData,  // exercise data-reload methods
                        int32_t& currCount, idataType& currType, bool& currHzb ) ;
   void  StressedHead2Foot ( Chart *cp, wchar_t targetArea ) ; // exercise text-display areas
   void  statMsg ( gString& msg, bool boldAttr = false, bool   // give user a clue
                   center = true, short warn = ZERO ) ;
   void  statMsg ( const char* msg, bool boldAttr = false, 
                   bool center = true, short warn = ZERO ) ;

   //** Data Members **
   NcDialog *dp ;             // pointer to NcDialog object
   InitCtrl *icptr ;          // pointer to control-initialization array
   attr_t dColor ;            // dialog base color
   attr_t tColor ;            // dialog title color
   attr_t bColor ;            // dialog border color
   attr_t hColor ;            // dialog highlight color
   attr_t chbColor ;          // chart base color, grid color, bar color
   attr_t chnColor ;          // chart negative-values color
   attr_t cdbColor ;          // chart border color
                              //** Dialog control colors **
   attr_t pbnColor ;          // Pushbutton non-focus color
   attr_t pbfColor ;          // Pushbutton focus color
   attr_t tbnColor ;          // Textbox non-focus color
   attr_t tbfColor ;          // Textbox focus color
   attr_t ddnColor ;          // Dropdown non-focus color
   attr_t ddfColor ;          // Dropdown focus color
   attr_t spnColor ;          // Spinner non-focus color
   attr_t spfColor ;          // Spinner focus color
   attr_t rbnColor ;          // Radiobutton non-focus color
   attr_t rbfColor ;          // Radiobutton focus color

   winPos wpOrig ;            // absolute terminal offset for main dialog
   ChartDef cdef ;            // chart object setup data

   char helpPath[gsDFLTBYTES] ;// filespec of NcDialogAPI help file (Info format)
   char helpUrl[gsDFLTBYTES] ; // URL to NcDialogAPI help file (HTML format)
   bool dlgOpen ;             // 'true' if dialog opened successfully

} ;
