//******************************************************************************
//* File       : ShellTest.hpp                                                 *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2015-2025 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       : 02-Jan-2020                                                   *
//*                                                                            *
//* Description: Class definition for the ShellTest class.                     *
//*              This class allows you to play with the options for the        *
//*              NcDialog ShellOut() and PseudoShell() methods.                *
//*              It is instantiated by the Dialog4 application, Test08.        *
//*                                                                            *
//* Development Tools: See NcDialog.cpp.                                       *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"


//* Size of dialog window *
const short soROWS = 28 ;           // display lines
const short soCOLS = 126 ;          // display columns

//* Control definitions for controls in ThreadTest dialog *
enum soControls : short
{
   soShellPB = ZERO, soDonePB, soShellRB, soPseudoRB,
   soX_RB,  soE_RB,  soP_RB,  soPN_RB,  soEP_RB,  soEPN_RB, 
   soCX_RB, soCE_RB, soCP_RB, soCPN_RB, soCEP_RB, soCEPN_RB,
   soColorDD, soCmdTB, soCmdRB, 
   soControlsDEFINED    // number of controls defined for dialog
} ;

//* Description of Test08, Shell Out test *
class ShellTest
{
   public:
   virtual ~ShellTest ( void ) ;    // destructor
   //* Constructor *
   ShellTest ( short tLines, short tCols, short minY ) ;
   bool soDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void soInteract ( void ) ;       // interact with disgusting, dirty users

   private:
   bool  soOpenDialog ( void ) ;    // open the dialog window

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       minULY ;             // first available display row in termwin
   attr_t      dColor,              // Dialog background color
               bColor ;             // Dialog border color
   bool        soOpen,              // 'true' if dialog opened successfully
               soDone ;
} ;

