//******************************************************************************
//* File       : childApp.cpp                                                  *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2012-2019 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice below.                           *
//* Date       : 02-Oct-2019                                                   *
//*                                                                            *
//* Description: This is a simple application which is invoked by the child    *
//* process generated by a fork()/execxx() in the Salmon test app.             *
//*                                                                            *
//* Compile: g++ -o childApp childApp.cpp -std=gnu++0x -Wall                   *
//*                                                                            *
//* Development tools: See Salmon.cpp                                          *
//******************************************************************************
//* Copyright Notice:                                                          *
//* This program is free software: you can redistribute it and/or modify it    *
//* under the terms of the GNU General Public License as published by the Free *
//* Software Foundation, either version 3 of the License, or (at your option)  *
//* any later version.                                                         *
//*                                                                            *
//* This program is distributed in the hope that it will be useful, but        *
//* WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY *
//* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
//* for more details.                                                          *
//*                                                                            *
//* You should have received a copy of the GNU General Public License along    *
//* with this program.  If not, see <http://www.gnu.org/licenses/>.            *
//*                                                                            *
//******************************************************************************

#include "GlobalDef.hpp"

//** Local Definitions **
static void badInvocation ( void ) ;


//*************************
//*        main           *
//*************************
//******************************************************************************
//* Program entry point.                                                       *
//*                                                                            *
//* Command-line Usage:                                                        *
//*                                                                            *
//* Command Line Arguments:                                                    *
//*                                                                            *
//******************************************************************************

int main ( int argc, char* argv[], char* argenv[] )
{
   int status = ZERO ;        // exit value
   pid_t apid = getpid () ;   // process ID

   if ( argc > 1 )
   {
      char oparg = argv[1][1] ;

      //* 'v' 'l'  'p' and 'f' Options:
      if ( (oparg == 'v') || (oparg == 'l') || (oparg == 'p') || (oparg == 'f') )
      {
         wcout << "childApp: PID: "
               << apid
               << "\n===================="
               << endl ;
         for ( short i = ZERO ; i < argc ; ++i )
            wcout << L"argv[" << i << L"] " << argv[i] << L'\n' ;
         wcout << endl ;
      }

      //* 's' Option: Say hello, then copies argv[2] to stdout *
      //*             and argv[3] to stderr.                   *
      else if ( oparg == 's' )
      {
         wcout << "childApp, PID: "
               << apid
               << "\n===================="
               << endl ;
         wcerr << "childApp, PID: "
               << apid
               << "\n===================="
               << endl ;
         if ( argc > 2 )
            wcout << argv[2] << endl ;
         if ( argc > 3 )
            wcerr << argv[3] << endl ;
      }
      else
      {
         badInvocation () ;
         status = -1 ;
      }
   }
   else
   {
      badInvocation () ;
      status = 1 ;
   }

   exit ( status ) ;

}  //* End main() *

//*************************
//*   badInvocation     *
//*************************
//******************************************************************************
//* If invocation parameters are not as expected, warn the user.               *
//*                                                                            *
//* Input  : none                                                              *
//*                                                                            *
//* Returns: nothing                                                           *
//******************************************************************************

static void badInvocation ( void )
{
   wcout << "childApp: Invoke only as a child process of 'salmon'.\n"
         << "=====================================================\n"
         << endl ;

}  //* End badInvocation() *

