//******************************************************************************
//* File       : NCursesKeyDef.hpp                                             *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2005-2015 Mahlon R. Smith, The Software Samurai *
//*                 GNU GPL copyright notice located in NCurses.hpp            *
//* Date       : 07-Jul-2015                                                   *
//*                                                                            *
//* Description: Key definitions for the NCurses class.                        *
//*              Many definitions are single-code translations of xterm        *
//*              escape sequences captured by the underlying ncurses C code.   *
//*              Others are assigned after capture and translation of ESC      *
//*              sequences by methods in the NCurses class.                    *
//*                                                                            *
//*                                                                            *
//******************************************************************************
//* Programmer's Notes:                                                        *
//* - Translations listed in the ncurses header file ncurses.h are listed in   *
//*   OCTAL. We have no idea why, but we need not follow that foolishness here.*
//*   The maximum keycode value is 0777(octal) == 0x01FF.                      *
//*   The highest keycode actually used is 0633(octal) == 0x019B.              *
//* - Newer versions of ncurses (>= August 2012) also define the keycode group *
//*   0x020D - 0x023A and return these values in response to the received      *
//*   escape sequence.Many of these are related to conditioned arrow/navigation*
//*   keys and conditioned DELETE, INSERT keys.                                *
//*                                                                            *
//*  The pseudo-key 0x0199 == KEY_MOUSE, is a signal that a mouse event        *
//*  has occurred.                                                             *
//*  The pseudo-key 0x019A == KEY_RESIZE, is a signal that the terminal window *
//*  resize event has occurred.                                                *
//*                                                                            *
//* -The ncurses library reserves 64 codes, 0x0108 through 0x0147 for          *
//*  translation of F-key (or other) escape sequences. This chart is for       *
//*  Wintel hardware. If you have a different keyboard layout, then there may  *
//*  be some differences in function-key definition.                           *
//*  F00 == 0x0108 which is not available on most keyboards.                   *
//*  12 are used for the FKey group            (0x0109-0x0114)                 *
//*  12 are used for the Shift+FKey group      (0x0115-0x0120)                 *
//*  12 are used for the Ctrl+FKey group       (0x0121-0x012C)                 *
//*  12 are used for the Ctrl+Shift+FKey group (0x012D-0x0138)                 *
//*  This leaves 15 codes for the NCurses class to use for this purpose.       *
//*                     0x0139 through 0x0147                                  *
//*  The NCurses class, at this time, defines only 0x0139 through 0x013D.      *
//*  Keycodes 0x013E-0x0147 are currently unassigned.                          *
//*                                                                            *
//*  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -   *
//*  Note on the wktEXTEND key type:                                           *
//*  This is an extension to the ncurses C-language library primitives.        *
//*  The GetKeyInput() method captures and translates the escape sequences     *
//*  representing the following key combinations.                              *
//*     'Alt + a'  through  'Alt + z'                                          *
//*       (returned as wkeyCode.type == wktEXTEND and  )                       *
//*       (            wkeyCode.key  == 'a'(nckA_A) through 'z'(nckA_Z))       *
//*       AND                                                                  *
//*     'Alt + Shift + a' through 'Alt + Shift + z'                            *
//*       (returned as wkeyCode.type == wktEXTEND and  )                       *
//*       (            wkeyCode.key  == 'A'(nckAS_A) through 'Z'(nckAS_Z))     *
//*       AND                                                                  *
//*     'Alt + 0'  through  'Alt + 9'                  AND                     *
//*     'Alt + Shift + 0'  through  'Alt + Shift + 9'  AND                     *
//*     'Alt + punctuation' AND 'Alt+Shift+punctuation'                        *
//*       (returned as wkeyCode.type == wktEXTEND and  )                       *
//*       (            wkeyCode.key  == corresponding character)               *
//*       AND                                                                  *
//*     'Alt + Ctrl + a' through 'Alt + Ctrl + z'                              *
//*       (returned as wkeyCode.type == wktEXTEND and  )                       *
//*       (            wkeyCode.key  == 0x01(nckAC_Z) through 0x1A(nckAC_Z))   *
//*  Note: escape sequence for 'Shift+Ctrl+Alt+x' == 'Ctrl+Alt+x', so          *
//*        the 'Shift+Ctrl+Alt+...' group cannot be decoded independently.     *
//*                                                                            *
//*  Example:                                                                  *
//*  --------                                                                  *
//*  Because these keycodes are valid ONLY when the key type == wktEXTEND:     *
//*  wkeyCode  wk ;      // key-input class object                             *
//*  if ( (nc.GetKeyInput ( wk )) == wktEXTEND )                               *
//*  {                                                                         *
//*     switch ( wk.key )                                                      *
//*     {                                                                      *
//*        case  nckA_A:  break ;   // this is Alt+a                           *
//*        case  nckAS_D: break ;   // this is Alt+Shift+d                     *
//*        case  nckAC_Z: break ;   // this is Ctrl+Alt+z                      *
//*     }                                                                      *
//*  }                                                                         *
//*                                                                            *
//* Note that keyboard escape sequences are system dependent. The keyboard     *
//* firmware determines key mapping, and the kernel I/O routines translate     *
//* that map. Therefore the wktEXTEND group is only certified for WinTel       *
//* hardware.                                                                  *
//*  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -   *
//*                                                                            *
//*                                                                            *
//*                                                                            *
//*                                                                            *
//******************************************************************************


//**************************************************************
//* Useful definitions for some of the non-printing characters *
//**************************************************************
// (See also GlobalDef.hpp)
const short nckNULLCHAR = 0x0000 ;     // NULL character (not a valid key code)
const short nckC_A      = 0x0001 ;     // ^A (Ctrl+A)
const short nckC_B      = 0x0002 ;     // ^B
const short nckC_C      = 0x0003 ;     // ^C
const short nckC_D      = 0x0004 ;     // ^D
const short nckC_E      = 0x0005 ;     // ^E
const short nckC_F      = 0x0006 ;     // ^F
const short nckC_G      = 0x0007 ;     // ^G
const short nckC_H      = 0x0008 ;     // ^H
const short nckTAB      = 0x0009 ;     // TAB key (^I)
const short nckENTER    = 0x000A ;     // Linefeed(^J),also Enter/Return(^M)
const short nckNEWLINE  = nckENTER ;
const short nckC_K      = 0x000B ;     // ^K
const short nckC_L      = 0x000C ;     // ^L
                       // 0x000D ;     // ^M (not used in Linux/Unix, see nckENTER)
const short nckC_N      = 0x000E ;     // ^N
const short nckC_O      = 0x000F ;     // ^O
const short nckC_P      = 0x0010 ;     // ^P
const short nckC_Q      = 0x0011 ;     // ^Q
const short nckC_R      = 0x0012 ;     // ^R
const short nckC_S      = 0x0013 ;     // ^S
const short nckC_T      = 0x0014 ;     // ^T
const short nckC_U      = 0x0015 ;     // ^U
const short nckC_V      = 0x0016 ;     // ^V
const short nckC_W      = 0x0017 ;     // ^W
const short nckC_X      = 0x0018 ;     // ^X
const short nckC_Y      = 0x0019 ;     // ^Y
const short nckC_Z      = 0x001A ;     // ^Z
const short nckESC      = 0x001B ;     // Escape key and ^[
const short nckC_4      = 0x001C ;     // ^4 and ^backslash
const short nckC_5      = 0x001D ;     // ^5 and ^] 
const short nckC_6      = 0x001E ;     // ^6 and ^^ 
const short nckC_7      = 0x001F ;     // ^7 and ^_ 

//* Cursor Keys *
const short nckUP       = KEY_UP ;           // Up Arrow
const short nckDOWN     = KEY_DOWN ;         // Down Arrow
const short nckRIGHT    = KEY_RIGHT ;        // Right Arrow
const short nckLEFT     = KEY_LEFT ;         // Left Arrow
const short nckPGUP     = KEY_PPAGE ;        // Page Up
const short nckPGDOWN   = KEY_NPAGE ;        // Page Down
const short nckHOME     = KEY_HOME ;         // Home
const short nckEND      = KEY_END ;          // End

//* Backspace key (0x0107) 
//* Note that in nckpNO_TRANSLATION mode, Backspace is returned as 0x007F 
//* on a PC. This will vary on other hardware flavors
const short nckBKSP     = KEY_BACKSPACE ;

const short nckSPACE    = (SPACE) ;       // space key

//* Terminal resize event (0x019A).
//* When user drags the edges of the terminal window, this keycode is generated*
//* to alert the curses-based application that window size has changed.        *
const short nckRESIZE   = KEY_RESIZE ;

//******************************************************************************
//* Escape sequences translated by the standard ncurses engine using keypad()  *
//* or translated within the NCurses class key input methods.                  *
//* Note: If keypad() in ncurses library translates the key, the associated    *
//* comment will show the hex code translation in parentheses. Otherwise the   *
//* NCurses class translates the sequence.                                     *
//*                                                                            *
//******************************************************************************

//* 1B 5B 5A (0x0161) Shift+TAB (as translated by ncurses library) *
const short nckSTAB     = 0x0161 ;

//* 1B 5B 32 7E (0x014B) Insert (as translated by ncurses library) *
const short nckINSERT   = 0x014B ;
//* 1B 5B 32 3B 33 7E (0x021C) Alt+Insert (as translated by ncurses library) *
const short nckAINSRT   = 0x021C ;

//* 1B 5B 33 7E (0x014A) Delete (as translated by ncurses library) *
const short nckDELETE   = 0x014A ;
//* 1B 5B 33 3B 32 7E (0x017F) Shift+Delete (as translated by ncurses library) *
const short nckSDEL     = 0x017F ;
//* 1B 5B 33 3B 33 7E (0x0209) Control+Delete (as translated by ncurses library) *
const short nckCDEL     = 0x0209 ;
//* 1B 5B 33 3B 36 7E (0x020A) Control+Shift+Delete (as translated by ncurses library)*
const short nckCSDEL    = 0x020A ;
//* 1B 5B 33 3B 35 7E (0x0207) Alt+Delete (as translated by ncurses library)*
const short nckADEL     = 0x0207 ;
//* 1B 5B 33 3B 34 7E (0x0208) Alt+Shift+Delete (as translated by ncurses library) *
const short nckASDEL    = 0x0208 ;

//* Conditioned Arrow Keys *
//* (as translated by ncurses library) // Escape Sequence (hex bytes)
const short nckSUP      = 0x0151 ;     // 1B 5B 31 3B 32 41 (Shift+Up Arrow)
const short nckSDOWN    = 0x0150 ;     // 1B 5B 31 3B 32 42 (Shift+Down Arrow)
const short nckSRIGHT   = 0x0192 ;     // 1B 5B 31 3B 32 43 (Shift+Right Arrow)
const short nckSLEFT    = 0x0189 ;     // 1B 5B 31 3B 32 44 (Shift+Left Arrow)
const short nckAUP      = 0x0236 ;     // 1B 5B 31 3B 33 41 (Alt+Up Arrow)
const short nckADOWN    = 0x020D ;     // 1B 5B 31 3B 33 42 (Alt+Down Arrow)
const short nckARIGHT   = 0x0230 ;     // 1B 5B 31 3B 33 43 (Alt+Right Arrow)
const short nckALEFT    = 0x0221 ;     // 1B 5B 31 3B 33 44 (Alt+Left Arrow)
const short nckASUP     = 0x0237 ;     // 1B 5B 31 3B 34 41 (Shift+Alt+Up Arrow)
const short nckASDOWN   = 0x020E ;     // 1B 5B 31 3B 34 42 (Shift+Alt+Down Arrow)
const short nckASRIGHT  = 0x0231 ;     // 1B 5B 31 3B 34 43 (Shift+Alt+Right Arrow)
const short nckASLEFT   = 0x0222 ;     // 1B 5B 31 3B 34 44 (Shift+Alt+Left Arrow)
const short nckCUP      = 0x0238 ;     // 1B 5B 31 3B 35 41 (Control+Up Arrow)
const short nckCDOWN    = 0x020F ;     // 1B 5B 31 3B 35 42 (Control+Down Arrow)
const short nckCRIGHT   = 0x0232 ;     // 1B 5B 31 3B 35 43 (Control+Right Arrow)
const short nckCLEFT    = 0x0223 ;     // 1B 5B 31 3B 35 44 (Control+Left Arrow)
const short nckCSRIGHT  = 0x0233 ;     // 1B 5B 31 3B 36 43 (Shift+Control+Right Arrow)
const short nckCSLEFT   = 0x0224 ;     // 1B 5B 31 3B 36 44 (Shift+Control+Left Arrow)
const short nckAPGUP    = 0x022B ;     // 1B 5B 35 3B 33 7E (Alt+PageUp)
const short nckAPGDOWN  = 0x0226 ;     // 1B 5B 36 3B 33 7E (Alt+PageDown)

//* Basic Function Keys *
//* (as translated by ncurses library) // Escape Sequence (hex bytes)
const short nckF01      = KEY_F(1) ;   // [captured by Gnome Terminal by default (Help window)]
const short nckF02      = KEY_F(2) ;   // 1B 4F 51 (0x010A) 
const short nckF03      = KEY_F(3) ;   // 1B 4F 52 (0x010B) (^K)
const short nckF04      = KEY_F(4) ;   // 1B 4F 53 (0x010C) (^L)
const short nckF05      = KEY_F(5) ;   // 1B 5B 31 35 7E (0x010D) 
const short nckF06      = KEY_F(6) ;   // 1B 5B 31 37 7E (0x010E) (^N)
const short nckF07      = KEY_F(7) ;   // 1B 5B 31 38 7E (0x010F) (^O)
const short nckF08      = KEY_F(8) ;   // 1B 5B 31 39 7E (0x0110) (^P)
const short nckF09      = KEY_F(9) ;   // 1B 5B 32 30 7E (0x0111) (^Q)
const short nckF10      = KEY_F(10) ;  // 1B 5B 32 31 7E (0x0112) (^R) [captured by Gnome Terminal by default]
const short nckF11      = KEY_F(11) ;  // 0xFFFF + 0x019A [processed-but-passed through by Gnome Terminal by default]
const short nckF12      = KEY_F(12) ;  // 1B 5B 32 34 7E (0x0114) (^T)

//* Shift + Function Keys *
//* (as translated by ncurses library) // Escape Sequence (hex bytes)
const short nckSF01     = 0x0115 ;     // 1B 4F 31 3B 32 50
const short nckSF02     = 0x0116 ;     // 1B 4F 31 3B 32 51
const short nckSF03     = 0x0117 ;     // 1B 4F 31 3B 32 52
const short nckSF04     = 0x0118 ;     // 1B 4F 31 3B 32 53
const short nckSF05     = 0x0119 ;     // 1B 5B 31 35 3B 32 7E (0x0119) (^Y) 
const short nckSF06     = 0x011A ;     // 1B 5B 31 37 3B 32 7E (0x011A) (^Z)
const short nckSF07     = 0x011B ;     // 1B 5B 31 38 3B 32 7E (0x011B) (^[)
const short nckSF08     = 0x011C ;     // 1B 5B 31 39 3B 32 7E (0x011C) (^\)
const short nckSF09     = 0x011D ;     // 1B 5B 32 30 3B 32 7E (0x011D) (^])
const short nckSF10     = 0x011E ;     // 1B 5B 32 31 3B 32 7E (0x011E) (^^) [captured by Gnome Terminal by default]
const short nckSF11     = 0x011F ;     // 1B 5B 32 33 3B 32 7E (0x011F) (^_)
const short nckSF12     = 0x0120 ;     // 1B 5B 32 34 3B 32 7E (0x0120) 

//* Control + Function Keys *
//* (as translated by ncurses library) // Escape Sequence (hex bytes)
const short nckCF01     = 0x0121 ;     // [not seen by Gnome Terminal]
const short nckCF02     = 0x0122 ;     // 1B 4F 31 3B 35 51 
const short nckCF03     = 0x0123 ;     // 1B 4F 31 3B 35 52 
const short nckCF04     = 0x0124 ;     // 1B 4F 31 3B 35 53 
const short nckCF05     = 0x0125 ;     // 1B 5B 31 35 3B 35 7E (0x0125) 
const short nckCF06     = 0x0126 ;     // 1B 5B 31 37 3B 35 7E (0x0126) 
const short nckCF07     = 0x0127 ;     // 1B 5B 31 38 3B 35 7E (0x0127) 
const short nckCF08     = 0x0128 ;     // 1B 5B 31 39 3B 35 7E (0x0128) 
const short nckCF09     = 0x0129 ;     // 1B 5B 32 30 3B 35 7E (0x0129) 
const short nckCF10     = 0x012A ;     // 1B 5B 32 31 3B 35 7E (0x012A) 
const short nckCF11     = 0x012B ;     // 1B 5B 32 33 3B 35 7E (0x012B) 
const short nckCF12     = 0x012C ;     // 1B 5B 32 34 3B 35 7E (0x012C) 

//* Control + Shift + Function Keys *  
//* (as translated by ncurses library) // Escape Sequence (hex bytes)
const short nckCSF01    = 0x012D ;     // 1B 4F 31 3B 36 50
const short nckCSF02    = 0x012E ;     // 1B 4F 31 3B 36 51 
const short nckCSF03    = 0x012F ;     // 1B 4F 31 3B 36 52 
const short nckCSF04    = 0x0130 ;     // 1B 4F 31 3B 36 53 
const short nckCSF05    = 0x0131 ;     // 1B 5B 31 35 3B 36 7E (0x0131) 
const short nckCSF06    = 0x0132 ;     // 1B 5B 31 37 3B 36 7E (0x0132)
const short nckCSF07    = 0x0133 ;     // 1B 5B 31 38 3B 36 7E (0x0133)
const short nckCSF08    = 0x0134 ;     // 1B 5B 31 39 3B 36 7E (0x0134)
const short nckCSF09    = 0x0135 ;     // 1B 5B 32 30 3B 36 7E (0x0135)
const short nckCSF10    = 0x0136 ;     // 1B 5B 32 31 3B 36 7E (0x0136)
const short nckCSF11    = 0x0137 ;     // 1B 5B 32 33 3B 36 7E (0x0137)
const short nckCSF12    = 0x0138 ;     // 1B 5B 32 34 3B 36 7E (0x0138)

//* Numeric Keypad (for keyboards that have a built-in numeric keypad)         *
//*  Note: some escape sequences for 'Ctrl+x' == 'Alt+x' == 'Ctrl+Alt+x',      *
//*        so these cannot be decoded independently.                           *
//* (as translated by NCurses class)   // Escape Sequence (hex bytes)          *
const short nckpCENTER  = 0x0139 ;     // 1B 5B 45    (keypad '5' key)
const short nckpPLUS    = 0x013A ;     // 1B 4F 6B    (keypad '+' key)
const short nckpMINUS   = 0x013B ;     // 1B 4F 6D    (keypad '-' key)
const short nckpMULT    = 0x013C ;     // 1B 4F 6A    (keypad '*' key)
const short nckpDIV     = 0x013D ;     // 1B 4F 6F    (keypad '/' key)
const short nckpHOME    = nckHOME ;    // 1B 5B 31 7E (keypad 'Home' key)
const short nckpEND     = nckEND ;     // 1B 5B 34 7E (keypad 'End' key)

//* These codes remain available for assignment within the wktFUNKEY group.*
//const short nckUNASSIGNED = 0x013E ;   // 
//const short nckUNASSIGNED = 0x013F ;   // 
//const short nckUNASSIGNED = 0x0140 ;   // 
//const short nckUNASSIGNED = 0x0141 ;   // 
//const short nckUNASSIGNED = 0x0142 ;   // 
//const short nckUNASSIGNED = 0x0143 ;   // 
//const short nckUNASSIGNED = 0x0144 ;   // 
//const short nckUNASSIGNED = 0x0145 ;   // 
//const short nckUNASSIGNED = 0x0146 ;   // 
//const short nckUNASSIGNED = 0x0147 ;   // 


//* Numeric Keypad (for keyboards that have a built-in numeric keypad)         *
//*  Note: Keypad keycodes for Up, Down, Right, Left, PgUp, PgDn are the same  *
//*        as the equivalent main keyboard keys.                               *
//*  Note: If 'Numlock' key is OFF, or if 'Numlock' key is ON and 'Shift' key  *
//*        pressed, then keypad produces ASCII characters instead.             *
//* (as translated by ncurses library) // Escape Sequence (hex bytes)          *
const short nckpENTER   = 0x0157 ;     // (none - ASCII LINEFEED (0x0A)
const short nckpAPGDN   = 0x0226 ;     // 01B 05B 036 03B 033 07E
const short nckpAPGUP   = 0x022B ;     // 01B 05B 035 03B 033 07E
const short nckpCPGDN   = 0x0228 ;     // 01B 05B 036 03B 035 07E
const short nckpCPGUP   = 0x022D ;     // 01B 05B 035 03B 035 07E
const short nckpACUP    = 0x023A ;     // 01B 05B 031 03B 037 041
const short nckpACDOWN  = 0x0211 ;     // 01B 05B 031 03B 037 042
const short nckpACRIGHT = 0x0234 ;     // 01B 05B 031 03B 037 043
const short nckpACLEFT  = 0x0225 ;     // 01B 05B 031 03B 037 044
const short nckpACPGDN  = 0x022A ;     // 01B 05B 036 03B 037 07E
const short nckpACPGUP  = 0x022F ;     // 01B 05B 035 03B 037 07E
const short nckpACDEL   = 0x020B ;     // 01B 05B 033 03B 037 07E


//* wktEXTEND group of keycode definitions.                                    *
//* These keycodes are valid ONLY if key type == wktEXTEND. See example in     *
//* module header above.                                                       *
const short nckA_A      = 'a' ;
const short nckA_B      = 'b' ;
const short nckA_C      = 'c' ;
const short nckA_D      = 'd' ;
const short nckA_E      = 'e' ;
const short nckA_F      = 'f' ;
const short nckA_G      = 'g' ;
const short nckA_H      = 'h' ;
const short nckA_I      = 'i' ;
const short nckA_J      = 'j' ;
const short nckA_K      = 'k' ;
const short nckA_L      = 'l' ;
const short nckA_M      = 'm' ;
const short nckA_N      = 'n' ;
const short nckA_O      = 'o' ;
const short nckA_P      = 'p' ;
const short nckA_Q      = 'q' ;
const short nckA_R      = 'r' ;
const short nckA_S      = 's' ;
const short nckA_T      = 't' ;
const short nckA_U      = 'u' ;
const short nckA_V      = 'v' ;
const short nckA_W      = 'w' ;
const short nckA_X      = 'x' ;
const short nckA_Y      = 'y' ;
const short nckA_Z      = 'z' ;

const short nckA_0      = '0' ;
const short nckA_1      = '1' ;
const short nckA_2      = '2' ;
const short nckA_3      = '3' ;
const short nckA_4      = '4' ;
const short nckA_5      = '5' ;
const short nckA_6      = '6' ;
const short nckA_7      = '7' ;
const short nckA_8      = '8' ;
const short nckA_9      = '9' ;

const short nckAS_A     = 'A' ;
const short nckAS_B     = 'B' ;
const short nckAS_C     = 'C' ;
const short nckAS_D     = 'D' ;
const short nckAS_E     = 'E' ;
const short nckAS_F     = 'F' ;
const short nckAS_G     = 'G' ;
const short nckAS_H     = 'H' ;
const short nckAS_I     = 'I' ;
const short nckAS_J     = 'J' ;
const short nckAS_K     = 'K' ;
const short nckAS_L     = 'L' ;
const short nckAS_M     = 'M' ;
const short nckAS_N     = 'N' ;
const short nckAS_O     = 'O' ;
const short nckAS_P     = 'P' ;
const short nckAS_Q     = 'Q' ;
const short nckAS_R     = 'R' ;
const short nckAS_S     = 'S' ;
const short nckAS_T     = 'T' ;
const short nckAS_U     = 'U' ;
const short nckAS_V     = 'V' ;
const short nckAS_W     = 'W' ;
const short nckAS_X     = 'X' ;
const short nckAS_Y     = 'Y' ;
const short nckAS_Z     = 'Z' ;

const short nckAS_0     = ')' ;
const short nckAS_1     = '!' ;
const short nckAS_2     = '@' ;
const short nckAS_3     = '#' ;
const short nckAS_4     = '$' ;
const short nckAS_5     = '%' ;
const short nckAS_6     = '^' ;
const short nckAS_7     = '&' ;
const short nckAS_8     = '*' ;
const short nckAS_9     = '(' ;

const short nckAS_SPC   = ' ' ;  // NOTE: multiple key combinations yield this code
const short nckA_DUBL   = '"' ;
const short nckA_SING   = '\'' ;
const short nckA_PLUS   = '+' ;
const short nckA_COMM   = ',' ;
const short nckA_MINU   = '-' ;
const short nckA_STOP   = '.' ;
const short nckA_FSTR   = '/' ;
const short nckA_COLO   = ':' ;
const short nckA_SEMI   = ';' ;
const short nckA_LCHV   = '<' ;
const short nckA_EQUL   = '=' ;
const short nckA_RCHV   = '>' ;
const short nckA_QUES   = '?' ;
const short nckA_LBRK   = '[' ;
const short nckA_BSTR   = '\\' ;
const short nckA_RBRK   = ']' ;
const short nckA_UNDR   = '_' ;
const short nckA_GRAV   = '`' ;
const short nckA_LBRC   = '{' ;
const short nckA_VBAR   = '|' ;
const short nckA_RBRC   = '}' ;
const short nckA_TILD   = '~' ;

const short nckAC_A     = 0x01 ;
const short nckAC_B     = 0x02 ;
const short nckAC_C     = 0x03 ;
const short nckAC_D     = 0x04 ;
const short nckAC_E     = 0x05 ;
const short nckAC_F     = 0x06 ;
const short nckAC_G     = 0x07 ;
const short nckAC_H     = 0x08 ;
const short nckAC_I     = 0x09 ;
const short nckAC_J     = 0x0A ;
const short nckAC_K     = 0x0B ;
const short nckAC_L     = 0x0C ;
const short nckAC_M     = 0x0D ;
const short nckAC_N     = 0x0E ;
const short nckAC_O     = 0x0F ;
const short nckAC_P     = 0x10 ;
const short nckAC_Q     = 0x11 ;
const short nckAC_R     = 0x12 ;
const short nckAC_S     = 0x13 ;
const short nckAC_T     = 0x14 ;
const short nckAC_U     = 0x15 ;
const short nckAC_V     = 0x16 ;
const short nckAC_W     = 0x17 ;
const short nckAC_X     = 0x18 ;
const short nckAC_Y     = 0x19 ;
const short nckAC_Z     = 0x1A ;


