//******************************************************************************
//* File       : TagDialog.hpp                                                 *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2016-2020 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in Taggit.hpp            *
//* Date       : 16-Dec-2019                                                   *
//* Version    : (see AppVersion string)                                       *
//*                                                                            *
//* Description: This header contains the application dialog's text data as    *
//* translated for each supported user-interface language.                     *
//*                                                                            *
//*                                                                            *
//******************************************************************************
//* Version History (see Taggit.cpp).                                          *
//******************************************************************************


//****************
//* Header Files *
//****************


//** User interface control names **
enum topWinControls : short
{
   twSavePB = ZERO,        // 'Save All' Pushbutton
   twFileMW,               // 'File' Menu
   twEditMW,               // 'Edit' Menu
   twViewMW,               // 'View' Menu
   twHelpMW,               // 'Help' Menu
   twSortMW,               // 'Sort' Sub-menu
   twCTRLS                 // number of UI controls defined
} ;


//* Offset for field window *
const short fieldwinY = 4,
            fieldwinX = FNAME_WIN_WIDTH + 1 ;
//* Offsets for column headers *
const short headerROW = fieldwinY + 1,
            filehdrCOL = 2,
            metahdrCOL = fieldwinX + 2 ;


//***************************************************
//* Menu selections returned from menuing subsystem *
//***************************************************
enum MenuCode : short
{
   //* GENERAL    *
   mcNO_SELECTION,                  //* Menu closed without a selection,
   mcHANDLED,                       //* Selection handled before return
   mcSYSERROR,                      //* If system call returned an error

   //* FILE MENU  *
   mcFileMB_SAVEALL,                //* Save metadata for all files
   mcFileMB_SAVEFILE,               //* Save metadata for highlighted file
   mcFileMB_SAVEAS,                 //* Save (with rename) for highlighted file
   mcFileMB_SAVEAUDIO,              //* Save audio only for highlighted file
   mcFileMB_SUMMARY,                //* Write metadata summary to a (text) file
   mcFileMB_PLAYBACK,               //* Open the default media player for playback
   mcFileMB_REFRESH,                //* Refresh display data: reread all source files
   mcFileMB_SHELL,                  //* go to command shell
   mcFileMB_EXIT,                   //* exit the application

   //* EDIT MENU  *
   mcEditMB_FILENAME,               //* Edit filename of highlighted item
   mcEditMB_METADATA,               //* Edit metadata tag fields of highlighted item
   mcEditMB_IMAGE,                  //* Add/modify an image tag for highlighted item
   mcEditMB_IEDIT,                  //* Edit stats for an existing image tag
   mcEditMB_REFRESH,                //* Refresh display data: reread highlighted file
   mcEditMB_TRACKFILL,              //* Auto-fill track (tfTRCK) field
   mcEditMB_DUPLICATE,              //* Duplicate contents of a field to all files
   mcEditMB_SETTITLE,               //* For all files, set Title field from filename
   mcEditMB_POPMETER,               //* Popularimeter and Play counter
   mcEditMB_CLEARFILE,              //* Clear (erase) all metadata fields for file
   mcEditMB_CLEARALL,               //* Clear (erase) all metadata from all files
   mcEditMB_PREFS,                  //* request to open Preferences dialog

   //* VIEW MENU  *
   mcViewMB_FSELECT,                //* Set all text tag fields active
   mcViewMB_SUMMARY,                //* View metadata summary for file(s)
   mcViewMB_SORTLIST,               //* Sort the file list
   mcViewMB_SHIFTDOWN,              //* Move highlighted file downward in list
   mcViewMB_SHIFTUP,                //* Move highlighted file upward in list
   mcViewMB_FREESPACE,              //* Report the target free space
   mcViewMB_IMAGE,                  //* View embedded-image data
   mcViewMB_TOGGLE,                 //* Toggle LTR/RTL field contents
   mcViewMB_CSCHEME,                //* Set the dialog color scheme

   //* HELP MENU  *
   mcHelpMB_F01HELP,                //* Request to open info reader help
   mcHelpMB_HTML,                   //* Request to open browser help
   mcHelpMB_QUICKHELP,              //* Display help summary
   mcHelpMB_HELPABOUT,              //* Display Help-about dialog

   //* SORT-BY SUB-MENU *
   mcSortMB_FNAME,                  //* Sort by 'Filename'
   mcSortMB_TITLE,                  //* Sort by 'Title' field
   mcSortMB_ALBUM,                  //* Sort by 'Album' field
   mcSortMB_TRACK,                  //* Sort by 'Track' field
   mcSortMB_ARTIST,                 //* Sort by 'Artist' field
} ;


//*********************************
//** User interface control text **
//*********************************

// Programmer's Note: Characters, bytes and columns ARE NOT THE SAME THING!
// Please be aware that: 
//    a) all text output is based on display columns required
//    b) storing a character may require more than one byte
//    c) displaying a character may require more than one column
// For these reasons, we define the large, complex arrays in this header as 
// arrays of char pointers rather than as multidimensional char arrays.
// Always test and double-test the output.

const short COLLAPSED_WIDTH = 12 ;  // Width of collapsed menus
const short MENU_COUNT = 4 ;        // Number of menus in menu bar

//** Menu Names **
const char* const MenuName[][MENU_COUNT] = 
{
   {  // English
      "    File    ",
      "    Edit    ",
      "    View    ",
      "    Help    ",
   },
   {  // Espanol
      "  Archivo   ",
      "  Corregir  ",
      "  Examinar  ",
      " Asistencia ",
   },
   {  // Zhongwen
      "    文件    ",
      "    修正    ",
      "    查看    ",
      "    帮助    ",
   },  
   {  // TiengViet
      "  Tập Tin   ",
      " Chỉnh Sửa  ",
      "  Xem Xét   ",
      "   Hỗ Trợ   ",
   },
} ;

// 'File' Menu item text *
const short FMW_ITEMS =  9 ;     // 'File' menu items
const short FMW_COLS  = 29 ;     // 'File' menu columns (incl. borders)
const char Fmw_Text_EN[FMW_ITEMS][FMW_COLS + 1] = // 'File' menu text (English)
{
   " Save ALL Files            ",
   " Save File              C+S",
   " Save File As          AC+S",
   " Save Audio Data Only      ",
   " Save Tag Summary          ",
   " Play the Current File  C+P",
   " Refresh Displayed Data    ",
   " Command Shell             ",
   " Exit                   C+^Q",
} ;
const char Fmw_Text_ES[FMW_ITEMS][FMW_COLS + 1] = // 'File' menu text (Espanol)
{
   " Guardar Todo              ",   // Save ALL Files
   " Guardar Archivo        C+S",   // Save File
   " Guardar Con Renombrar AC+S",   // Save File As
   " Guardar solo audio        ",   // Save Audio Data Only
   " Escribir Resumen          ",   // Save Tag Summary
   " Reproducir archivo actual ",   // Playback
   " Refrescar los Datos       ",   // Refresh (reread) all displayed data
   " Programa de Comandos      ",   // Command Shell
   " Salida                 C+^Q",  // Exit
} ;
const char Fmw_Text_ZH[FMW_ITEMS][FMW_COLS + 8] = // 'File' menu text (Zhongwen)
{
   " 保存所有修改的文件        ",      // Save ALL Files
   " 保存存档               C+S",    // Save File
   " 用重命名保存          AC+S",     // Save File As
   " 仅保存音频数据            ",     // Save Audio Data Only
   " 写标签摘要                ",     // Save Tag Summary
   " 播放当前文件           C+P",     // Playback
   " 再次读取源数据            ",       // Refresh (reread) all displayed data
   " 转到命令程序              ",      // Command Shell
   " 出口                   C+^Q",   // Exit
} ;
const char Fmw_Text_VI[FMW_ITEMS][FMW_COLS + 10] = // 'File' menu text (TiengViet)
{
   " Lưu Tất Cả Dữ Liệu        ",   // Save ALL Files
   " Lưu Tập Tin            C+S",   // Save File
   " Lưu Với Tên Mới       AC+S",   // Save File As
   " Chỉ Lưu Dữ Liệu âm Thanh  ",   // Save Audio Data Only
   " Tóm Tắt Ghi Dữ Liệu       ",   // Save Tag Summary
   " Phát tệp hiện tại      C+P",   // Playback
//   " Đọc Lại Lần Nữa Tập Tin   ",   // Refresh (reread) all displayed data
   " Làm mới tất cả các Tệp    ",   // Refresh (reread) all displayed data
   " Tới Dấu Nhắc Lệnh         ",   // Command Shell
   " Ly Khai                C+^Q",   // Exit
} ;
const MenuCode mbFileCodes[FMW_ITEMS] = 
{
   mcFileMB_SAVEALL,                //* Save metadata for all files
   mcFileMB_SAVEFILE,               //* Save metadata for highlighted file
   mcFileMB_SAVEAS,                 //* Save (with rename) for highlighted file
   mcFileMB_SAVEAUDIO,              //* Save audio only for highlighted file
   mcFileMB_SUMMARY,                //* Write metadata summary to a (text) file
   mcFileMB_PLAYBACK,               //* Open the default media player for playback
   mcFileMB_REFRESH,                //* Refresh display data: reread all source files
   mcFileMB_SHELL,                  //* go to command shell
   mcFileMB_EXIT,                   //* exit the application
} ;


// 'Edit' Menu item text *
const short EMW_ITEMS = 12 ;     // 'Edit' menu items
const short EMW_COLS  = 35 ;     // 'Edit' menu columns (incl. borders)
const char Emw_Text_EN[EMW_ITEMS][EMW_COLS + 1] = // 'Edit' menu text (English)
{
   " Edit Filename                A+N",
   " Edit Metadata                A+M",
   " Add Image File              AC+I",
   " Edit Image Stats            AC+E",
   " Undo Tag Edits               C+Z",
   " Autofill Track Data          C+T",
   " Duplicate Field              C+D",
   " Set Song Title                  ",
   " Popularity and Play Counter     ",
   " Clear File Metadata             ",
   " Clear All Metadata              ",
   " Edit Preferences                ",
} ;
const char Emw_Text_ES[EMW_ITEMS][EMW_COLS + 2] = // 'Edit' menu text (Espanol)
{                  
   " Editar nombre de archivo     A+N",
   " Editar Los Metadatos         A+M",
   " Añadir Una Imagen           AC+I",
   " Editar Estadísticas Imagen  AC+E",
   " Anular Ediciones             C+Z",
   " Pista Relleno Automático     C+T",
   " Duplicar un Campo            C+D",
   " Ajustar el Título de la Canción ",
   " Popularidad y Contador Repetir  ",
   " Borrar los Metadatos del Archivo",
   " Borrar Todos los Metadatos      ",
   " Editar Preferencias             ",
} ;
const char Emw_Text_ZH[EMW_ITEMS][EMW_COLS + 12] = // 'Edit' menu text (Zhongwen)
{
   " 编辑文件名                   A+N",
   " 编辑元数据                   A+M",
   " 添加一个图像文件            AC+I",
   " 编辑图像统计信息            AC+E",
   " 撤消文件编辑                 C+Z",
   " 自动设置轨道号               C+T",
   " 将数据字段复制到所有文件     C+D",
   " 设置歌曲标题                    ",
   " 声望 以及 回放 计数器           ",
   " 擦除当前文件的元数据            ",
   " 擦除所有文件的元数据            ",
   " 编辑偏好设置                    ",
} ;
const char Emw_Text_VI[EMW_ITEMS][EMW_COLS + 12] = // 'Edit' menu text (TiengViet)
{
   " Chỉnh sửa tên tệp            A+N",
   " Chỉnh sửa siêu dữ liệu       A+M",
   " Chèn một tệp hình ảnh       AC+I",
   " Chỉnh sửa thống kê hình ảnh AC+E",
   " Hoàn tác thay đổi            C+Z",
   " Chèn số bài hát tự động      C+T",
   " Nhân đôi dữ liệu hiện trường C+D",
   " Đặt tiêu đề bài hát             ",
   " Sự nổi tiếng và số lần phát     ",
   " Xóa siêu dữ liệu cho tệp        ",
   " Xóa siêu dữ liệu tất các cả tệp ",
   " Chỉnh sửa sự thích              ",
} ;
const MenuCode mbEditCodes[EMW_ITEMS] = 
{
   mcEditMB_FILENAME,   //* Edit filename of highlighted item
   mcEditMB_METADATA,   //* Edit metadata tag fields of highlighted item
   mcEditMB_IMAGE,      //* Add/modify an image tag for highlighted item
   mcEditMB_IEDIT,      //* Edit stats for an existing image tag
   mcEditMB_REFRESH,    //* Refresh display data: reread highlighted file
   mcEditMB_TRACKFILL,  //* Auto-fill track (tfTRCK) field
   mcEditMB_DUPLICATE,  //* Duplicate contents of a field to all files
   mcEditMB_SETTITLE,   //* For all files, set Title field from filename
   mcEditMB_POPMETER,   //* Popularimeter and Play counter
   mcEditMB_CLEARFILE,  //* Clear (erase) all metadata fields for file
   mcEditMB_CLEARALL,   //* Clear (erase) all metadata from all files
   mcEditMB_PREFS,      //* request to open Preferences dialog
} ;


// 'View' Menu item text *
const short VMW_ITEMS =  9 ;     // 'View' menu items
const short VMW_COLS  = 26 ;     // 'View' menu columns (incl. borders)
const char Vmw_Text_EN[VMW_ITEMS][VMW_COLS + 1] = // 'View' menu text (English)
{
   " Set all Fields Active  ",   //* Set all text tag fields active
   " View Tag Data Summary  ",   //* View metadata summary for file
   " Sort File List        >",   //* Sort the list according to selected criterion
   " Shift File Down    A+DN",   //* Move highlighted file downward in list
   " Shift File Up      A+UP",   //* Move highlighted file upward in list
   " Target Free Space      ",   //* Report the target free space
   " View Image Data     A+I",   //* View embedded-image data
   " RTL InvertFieldData C+R",   //* Toggle LTR/RTL field contents
   " Set Color Scheme       ",   //* Set the dialog color scheme
} ;
const char Vmw_Text_ES[VMW_ITEMS][VMW_COLS + 1] = // 'View' menu text (Espanol)
{
   " Activar todos campos   ",   //* Set all text tag fields active
   " Ver Resumen de Datos   ",   //* View metadata summary for file
   " Ordenar por...        >",   //* Sort the list according to selected criterion
   " Mover Hacia Abajo  A+DN",   //* Move highlighted file downward in list
   " Mover Hacia Arriba A+UP",   //* Move highlighted file upward in list
   " Espacio Libre de Medios",   //* Report the target free space
   " Ver Datos de Imagen A+I",   //* View embedded-image data
   " RTL Invertir Datos  C+R",   //* Toggle LTR/RTL field contents
   " Elegir esquema de color",   //* Set the dialog color scheme
} ;
const char Vmw_Text_ZH[VMW_ITEMS][VMW_COLS + 9] = // 'View' menu text (Zhongwen)
{
   " 所有字段都是活动的     ",      //* Set all text tag fields active
   " 查看元数据摘要         ",     //* View metadata summary for file
   " 选择排序选项          >",     //* Sort the list according to selected criterion
   " 向下移动文件       A+DN",     //* Move highlighted file downward in list
   " 向上移动文件       A+UP",     //* Move highlighted file upward in list
   " 目标盘上的可用空间     ",      //* Report the target free space
   " 查看图像数据        A+I",     //* View embedded-image data
   " RTL 反转数据方向    C+R",     //* Toggle LTR/RTL field contents
   " 设置颜色方案           ",     //* Set the dialog color scheme
} ;
const char Vmw_Text_VI[VMW_ITEMS][VMW_COLS + 8] = // 'View' menu text (TiengViet)
{
   " kích hoạt cả các trường",   //* Set all text tag fields active
   " Xem tóm tắt dữ liệu    ",   //* View metadata summary for file
   " Sắp xếp theo          >",   //* Sort the list according to selected criterion
   " Di chuyển tệpxuống A+DN",   //* Move highlighted file downward in list
   " Di chuyển tệp lên  A+UP",   //* Move highlighted file upward in list
   " Không gian sẵn có      ",   //* Report the target free space
   " Xem dữliệu hình ảnh A+I",   //* View embedded-image data
   " RTL Hướng Nghịch    C+R",   //* Toggle LTR/RTL field contents
   " Thiết lập bảng màu     ",   //* Set the dialog color scheme
} ;                           
const MenuCode mbViewCodes[VMW_ITEMS] = 
{
   mcViewMB_FSELECT,    //* Set all text tag fields active
   mcViewMB_SUMMARY,    //* View metadata summary for file
   mcViewMB_SORTLIST,   //* Sort the file list
   mcViewMB_SHIFTDOWN,  //* Move highlighted file downward in list
   mcViewMB_SHIFTUP,    //* Move highlighted file upward in list
   mcViewMB_FREESPACE,  //* Report the target free space
   mcViewMB_IMAGE,      //* View embedded-image data
   mcViewMB_TOGGLE,     //* Toggle LTR/RTL field contents
   mcViewMB_CSCHEME,    //* Set the dialog color scheme
} ;


// 'Help' Menu item text *
const short HMW_ITEMS =  4 ;     // 'Help' menu items
const short HMW_COLS  = 22 ;     // 'Help' menu columns (incl. borders)
const char Hmw_Text_EN[HMW_ITEMS][HMW_COLS + 1] = // 'Help' menu text (English)
{
   " Taggit Help        ",
   " Help  (HTML)       ",
   " Quick Help         ",
   " About Taggit       ",
} ;
const char Hmw_Text_ES[HMW_ITEMS][HMW_COLS + 1] = // 'Help' menu text (Espanol)
{
   " Ayuda Para Taggit  ",
   " Ayuda  (HTML)      ",
   " Ayuda Rapida       ",
   " Acerca del Programa",
} ;
const char Hmw_Text_ZH[HMW_ITEMS][HMW_COLS + 3] = // 'Help' menu text (Zhongwen)
{
   " Taggit 帮助文档    ",
   " 帮助 (HTML)        ",
   " 快速帮助           ",
   " 关于 Taggit        ",
} ;
const char Hmw_Text_VI[HMW_ITEMS][HMW_COLS + 2] = // 'Help' menu text (TiengViet)
{
   " Taggit Trợ Giúp    ",
   " Trợ Giúp (HTML)    ",
   " Trợ Giúp Nhanh     ",
   " Về Taggit          ",
} ;
const MenuCode mbHelpCodes[HMW_ITEMS] = 
{
   mcHelpMB_F01HELP,    //* Request to open info reader help
   mcHelpMB_HTML,       //* Request to open browser help
   mcHelpMB_QUICKHELP,  //* Display help summary
   mcHelpMB_HELPABOUT,  //* Display Help-about dialog
} ;

// 'Sort' Sub-menu item text *
const short SMW_ITEMS =  5 ;     // 'Sort' menu items
const short SMW_COLS  = 18 ;     // 'Sort' menu columns (incl. borders)
const char Smw_Text_EN[SMW_ITEMS][SMW_COLS + 1] = // 'Sort' menu text (English)
{
   " Filename       ",
   " Title          ",
   " Album          ",
   " Track          ",
   " Artist         ",
} ;
const char Smw_Text_ES[SMW_ITEMS][SMW_COLS + 1] = // 'Sort' menu text (Espanol)
{
   " Nombre archivo ",
   " Título         ",
   " Álbum          ",
   " Pista          ",
   " Artista        ",
} ;
const char Smw_Text_ZH[SMW_ITEMS][SMW_COLS + 2] = // 'Sort' menu text (Zhongwen)
{
   " 文件名         ",
   " 标题           ",
   " 专辑           ",
   " 个音轨         ",
   " 演员           ",
} ;
const char Smw_Text_VI[SMW_ITEMS][SMW_COLS + 6] = // 'Sort' menu text (TiengViet)
{
   " Tên Tập Tin    ",
   " Tên Bài Hát    ",
   " Tập ảnh        ",
   " Bài Nhạc       ",
   " Nghệ Sĩ Thu âm ",
} ;
const MenuCode mbSortCodes[SMW_ITEMS] = 
{
   mcSortMB_FNAME,                  //* Sort by 'Filename'
   mcSortMB_TITLE,                  //* Sort by 'Title' field
   mcSortMB_ALBUM,                  //* Sort by 'Album' field
   mcSortMB_TRACK,                  //* Sort by 'Track' field
   mcSortMB_ARTIST,                 //* Sort by 'Artist' field
} ;

//* Save-all Pushbutton *
const short SAPB_COLS  = 26 ;    // 'Save-All' Pushbutton columns
const char Sapb_Text[][38] = 
{
   "  Save All Modified Data  ",       // English
   " Guarde Todos Los Cambios ",       // Espanol
   "    保存所有修改的数据    ",          // Zhongwen
   "  Lưu Tất Cả Các Sửa Đổi  ",       // TiengViet
} ;

//**************************************
//** Metadata fields' Column Headings **
//**************************************
const short stdFIELD = 32 ;     // display width for standard field
const short yearFIELD = 6 ;     // display width for 'year' field (YYYY)

//* Blank tag-data field. Used for padding and data positioning.*
const char* const baseField = "                                " ;

//* Tag Field Headings (same order as enum TagFields) *
const char* const umwHeaders[][tfCOUNT] =
{
   {  // English
      "Title                             ",     // tfTit2
      "Artist                            ",     // tfTpe1
      "Album                             ",     // tfTalb
      "Track      ",                            // tfTrck (in 2 sections)
      "Year    ",                               // tfTyer (4-digits)
      "Genre                             ",     // tfTcon (code from list or free-form)
      "Guest Artist or Group             ",     // tfTpe2
      "Record Label, Publisher           ",     // tfTpub
      "Composer(s)                       ",     // tfTcom
      "Lyricist                          ",     // tfText
      "Remixed by                        ",     // tfTpe4
      "Copyright Message                 ",     // tfTcop
      "Content owner/licensee            ",     // tfTown
      "Comment                           ",     // tfTxxx
      "Record Date                       ",     // tfTdat
      "Record Time                       ",     // tfTime
      "Record Date Supplement            ",     // tfTrda
      "Playback Time (mSec)              ",     // tfTlen
      "Audio Data Size                   ",     // tfTsiz
      "Beats Per Minute                  ",     // tfTbpm
      "Content Group                     ",     // tfTit1
      "Subtitle                          ",     // tfTit3
      "Conductor                         ",     // tfTpe3
      "Part Of Set                       ",     // tfTpos
      "Initial Key                       ",     // tfTkey
      "Language                          ",     // tfTlan
      "Original Artist                   ",     // tfTope
      "Original Album                    ",     // tfToal
      "Original Filename                 ",     // tfTofn
      "Original Lyricist                 ",     // tfToly
      "Original Release Year             ",     // tfTory
      "Internet Radio Station Name       ",     // tfTrsn
      "Internet Radio Station Owner      ",     // tfTrso
      "ISRC Recording Code               ",     // tfTSRC
      "Software/Hardware Settings        ",     // tfTsee
      "File Type                         ",     // tfTflt
      "Playlist Delay                    ",     // tfTdly
      "Encoded By                        ",     // tfTenc
      "Media Type                        ",     // tfTmed

      //** Insert new fields here **
   },
   {  // Espanol
      "Título                            ",     // tfTit2
      "Artista                           ",     // tfTpe1
      "Álbum                             ",     // tfTalb
      "Pista      ",                            // tfTrck (in 2 sections)
      "Año     ",                               // tfTyer (4-digits)
      "Género                            ",     // tfTcon (code from list or free-form)
      "Artista o grupo invitado          ",     // tfTpe2
      "Etiqueta de disco, Editores       ",     // tfTpub
      "Creador de la música              ",     // tfTcom
      "Letrista                          ",     // tfText
      "Remixado por                      ",     // tfTpe4
      "Informacion Registrada            ",     // tfTcop
      "Contenido poseedor/Licenciatario  ",     // tfTown
      "Comentarios                       ",     // tfTxxx
      "Fecha de grabación                ",     // tfTdat
      "Tiempo de grabación               ",     // tfTime
      "Fecha (hecho suplementario)       ",     // tfTrda
      "Reproducción (milisegundos)       ",     // tfTlen
      "Tamaño de los datos de audio      ",     // tfTsiz
      "Latidos por minuto                ",     // tfTbpm
      "Clasificación de contenidos       ",     // tfTit1
      "Subtitular                        ",     // tfTit3
      "Director de orquesta              ",     // tfTpe3
      "Secuencia en un conjunto          ",     // tfTpos
      "Llave musical                     ",     // tfTkey
      "Idioma                            ",     // tfTlan
      "Artista Original                  ",     // tfTope
      "Álbum Original                    ",     // tfToal
      "Nombre de Archivo Original        ",     // tfTofn
      "Letrista Original                 ",     // tfToly
      "Año Originalmente Lanzado         ",     // tfTory
      "Nombre de la Estación de Radio    ",     // tfTrsn
      "Dueño de la estación de radio     ",     // tfTrso
      "ISRC Grabación de Código          ",     // tfTSRC
      "Configuración equipos/software    ",     // tfTsee
      "Tipo de Archivo                   ",     // tfTflt
      "Retardo Entre Pistas              ",     // tfTdly
      "Audio codificado por              ",     // tfTenc
      "Tipo de Medio                     ",     // tfTmed

      //** Insert new fields here **
   },
   {  // Zhongwen
      "歌名                              ",     // tfTit2
      "艺术家                            ",     // tfTpe1
      "专辑                              ",     // tfTalb
      "曲目       ",                            // tfTrck (in 2 sections)
      "年发布  ",                               // tfTyer (4-digits)
      "类型                              ",     // tfTcon (code from list or free-form)
      "嘉宾表演者或团体                  ",       // tfTpe2
      "唱片公司/出版商                   ",       // tfTpub
      "作曲家                            ",     // tfTcom
      "歌词作家                          ",     // tfText
      "再混合                            ",     // tfTpe4
      "版权信息                          ",      // tfTcop
      "内容所有者或被许可人              ",        // tfTown
      "注释                              ",     // tfTxxx
      "录制日期                          ",      // tfTdat
      "录音时间                          ",      // tfTime
      "额外的日期信息                    ",       // tfTrda
      "播放歌曲的时间 (毫秒)             ",        // tfTlen
      "音频数据的大小                    ",       // tfTsiz
      "每分钟跳动                        ",      // tfTbpm
      "组分类                            ",     // tfTit1
      "字幕                              ",     // tfTit3
      "乐团指挥                          ",     // tfTpe3
      "序列在一组项目中                  ",       // tfTpos
      "音乐键                            ",     // tfTkey
      "语言                              ",     // tfTlan
      "原创艺术家                        ",       // tfTope
      "原创专辑                          ",       // tfToal
      "原始文件名                        ",       // tfTofn
      "原创歌词作家                      ",       // tfToly
      "年最初发布                        ",       // tfTory
      "互联网广播电台 名称               ",        // tfTrsn
      "互联网广播电台 业主               ",        // tfTrso
      "ISRC 记录代码                     ",      // tfTSRC
      "软件和硬件的设置                  ",       // tfTsee
      "文件类型                          ",      // tfTflt
      "播放列表延迟                      ",       // tfTdly
      "数据编码                          ",      // tfTenc
      "媒体类型                          ",      // tfTmed

      //** Insert new fields here **
   },
   {  // TiengViet
      "Tên Bài Hát                       ",     // tfTit2
      "Nghệ Sĩ Biểu Diễn                 ",     // tfTpe1
      "Tập ảnh                           ",       // tfTalb
      "Chữ số     ",                            // tfTrck (in 2 sections)
      "Năm     ",                               // tfTyer (4-digits)
      "Thể loại âm nhạc                  ",     // tfTcon (code from list or free-form)
      "Nghệ Sĩ Khách Mời Hoặc Nhóm       ",     // tfTpe2
      "Hãng Thu âm, Xuất Bản             ",     // tfTpub
      "Người Soạn Nhạc                   ",     // tfTcom
      "Nhà Thi Sĩ Chuyên Viết Thơ Tình   ",     // tfText
      "Máy trộn nhạc                     ",     // tfTpe4
      "Tin nhắn bản quyền                ",     // tfTcop
      "Chủ sở hữu / người được cấp phép  ",     // tfTown
      "Bình Luận                         ",     // tfTxxx
      "Ngày ghi âm                       ",     // tfTdat
      "Thời gian ghi âm                  ",     // tfTime
      "Thông tin bổ sung ngày tháng      ",     // tfTrda
      "Thời gian phát (mili giây)        ",     // tfTlen
      "Kích thước dữ liệu âm thanh       ",     // tfTsiz
      "Số lượng nhịp mỗi phút            ",     // tfTbpm
      "Nhóm nội dung                     ",     // tfTit1
      "Phụ đề                            ",     // tfTit3
      "Nhạc trưởng                       ",     // tfTpe3
      "Thành viên của một bộ             ",     // tfTpos
      "Phím nhạc                         ",     // tfTkey
      "Ngôn ngữ                          ",     // tfTlan
      "Nghệ sĩ đầu tiên                  ",     // tfTope
      "Tập tem đầu tiên                  ",      // tfToal
      "Tên tập tin gốc                   ",     // tfTofn
      "Nhà thơ trữ tình gốc              ",     // tfToly
      "Năm phát hành ban đầu             ",     // tfTory
      "Tên Đài phát thanh Internet       ",     // tfTrsn
      "Chủ nhân Đài phát thanh Internet  ",     // tfTrso
      "ISRC Mã số để ghi âm              ",     // tfTSRC
      "Cấu hình phần mềm và phần cứng    ",     // tfTsee
      "Loại tệp                          ",     // tfTflt
      "Danh sách phát sự chậm trễ        ",     // tfTdly
      "Dữ liệu được định dạng bởi        ",     // tfTenc
      "Loại phương tiện truyền thông     ",     // tfTmed

      //** Insert new fields here **
   },
} ;

//* Basic navigation help. See InitStaticDisplay() *
const char navHelp[4][150] = 
{  // English
   "Navigation: %C%C%C%C or mouse wheel\n"
   "      Edit: Press SPACE key or\n"
   "            Click on target field",
   // Espanol
   "Navegación: %C%C%C%C o rueda de ratón\n"
   "  Corregir: Presione ESPACIO, o clic\n"
   "            en el campo de objectivo",
   // Zhongwen
   "导航 : %C%C%C%C 要不然 鼠标滚轮\n"
   "编辑 : 按 空格键 要不然\n"
   "       单击目标字段",
   // TiengViet
   "Điều Hướng: %C%C%C%C hoặc là bánh xe chuột\n"
   "Chỉnh sửa : Bấm phím không gian, hoặc\n"
   "            nhấp vào trường mục tiêu",
} ;


//* Application-specific clipboard access key assignments  *
//* Note that all of these keycodes are of type wktFUNKEY, *
//* that is, they are classified as 'function keys' by     *
//* the ncurses system library.                            *
enum dsClipboardAccess : wchar_t
{
   caSELECT_RIGHT  = nckSRIGHT,  // Shift+RightArrow (select rightward)
   caSELECT_LEFT   = nckSLEFT,   // Shift+LeftArrow  (select leftward)
   caSELECT_ALL    = nckC_A,     // CTRL+A           (select all)
   caCOPY_SELECTED = nckC_C,     // CTRL+C           (copy selected, (or all))
   caCUT_SELECTED  = nckC_X,     // CTRL+X           (cut selected, (or all))
   caPASTE         = nckC_V      // CTRL+V           (paste clipboard)
} ;

